% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_rl.R
\name{extract_rl}
\alias{extract_rl}
\title{Extract relative luminance}
\usage{
extract_rl(
  r,
  z,
  a,
  sky_points,
  no_of_points = 20,
  z_thr = 2,
  use_window = TRUE
)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}. A normalized greyscale image. Typically,
the blue channel extracted from a canopy photograph. Please see
\code{\link{read_caim}} and \code{\link{normalize}}.}

\item{z}{\linkS4class{SpatRaster} built with \code{\link{zenith_image}}.}

\item{a}{\linkS4class{SpatRaster} built with \code{\link{azimuth_image}}.}

\item{sky_points}{An object of class \emph{data.frame}. The result of a call
to \code{\link{extract_sky_points}}. As an alternative, both
\href{https://imagej.nih.gov/ij/download.html}{ImageJ} and HSP software
package \insertCite{Lang2013}{rcaiman} can be used to manually digitize
points. See \code{\link{extract_dn}} and
\code{\link{read_manual_input}} for details.}

\item{no_of_points}{Numeric vector on length one. The number of near-zenith
points required for the estimation of the zenith DN.}

\item{z_thr}{Numeric vector on length one. The starting maximum zenith angle
used to search for near-zenith points.}

\item{use_window}{Logical vector of length one. If \code{TRUE}, a \eqn{3
\times 3} window will be used to extract the sky digital number from
\code{r}.}
}
\value{
A list of three objects, \emph{zenith_dn} and \emph{max_zenith_angle}
 from the class \emph{numeric}, and \emph{sky_points} from the class
 \emph{data.frame}; \emph{zenith_dn} is the estimated zenith digital number,
 \emph{max_zenith_angle} is the maximum zenith angle reached in the search
 for near-zenith sky points, and \emph{sky_points} is the input argument
 \code{sky_points} with the additional columns: \emph{a}, \emph{z},
 \emph{dn}, and \emph{rl}, which stand for azimuth and zenith angle in
 degrees, digital number, and relative luminance, respectively. If
 \code{NULL} is provided as \code{no_of_points}, then \emph{zenith_dn} is
 forced to one and \emph{dn}, and \emph{rl} are equals.
}
\description{
Extract the luminance relative to the zenith digital number.
}
\details{
The search for near-zenith points starts in the region  ranged between
\code{0} and \code{z_thr}. If the number of near-zenith points is less than
\code{no_of_points}, the region increases by steps of \code{2} degrees of
zenith angle till the required number of points is reached.
}
\examples{
\dontrun{
path <- system.file("external/DSCN4500.JPG", package = "rcaiman")
caim <- read_caim(path, c(1280, 960) - 745, 745 * 2, 745 * 2)
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
a <- azimuth_image(z)
r <- gbc(caim$Blue)
g <- sky_grid_segmentation(z, a, 10)
bin <- find_sky_pixels(r, z, a)
sky_points <- extract_sky_points(r, bin, g)
rl <- extract_rl(r, z, a, sky_points, 1)
}
}
\references{
\insertAllCited{}
}
\seealso{
Other Tool Functions: 
\code{\link{colorfulness}()},
\code{\link{defuzzify}()},
\code{\link{extract_dn}()},
\code{\link{extract_feature}()},
\code{\link{extract_sky_points}()},
\code{\link{masking}()},
\code{\link{read_bin}()},
\code{\link{read_caim}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tool Functions}
