% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zenith_azimuth_from_row_col.R
\name{zenith_azimuth_from_row_col}
\alias{zenith_azimuth_from_row_col}
\title{Zenith and azimuth angles from row and col numbers}
\usage{
zenith_azimuth_from_row_col(z, row_col, lens_coef)
}
\arguments{
\item{z}{\linkS4class{SpatRaster} built with \code{\link{zenith_image}}.}

\item{row_col}{Numeric vector of length two. Row and col numbers.}

\item{lens_coef}{Numeric vector. Polynomial coefficients of the lens
projection function.}
}
\value{
Numeric vector of length two.
}
\description{
Zenith and azimuth angles from row and col numbers
}
\examples{
z <- zenith_image(1000, lens_coef = lens())
zenith_azimuth_from_row_col(z, c(501, 750), lens())
}
\seealso{
Other HSP Functions: 
\code{\link{read_manual_input}()},
\code{\link{read_opt_sky_coef}()},
\code{\link{row_col_from_zenith_azimuth}()},
\code{\link{write_sky_points}()},
\code{\link{write_sun_coord}()}
}
\concept{HSP Functions}
