% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_vignetting.R
\name{correct_vignetting}
\alias{correct_vignetting}
\title{Correct vignetting effect}
\usage{
correct_vignetting(r, z, lens_coef_v)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}. A fish-eye image.}

\item{z}{\linkS4class{SpatRaster} built with \code{\link[=zenith_image]{zenith_image()}}.}

\item{lens_coef_v}{Numeric vector. Coefficients of a vignetting
function (\eqn{f_v}) of the type \eqn{f_v = 1 + a \cdot \theta +
  b \cdot \theta^2 + ... + m \cdot \theta^n}, where \eqn{\theta} is the
zenith angle, \eqn{a, b, c} and \eqn{m} are the coefficients. The maximum
polynomial degree supported is fifth. See \code{\link[=extract_radiometry]{extract_radiometry()}} for
additional details.}
}
\value{
The argument \code{r} but with corrected values.
}
\description{
Correct vignetting effect
}
\examples{
path <- system.file("external/DSCN4500.JPG", package = "rcaiman")
caim <- read_caim(path, c(1250, 1020) - 745, 745 * 2, 745 * 2)
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
r <- gbc(caim$Blue)
r
r <- correct_vignetting(r, z, c(0.0638, -0.101))
r
}
\seealso{
Other Tool Functions: 
\code{\link{colorfulness}()},
\code{\link{defuzzify}()},
\code{\link{extract_dn}()},
\code{\link{extract_feature}()},
\code{\link{extract_rl}()},
\code{\link{extract_sky_points_simple}()},
\code{\link{extract_sky_points}()},
\code{\link{extract_sun_coord}()},
\code{\link{find_sky_pixels_nonnull}()},
\code{\link{find_sky_pixels}()},
\code{\link{masking}()},
\code{\link{optim_normalize}()},
\code{\link{percentage_of_clipped_highlights}()},
\code{\link{read_bin}()},
\code{\link{read_caim_raw}()},
\code{\link{read_caim}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tool Functions}
