/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.renderer.Renderer2D;
import org.openscience.cdk.renderer.Renderer2DModel;
import org.openscience.cdk.tools.manipulator.AtomContainerSetManipulator;

public class DrawingPanel
extends JPanel {
    private static final long serialVersionUID = -7896336271183337200L;
    private JChemPaintModel jchemPaintModel;
    private Renderer2D r2d;
    private Dimension oldPreferredSize = null;
    public boolean drawingNow = false;

    void setJChemPaintModel(JChemPaintModel model) {
        this.jchemPaintModel = model;
        this.r2d = new Renderer2D(this.jchemPaintModel.getRendererModel());
        this.r2d.setRenderer2DModel(this.jchemPaintModel.getRendererModel());
        this.revalidate();
    }

    public void updateRingSetInRenderer() {
        this.r2d.redoSSSR(AtomContainerSetManipulator.getAllAtomContainers((IAtomContainerSet)this.jchemPaintModel.getChemModel().getMoleculeSet()));
    }

    public void paint(Graphics g) {
        this.setBackground(this.jchemPaintModel.getRendererModel().getBackColor());
        if (this.jchemPaintModel == null) {
            return;
        }
        this.drawingNow = true;
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        Renderer2DModel model = this.jchemPaintModel.getRendererModel();
        if (model.getUseAntiAliasing()) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.r2d.paintChemModel(this.jchemPaintModel.getChemModel(), g2d);
        this.drawingNow = false;
        if (!this.getPreferredSize().equals(this.oldPreferredSize)) {
            this.oldPreferredSize = this.getPreferredSize();
            this.setSize(this.getPreferredSize());
        }
    }

    public Dimension getPreferredSize() {
        if (this.jchemPaintModel == null) {
            return new Dimension(794, 1123);
        }
        return this.jchemPaintModel.getRendererModel().getBackgroundDimension();
    }
}

