/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.vecmath.Point2d;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class CreateReactionAction
extends JCPAction {
    private static final long serialVersionUID = -7625810885316702776L;

    public void actionPerformed(ActionEvent event) {
        IChemObject object = this.getSource(event);
        logger.debug((Object)"CreateReaction action");
        JChemPaintModel jcpmodel = this.jcpPanel.getJChemPaintModel();
        IChemModel model = jcpmodel.getChemModel();
        IReactionSet reactionSet = model.getReactionSet();
        if (reactionSet == null) {
            reactionSet = model.getBuilder().newReactionSet();
        }
        IAtomContainer container = null;
        if (object instanceof IAtom) {
            container = ChemModelManipulator.getRelevantAtomContainer((IChemModel)model, (IAtom)((IAtom)object));
        } else {
            logger.error((Object)("Cannot add to reaction object of type: " + object.getClass().getName()));
        }
        if (container == null) {
            logger.error((Object)"Cannot find container to add object to!");
        } else {
            String selectedReactionID;
            String s;
            Object[] ids;
            IAtomContainer newContainer;
            try {
                newContainer = (IAtomContainer)container.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)"Could not clone IAtomContainer: ", (Object)e.getMessage());
                logger.debug((Object)e);
                return;
            }
            Iterator atoms = container.atoms();
            while (atoms.hasNext()) {
                ChemModelManipulator.removeAtomAndConnectedElectronContainers((IChemModel)model, (IAtom)((IAtom)atoms.next()));
            }
            logger.debug((Object)"Deleted atom from old container...");
            IReaction reaction = model.getBuilder().newReaction();
            reaction.setID("reaction-" + System.currentTimeMillis());
            logger.debug((Object)"type: ", (Object)this.type);
            if ("addReactantToNew".equals(this.type)) {
                reaction.addReactant(model.getBuilder().newMolecule(newContainer));
                reactionSet.addReaction(reaction);
            } else if ("addReactantToExisting".equals(this.type)) {
                if (reactionSet.getReactionCount() == 0) {
                    logger.warn((Object)"Cannot add to reaction if no one exists");
                    return;
                }
                ids = this.getReactionIDs(reactionSet);
                s = (String)JOptionPane.showInputDialog(null, "Reaction Chooser", "Choose reaction to add reaction to", -1, null, ids, ids[0]);
                if (s != null && s.length() > 0) {
                    selectedReactionID = s;
                    reaction = this.getReaction(reactionSet, selectedReactionID);
                    reaction.addReactant(model.getBuilder().newMolecule(newContainer));
                } else {
                    logger.error((Object)"No reaction selected");
                }
            } else if ("addProductToNew".equals(this.type)) {
                reaction.addProduct(model.getBuilder().newMolecule(newContainer));
                reactionSet.addReaction(reaction);
            } else if ("addProductToExisting".equals(this.type)) {
                if (reactionSet.getReactionCount() == 0) {
                    logger.warn((Object)"Cannot add to reaction if no one exists");
                    return;
                }
                ids = this.getReactionIDs(reactionSet);
                s = (String)JOptionPane.showInputDialog(null, "Reaction Chooser", "Choose reaction to add reaction to", -1, null, ids, ids[0]);
                if (s != null && s.length() > 0) {
                    selectedReactionID = s;
                    reaction = this.getReaction(reactionSet, selectedReactionID);
                    reaction.addProduct(model.getBuilder().newMolecule(newContainer));
                } else {
                    logger.error((Object)"No reaction selected");
                }
            } else {
                logger.warn((Object)("Don't know about this action type: " + this.type));
                return;
            }
        }
        model.setReactionSet(reactionSet);
        for (int i = 0; i < reactionSet.getReactionCount(); ++i) {
            int k;
            for (k = 0; k < reactionSet.getReaction(i).getProductCount(); ++k) {
                for (int l = 0; l < reactionSet.getReaction(i).getProducts().getAtomContainer(k).getAtomCount(); ++l) {
                    if (jcpmodel.getRendererModel().getRenderingCoordinates().get(reactionSet.getReaction(i).getProducts().getAtomContainer(k).getAtom(l)) != null) continue;
                    jcpmodel.getRendererModel().getRenderingCoordinates().put(reactionSet.getReaction(i).getProducts().getAtomContainer(k).getAtom(l), new Point2d(reactionSet.getReaction(i).getProducts().getAtomContainer(k).getAtom(l).getPoint2d()));
                }
            }
            for (k = 0; k < reactionSet.getReaction(i).getReactantCount(); ++k) {
                for (int l = 0; l < reactionSet.getReaction(i).getReactants().getAtomContainer(k).getAtomCount(); ++l) {
                    if (jcpmodel.getRendererModel().getRenderingCoordinates().get(reactionSet.getReaction(i).getReactants().getAtomContainer(k).getAtom(l)) != null) continue;
                    jcpmodel.getRendererModel().getRenderingCoordinates().put(reactionSet.getReaction(i).getReactants().getAtomContainer(k).getAtom(l), new Point2d(reactionSet.getReaction(i).getReactants().getAtomContainer(k).getAtom(l).getPoint2d()));
                }
            }
        }
    }

    private Object[] getReactionIDs(IReactionSet reactionSet) {
        if (reactionSet != null) {
            Object[] ids = new String[reactionSet.getReactionCount()];
            for (int i = 0; i < reactionSet.getReactionCount(); ++i) {
                ids[i] = reactionSet.getReaction(i).getID();
            }
            return ids;
        }
        return new String[0];
    }

    private IReaction getReaction(IReactionSet reactionSet, String id) {
        Iterator reactionIter = reactionSet.reactions();
        while (reactionIter.hasNext()) {
            IReaction reaction = (IReaction)reactionIter.next();
            if (!reaction.getID().equals(id)) continue;
            return reaction;
        }
        return null;
    }
}

