/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public class AdfReader
extends AtomSetCollectionReader {
    String energy = null;

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.atomSetCollection = new AtomSetCollection("ADF");
        this.reader = reader;
        boolean iHaveAtoms = false;
        this.modelNumber = 0;
        try {
            while (this.readLine() != null) {
                if (this.line.indexOf("Coordinates (Cartesian)") >= 0) {
                    if (++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0) {
                        if (!iHaveAtoms) continue;
                        break;
                    }
                    iHaveAtoms = true;
                    this.readCoordinates();
                    continue;
                }
                if (this.line.indexOf("Energy:") >= 0) {
                    String[] tokens = this.getTokens(this.line);
                    this.energy = tokens[1];
                    continue;
                }
                if (this.line.indexOf("Vibrations") < 0) continue;
                this.readFrequencies();
            }
        }
        catch (Exception e) {
            Logger.error("Could not read file at line: " + this.line, e);
        }
        return this.atomSetCollection;
    }

    private void readCoordinates() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName("" + this.energy);
        this.discardLinesUntilStartsWith(" -----");
        while (this.readLine() != null && !this.line.startsWith(" -----")) {
            String symbol;
            String[] tokens = this.getTokens(this.line);
            if (tokens.length < 5 || JmolConstants.elementNumberFromSymbol(symbol = tokens[1]) < 1) continue;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = symbol;
            atom.x = this.parseFloat(tokens[2]) * 0.5291772f;
            atom.y = this.parseFloat(tokens[3]) * 0.5291772f;
            atom.z = this.parseFloat(tokens[4]) * 0.5291772f;
        }
    }

    private void readFrequencies() throws Exception {
        this.readLine();
        int atomCount = this.atomSetCollection.getLastAtomSetAtomCount();
        while (this.readLine() != null) {
            while (this.readLine() != null && this.line.indexOf(".") < 0 && this.line.indexOf("====") < 0) {
            }
            if (this.line == null || this.line.indexOf(".") < 0) {
                return;
            }
            String[] frequencies = this.getTokens(this.line);
            this.readLine();
            int frequencyCount = frequencies.length;
            int firstModelAtom = this.atomSetCollection.atomCount;
            for (int i = 0; i < frequencyCount; ++i) {
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetName(frequencies[i] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty("Frequency", frequencies[i] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty(".PATH", "Frequencies");
            }
            int atomPt = 0;
            while (this.readLine() != null && this.line.indexOf(".") >= 0) {
                String[] tokens = this.getTokens(this.line);
                String symbol = tokens[0].substring(tokens[0].indexOf(".") + 1);
                if (JmolConstants.elementNumberFromSymbol(symbol) < 1) continue;
                int offset = 1;
                for (int j = 0; j < frequencyCount; ++j) {
                    int atomOffset = firstModelAtom + j * atomCount + atomPt;
                    Atom atom = this.atomSetCollection.atoms[atomOffset];
                    float x = this.parseFloat(tokens[offset++]);
                    float y = this.parseFloat(tokens[offset++]);
                    float z = this.parseFloat(tokens[offset++]);
                    atom.addVibrationVector(x, y, z);
                }
                ++atomPt;
            }
        }
    }
}

