/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.guha.rcdk.view.RcdkDepictor;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.InChIGenerator;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.io.SDFWriter;
import org.openscience.cdk.io.SMILESReader;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.listener.PropertiesListener;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.smsd.Isomorphism;
import org.openscience.cdk.smsd.interfaces.Algorithm;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

public class Misc {
    public static void writeMoleculesInOneFile(IAtomContainer[] molecules, String filename, int writeProps) throws Exception {
        SDFWriter writer = new SDFWriter((Writer)new FileWriter(new File(filename)));
        Properties props = new Properties();
        props.put("WriteAromaticBondTypes", "true");
        if (writeProps == 0) {
            props.put("writeProperties", "false");
        }
        PropertiesListener listener = new PropertiesListener(props);
        writer.addChemObjectIOListener((IChemObjectIOListener)listener);
        writer.customizeJob();
        for (IAtomContainer molecule : molecules) {
            writer.write((IChemObject)molecule);
        }
        writer.close();
    }

    public static void writeMolecules(IAtomContainer[] molecules, String prefix, int writeProps) throws Exception {
        int counter = 1;
        for (IAtomContainer molecule : molecules) {
            String filename = prefix + counter + ".sdf";
            SDFWriter writer = new SDFWriter((Writer)new FileWriter(new File(filename)));
            Properties props = new Properties();
            props.put("WriteAromaticBondTypes", "true");
            if (writeProps == 0) {
                props.put("writeProperties", "false");
            }
            PropertiesListener listener = new PropertiesListener(props);
            writer.addChemObjectIOListener((IChemObjectIOListener)listener);
            writer.customizeJob();
            writer.write((IChemObject)molecule);
            writer.close();
            ++counter;
        }
    }

    public static void setProperty(IAtomContainer molecule, String key, Object value) {
        molecule.setProperty((Object)key, value);
    }

    public static void setProperty(IAtomContainer molecule, String key, int value) {
        Misc.setProperty(molecule, key, new Integer(value));
    }

    public static void setProperty(IAtomContainer molecule, String key, double value) {
        Misc.setProperty(molecule, key, new Double(value));
    }

    public static Object getProperty(IAtomContainer molecule, String key) {
        return molecule.getProperty((Object)key);
    }

    public static void removeProperty(IAtomContainer molecule, String key) {
        molecule.removeProperty((Object)key);
    }

    public static String getSmiles(IAtomContainer container, String type, boolean aromatic, boolean atomClasses) throws CDKException {
        SmilesGenerator smigen;
        switch (type) {
            case "generic": {
                smigen = SmilesGenerator.generic();
                break;
            }
            case "unique": {
                smigen = SmilesGenerator.unique();
                break;
            }
            case "isomeric": {
                smigen = SmilesGenerator.isomeric();
                break;
            }
            default: {
                smigen = SmilesGenerator.absolute();
            }
        }
        if (aromatic) {
            smigen = smigen.aromatic();
        }
        if (atomClasses) {
            smigen = smigen.withAtomClasses();
        }
        return smigen.create(container);
    }

    public static IAtomContainer[] loadMolecules(String[] filenames, boolean doAromaticity, boolean doTyping, boolean doIsotopes) throws CDKException, IOException {
        int i;
        Vector v = new Vector();
        IChemObjectBuilder builder = DefaultChemObjectBuilder.getInstance();
        try {
            for (int i2 = 0; i2 < filenames.length; ++i2) {
                IChemFile content;
                ReaderFactory readerFactory = new ReaderFactory();
                File input = new File(filenames[i2]);
                ISimpleChemObjectReader reader = readerFactory.createReader((Reader)new FileReader(input));
                if (reader == null && filenames[i2].endsWith(".smi")) {
                    reader = new SMILESReader((Reader)new FileReader(input));
                }
                if ((content = (IChemFile)reader.read((IChemObject)builder.newInstance(IChemFile.class, new Object[0]))) == null) continue;
                List c = ChemFileManipulator.getAllAtomContainers((IChemFile)content);
                v.addAll(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CDKException(e.toString());
        }
        IAtomContainer[] retValues = new IAtomContainer[v.size()];
        for (i = 0; i < v.size(); ++i) {
            retValues[i] = (IAtomContainer)v.get(i);
        }
        if (doTyping) {
            for (i = 0; i < retValues.length; ++i) {
                try {
                    AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)retValues[i]);
                    continue;
                }
                catch (CDKException e) {
                    retValues[i] = null;
                }
            }
        }
        if (doAromaticity) {
            for (i = 0; i < retValues.length; ++i) {
                try {
                    CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)retValues[i]);
                    continue;
                }
                catch (CDKException e) {
                    retValues[i] = null;
                }
            }
        }
        if (doIsotopes) {
            Isotopes ifac = Isotopes.getInstance();
            for (IAtomContainer retValue : retValues) {
                ifac.configureAtoms(retValue);
            }
        }
        return retValues;
    }

    public static IAtomContainer getMoleculeWithCoordinates(IAtomContainer molecule) throws Exception {
        StructureDiagramGenerator sdg = new StructureDiagramGenerator();
        sdg.setMolecule(molecule);
        sdg.generateCoordinates();
        return sdg.getMolecule();
    }

    public static IAtomContainer getMcsAsNewContainerUIT(IAtomContainer mol1, IAtomContainer mol2) throws CDKException, CloneNotSupportedException {
        UniversalIsomorphismTester uit = new UniversalIsomorphismTester();
        List overlaps = uit.getOverlaps(mol1, mol2);
        int maxmcss = -9999999;
        IAtomContainer maxac = null;
        for (IAtomContainer ac : overlaps) {
            if (ac.getAtomCount() <= maxmcss) continue;
            maxmcss = ac.getAtomCount();
            maxac = ac;
        }
        return maxac;
    }

    public static IAtomContainer getMcsAsNewContainer(IAtomContainer mol1, IAtomContainer mol2) throws CDKException, CloneNotSupportedException {
        Isomorphism mcs = new Isomorphism(Algorithm.DEFAULT, true);
        mcs.init(mol1, mol2, true, true);
        mcs.setChemFilters(true, true, true);
        mol1 = mcs.getReactantMolecule();
        mol2 = mcs.getProductMolecule();
        IAtomContainer mcsmolecule = (IAtomContainer)DefaultChemObjectBuilder.getInstance().newInstance(IAtomContainer.class, new Object[]{mol1});
        ArrayList<IAtom> atomsToBeRemoved = new ArrayList<IAtom>();
        for (IAtom atom : mcsmolecule.atoms()) {
            int index = mcsmolecule.getAtomNumber(atom);
            if (mcs.getFirstMapping().containsKey(index)) continue;
            atomsToBeRemoved.add(atom);
        }
        for (IAtom atom : atomsToBeRemoved) {
            mcsmolecule.removeAtomAndConnectedElectronContainers(atom);
        }
        return mcsmolecule;
    }

    public static int[][] getMcsAsAtomIndexMapping(IAtomContainer mol1, IAtomContainer mol2) throws CDKException {
        Isomorphism mcs = new Isomorphism(Algorithm.DEFAULT, true);
        mcs.init(mol1, mol2, true, true);
        mcs.setChemFilters(true, true, true);
        int mcsSize = mcs.getFirstMapping().size();
        int[][] mapping = new int[mcsSize][2];
        int i = 0;
        for (Map.Entry map : mcs.getFirstMapping().entrySet()) {
            mapping[i][0] = (Integer)map.getKey();
            mapping[i][1] = (Integer)map.getValue();
            ++i;
        }
        return mapping;
    }

    public static String getInChi(IAtomContainer mol) throws CDKException {
        InChIGeneratorFactory factory = InChIGeneratorFactory.getInstance();
        factory.setIgnoreAromaticBonds(true);
        InChIGenerator gen = factory.getInChIGenerator(mol);
        return gen.getInchi();
    }

    public static String getInChiKey(IAtomContainer mol) throws CDKException {
        InChIGeneratorFactory factory = InChIGeneratorFactory.getInstance();
        factory.setIgnoreAromaticBonds(true);
        InChIGenerator gen = factory.getInChIGenerator(mol);
        return gen.getInchiKey();
    }

    public static RcdkDepictor getDefaultDepictor() throws IOException {
        return new RcdkDepictor(300, 300, 1.3, "cow", "off", "on", true, false, 100, "");
    }

    public static void main(String[] args) throws Exception, CloneNotSupportedException, IOException {
        IAtomContainer[] mols = Misc.loadMolecules(new String[]{"/Users/guhar/Downloads/Benzene.sdf"}, true, true, true);
        SmilesParser sp = new SmilesParser(DefaultChemObjectBuilder.getInstance());
        IAtomContainer mol1 = sp.parseSmiles("c1cccc(COC(=O)NC(CC(C)C)C(=O)NC(CCc2ccccc2)C(=O)COC)c1");
        IAtomContainer mol2 = sp.parseSmiles("c1cccc(COC(=O)NC(CC(C)C)C(=O)NCC#N)c1");
        CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)mol1);
        CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)mol2);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)mol2);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)mol1);
        int[][] map = Misc.getMcsAsAtomIndexMapping(mol1, mol2);
        for (int i = 0; i < map.length; ++i) {
            System.out.println(map[i][0] + " <-> " + map[i][1]);
        }
    }
}

