/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import java.util.StringTokenizer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.io.cml.CMLCoreModule;
import org.openscience.cdk.io.cml.CMLStack;
import org.openscience.cdk.io.cml.ICMLModule;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.BooleanResult;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerArrayResult;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.xml.sax.Attributes;

public class QSARConvention
extends CMLCoreModule {
    private String currentDescriptorAlgorithmSpecification;
    private String currentDescriptorImplementationTitel;
    private String currentDescriptorImplementationVendor;
    private String currentDescriptorImplementationIdentifier;
    private String currentDescriptorDataType;
    private String currentDescriptorResult;
    private boolean currentDescriptorDataIsArray;

    public QSARConvention(IChemFile chemFile) {
        super(chemFile);
    }

    public QSARConvention(ICMLModule conv) {
        super(conv);
    }

    @Override
    public void startElement(CMLStack xpath, String uri, String local, String raw, Attributes atts) {
        if (xpath.endsWith("molecule", "propertyList", "property")) {
            this.currentDescriptorDataIsArray = false;
            this.currentDescriptorAlgorithmSpecification = "";
            this.currentDescriptorImplementationTitel = "";
            this.currentDescriptorImplementationVendor = "";
            this.currentDescriptorImplementationIdentifier = "";
            this.currentDescriptorDataType = "";
            this.currentDescriptorResult = "";
        } else if (xpath.endsWith("property", "metadataList", "metadata")) {
            super.startElement(xpath, uri, local, raw, atts);
            if (this.DICTREF.equals("qsar:specificationReference")) {
                this.currentDescriptorAlgorithmSpecification = atts.getValue("content");
            } else if (this.DICTREF.equals("qsar:implementationTitle")) {
                this.currentDescriptorImplementationTitel = atts.getValue("content");
            } else if (this.DICTREF.equals("qsar:implementationIdentifier")) {
                this.currentDescriptorImplementationIdentifier = atts.getValue("content");
            } else if (this.DICTREF.equals("qsar:implementationVendor")) {
                this.currentDescriptorImplementationVendor = atts.getValue("content");
            }
        } else if (xpath.endsWith("propertyList", "property", "scalar")) {
            this.currentDescriptorDataType = atts.getValue("dataType");
            super.startElement(xpath, uri, local, raw, atts);
        } else {
            super.startElement(xpath, uri, local, raw, atts);
        }
    }

    @Override
    public void endElement(CMLStack xpath, String uri, String local, String raw) {
        if (xpath.endsWith("molecule", "propertyList", "property")) {
            DescriptorSpecification descriptorSpecification = new DescriptorSpecification(this.currentDescriptorAlgorithmSpecification, this.currentDescriptorImplementationTitel, this.currentDescriptorImplementationIdentifier, this.currentDescriptorImplementationVendor);
            this.currentMolecule.setProperty(descriptorSpecification, new DescriptorValue(descriptorSpecification, new String[]{}, new Object[]{}, this.currentDescriptorDataIsArray ? this.newDescriptorResultArray(this.currentDescriptorResult) : this.newDescriptorResult(this.currentDescriptorResult), new String[0]));
        } else if (xpath.endsWith("property", "scalar")) {
            this.currentDescriptorResult = this.currentChars;
        } else {
            super.endElement(xpath, uri, local, raw);
        }
    }

    private IDescriptorResult newDescriptorResult(String descriptorValue) {
        IDescriptorResult result = null;
        if ("xsd:double".equals(this.currentDescriptorDataType)) {
            result = new DoubleResult(Double.parseDouble(descriptorValue));
        } else if ("xsd:integer".equals(this.currentDescriptorDataType)) {
            result = new IntegerResult(Integer.parseInt(descriptorValue));
        } else if ("xsd:boolean".equals(this.currentDescriptorDataType)) {
            result = new BooleanResult(new Boolean(descriptorValue));
        }
        return result;
    }

    private IDescriptorResult newDescriptorResultArray(String descriptorValue) {
        IDescriptorResult result;
        block3: {
            block2: {
                result = null;
                if (!"xsd:double".equals(this.currentDescriptorDataType)) break block2;
                result = new DoubleArrayResult();
                StringTokenizer tokenizer = new StringTokenizer(descriptorValue);
                while (tokenizer.hasMoreElements()) {
                    ((DoubleArrayResult)result).add(Double.parseDouble(tokenizer.nextToken()));
                }
                break block3;
            }
            if (!"xsd:integer".equals(this.currentDescriptorDataType)) break block3;
            result = new IntegerArrayResult();
            StringTokenizer tokenizer = new StringTokenizer(descriptorValue);
            while (tokenizer.hasMoreElements()) {
                ((IntegerArrayResult)result).add(Integer.parseInt(tokenizer.nextToken()));
            }
        }
        return result;
    }
}

