/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.layout.AtomPlacer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class HydrogenPlacer {
    public static final boolean debug = false;
    public static final boolean debug1 = false;

    public void placeHydrogens2D(IAtomContainer atomContainer, double bondLength) {
        ILoggingTool logger = LoggingToolFactory.createLoggingTool(HydrogenPlacer.class);
        logger.debug("Entering Hydrogen Placement...");
        IAtom atom = null;
        for (int f = 0; f < atomContainer.getAtomCount(); ++f) {
            atom = atomContainer.getAtom(f);
            logger.debug("Now placing hydrogens at atom " + f);
            this.placeHydrogens2D(atomContainer, atom, bondLength);
        }
        logger.debug("Hydrogen Placement finished");
    }

    public void placeHydrogens2D(IAtomContainer atomContainer, IAtom atom) {
        double bondLength = GeometryTools.getBondLengthAverage(atomContainer);
        this.placeHydrogens2D(atomContainer, atom, bondLength);
    }

    public void placeHydrogens2D(IAtomContainer atomContainer, IAtom atom, double bondLength) {
        int f;
        ILoggingTool logger = LoggingToolFactory.createLoggingTool(HydrogenPlacer.class);
        AtomPlacer atomPlacer = new AtomPlacer();
        atomPlacer.setMolecule(atomContainer);
        logger.debug("bondLength ", bondLength);
        List<IAtom> connectedAtoms = atomContainer.getConnectedAtomsList(atom);
        IAtomContainer placedAtoms = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer unplacedAtoms = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (f = 0; f < connectedAtoms.size(); ++f) {
            IAtom conAtom = connectedAtoms.get(f);
            if (conAtom.getSymbol().equals("H") && conAtom.getPoint2d() == null) {
                unplacedAtoms.addAtom(conAtom);
                continue;
            }
            placedAtoms.addAtom(conAtom);
        }
        logger.debug("Atom placement before procedure:");
        logger.debug("Center atom ", atom.getSymbol(), ": ", atom.getPoint2d());
        for (f = 0; f < unplacedAtoms.getAtomCount(); ++f) {
            logger.debug("H-" + f, ": ", unplacedAtoms.getAtom(f).getPoint2d());
        }
        Point2d centerPlacedAtoms = GeometryTools.get2DCenter(placedAtoms);
        atomPlacer.distributePartners(atom, placedAtoms, centerPlacedAtoms, unplacedAtoms, bondLength);
        logger.debug("Atom placement after procedure:");
        logger.debug("Center atom ", atom.getSymbol(), ": ", atom.getPoint2d());
        for (int f2 = 0; f2 < unplacedAtoms.getAtomCount(); ++f2) {
            logger.debug("H-" + f2, ": ", unplacedAtoms.getAtom(f2).getPoint2d());
        }
    }
}

