/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.Set;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.interfaces.IAtom;

public class SetCharge
extends AbstractEdit {
    IAtom atom;
    Integer newCharge;
    Integer oldCharge;

    public static SetCharge setCharge(IAtom atom, int charge) {
        return new SetCharge(atom, charge);
    }

    public static SetCharge clearCharge(IAtom atom) {
        return new SetCharge(atom, null);
    }

    private SetCharge(IAtom atom, Integer charge) {
        this.atom = atom;
        this.newCharge = charge;
        this.oldCharge = atom.getFormalCharge();
    }

    @Override
    public Set<Changed> getTypeOfChanges() {
        return SetCharge.changed(Changed.Properties);
    }

    @Override
    public void redo() {
        this.atom.setFormalCharge(this.newCharge);
        this.updateHydrogenCount(this.atom);
    }

    @Override
    public void undo() {
        this.atom.setFormalCharge(this.oldCharge);
        this.updateHydrogenCount(this.atom);
    }
}

