/*
 * Decompiled with CFR 0.152.
 */
package signature.chemistry;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import signature.chemistry.Molecule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoleculeReader {
    public static Molecule readMolfile(String filename) {
        Molecule molecule = null;
        try {
            String line;
            File file = new File(filename);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            ArrayList<String> block = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                block.add(line);
            }
            molecule = MoleculeReader.makeMolecule(block);
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        return molecule;
    }

    public static List<Molecule> readSDFFile(String filename) {
        File file = new File(filename);
        try {
            return MoleculeReader.readSDFfromStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            System.err.println(e.toString());
            return null;
        }
    }

    public static List<Molecule> readSDFfromStream(InputStream stream) {
        ArrayList<Molecule> molecules = new ArrayList<Molecule>();
        try {
            String line;
            InputStreamReader ir = new InputStreamReader(stream);
            BufferedReader reader = new BufferedReader(ir);
            int i = 0;
            ArrayList<String> block = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("$$$$")) {
                    try {
                        Molecule molecule = MoleculeReader.makeMolecule(block);
                        molecules.add(molecule);
                    }
                    catch (Exception e) {
                        System.err.println("failed for block " + i + " " + e);
                        e.printStackTrace();
                    }
                    block.clear();
                    ++i;
                    continue;
                }
                block.add(line);
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
        }
        return molecules;
    }

    private static Molecule makeMolecule(List<String> block) throws Exception {
        Molecule molecule = new Molecule();
        String countLine = block.get(3);
        int atomCount = Integer.parseInt(countLine.substring(0, 3).trim());
        int bondCount = Integer.parseInt(countLine.substring(3, 6).trim());
        int atomLineStart = 4;
        int atomLineEnd = atomCount + atomLineStart;
        int i = atomLineStart;
        while (i < atomLineEnd) {
            String symbol = block.get(i).substring(30, 33).trim();
            int atomIndex = i - atomLineStart;
            molecule.addAtom(atomIndex, symbol);
            ++i;
        }
        if (atomCount > 1) {
            int bondLineStart = atomLineEnd;
            int bondLineEnd = bondLineStart + bondCount;
            int i2 = bondLineStart;
            while (i2 < bondLineEnd) {
                String bondLine = block.get(i2);
                int atomNumberA = Integer.parseInt(bondLine.substring(0, 3).trim());
                int atomNumberB = Integer.parseInt(bondLine.substring(3, 6).trim());
                int order = Integer.parseInt(bondLine.substring(7, 10).trim());
                molecule.addBond(atomNumberA - 1, atomNumberB - 1, order);
                ++i2;
            }
        }
        return molecule;
    }
}

