/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;

public class ToolItem
extends Item {
    long boxHandle;
    long arrowHandle;
    long arrowBoxHandle;
    long separatorHandle;
    long labelHandle;
    long imageHandle;
    ToolBar parent;
    Control control;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    boolean drawHotImage;

    public ToolItem(ToolBar toolBar, int n) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        this.createWidget(toolBar.getItemCount());
    }

    public ToolItem(ToolBar toolBar, int n, int n2) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        int n3 = toolBar.getItemCount();
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        this.createWidget(n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return ToolItem.checkBits(n, 8, 32, 16, 2, 4, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        if ((this.style & 2) == 0) {
            long l = this.boxHandle = (this.parent.style & 0x20000) != 0 ? OS.gtk_hbox_new(false, 0) : OS.gtk_vbox_new(false, 0);
            if (this.boxHandle == 0L) {
                this.error(2);
            }
            this.labelHandle = OS.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0L) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            if (this.imageHandle == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(this.boxHandle, this.imageHandle);
            OS.gtk_container_add(this.boxHandle, this.labelHandle);
            if ((this.parent.style & 0x200) != 0) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 0);
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 2, 0);
            }
        }
        int n2 = 62;
        switch (this.style & n2) {
            case 2: {
                this.handle = OS.gtk_hbox_new(false, 0);
                if (this.handle == 0L) {
                    this.error(2);
                }
                boolean bl = (this.parent.style & 0x200) != 0;
                long l = this.separatorHandle = bl ? OS.gtk_hseparator_new() : OS.gtk_vseparator_new();
                if (this.separatorHandle == 0L) {
                    this.error(2);
                }
                OS.gtk_widget_set_size_request(this.separatorHandle, bl ? 15 : 6, bl ? 6 : 15);
                OS.gtk_widget_set_size_request(this.handle, bl ? 15 : 6, bl ? 6 : 15);
                OS.gtk_container_add(this.handle, this.separatorHandle);
                break;
            }
            case 4: {
                this.handle = OS.gtk_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                this.arrowBoxHandle = OS.gtk_hbox_new(false, 0);
                if (this.arrowBoxHandle == 0L) {
                    this.error(2);
                }
                this.arrowHandle = OS.gtk_arrow_new(1, 0);
                if (this.arrowHandle == 0L) {
                    this.error(2);
                }
                OS.gtk_widget_set_size_request(this.arrowHandle, 8, 6);
                OS.gtk_container_add(this.handle, this.arrowBoxHandle);
                OS.gtk_container_add(this.arrowBoxHandle, this.boxHandle);
                OS.gtk_container_add(this.arrowBoxHandle, this.arrowHandle);
                break;
            }
            case 16: 
            case 32: {
                this.handle = OS.gtk_toggle_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                OS.gtk_toggle_button_set_mode(this.handle, false);
                OS.gtk_container_add(this.handle, this.boxHandle);
                break;
            }
            default: {
                this.handle = OS.gtk_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                OS.gtk_container_add(this.handle, this.boxHandle);
            }
        }
        if ((this.style & 2) == 0) {
            int[] nArray = new int[1];
            OS.gtk_widget_style_get(this.parent.handle, OS.button_relief, nArray, 0L);
            OS.gtk_button_set_relief(this.handle, nArray[0]);
        }
        OS.GTK_WIDGET_UNSET_FLAGS(this.handle, 2048);
        if ((this.parent.state & 0x1000) != 0) {
            this.setForegroundColor(this.parent.getForegroundColor());
        }
        if ((this.parent.state & 0x4000) != 0) {
            this.setFontDescription(this.parent.getFontDescription());
        }
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.showWidget(n);
        this.parent.relayout();
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.labelHandle != 0L) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        ToolBar toolBar = this.parent;
        super.dispose();
        toolBar.relayout();
    }

    public Rectangle getBounds() {
        int n;
        int n2;
        int n3;
        int n4;
        this.checkWidget();
        this.parent.forceResize();
        long l = this.topHandle();
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && this.control != null && !this.control.isDisposed()) {
            int n5 = OS.gtk_container_get_border_width(this.parent.handle);
            byte[] byArray = Converter.wcsToMbcs(null, "shadow_type", true);
            int[] nArray = new int[1];
            OS.gtk_widget_style_get(this.parent.handle, byArray, nArray, 0L);
            if (nArray[0] != 0) {
                n5 += OS.gtk_style_get_xthickness(OS.gtk_widget_get_style(this.parent.handle));
            }
            if ((this.parent.style & 0x200) != 0) {
                n4 = n5;
                n3 = OS.GTK_WIDGET_Y(l) + n5;
                n2 = OS.GTK_WIDGET_WIDTH(this.parent.handle) - n5 * 2;
                n = OS.GTK_WIDGET_HEIGHT(l);
            } else {
                n4 = OS.GTK_WIDGET_X(l) + n5;
                n3 = n5;
                n2 = OS.GTK_WIDGET_WIDTH(l);
                n = OS.GTK_WIDGET_HEIGHT(this.parent.handle) - n5 * 2;
            }
        } else {
            n4 = OS.GTK_WIDGET_X(l);
            n3 = OS.GTK_WIDGET_Y(l);
            n2 = OS.GTK_WIDGET_WIDTH(l);
            n = OS.GTK_WIDGET_HEIGHT(l);
        }
        if ((this.parent.style & 0x8000000) != 0) {
            n4 = this.parent.getClientWidth() - n2 - n4;
        }
        if ((this.style & 2) != 0 && this.control != null) {
            n = Math.max(n, 23);
        }
        return new Rectangle(n4, n3, n2, n);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        long l = this.topHandle();
        return OS.GTK_WIDGET_SENSITIVE(l);
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        if (this.parent == null) {
            this.error(24);
        }
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return OS.gtk_toggle_button_get_active(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        this.parent.forceResize();
        long l = this.topHandle();
        return OS.GTK_WIDGET_WIDTH(l);
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
        double d = gdkEventButton.x;
        gdkEventButton.x += (double)OS.GTK_WIDGET_X(this.handle);
        double d2 = gdkEventButton.y;
        gdkEventButton.y += (double)OS.GTK_WIDGET_Y(this.handle);
        OS.memmove(l2, gdkEventButton, (long)GdkEventButton.sizeof);
        long l3 = this.parent.gtk_button_press_event(l, l2);
        gdkEventButton.x = d;
        gdkEventButton.y = d2;
        OS.memmove(l2, gdkEventButton, (long)GdkEventButton.sizeof);
        return l3;
    }

    @Override
    long gtk_button_release_event(long l, long l2) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
        double d = gdkEventButton.x;
        gdkEventButton.x += (double)OS.GTK_WIDGET_X(this.handle);
        double d2 = gdkEventButton.y;
        gdkEventButton.y += (double)OS.GTK_WIDGET_Y(this.handle);
        OS.memmove(l2, gdkEventButton, (long)GdkEventButton.sizeof);
        long l3 = this.parent.gtk_button_release_event(l, l2);
        gdkEventButton.x = d;
        gdkEventButton.y = d2;
        OS.memmove(l2, gdkEventButton, (long)GdkEventButton.sizeof);
        return l3;
    }

    @Override
    long gtk_clicked(long l) {
        long l2;
        Event event = new Event();
        if ((this.style & 4) != 0 && (l2 = OS.gtk_get_current_event()) != 0L) {
            GdkEvent gdkEvent = new GdkEvent();
            OS.memmove(gdkEvent, l2, (long)GdkEvent.sizeof);
            switch (gdkEvent.type) {
                case 4: 
                case 5: 
                case 7: {
                    double[] dArray = new double[1];
                    double[] dArray2 = new double[1];
                    OS.gdk_event_get_coords(l2, dArray, dArray2);
                    int n = OS.GTK_WIDGET_X(this.arrowHandle) - OS.GTK_WIDGET_X(this.handle);
                    int n2 = OS.GTK_WIDGET_WIDTH(this.arrowHandle);
                    if (((this.parent.style & 0x4000000) != 0 || n > (int)dArray[0]) && ((this.parent.style & 0x4000000) == 0 || (int)dArray[0] > n + n2)) break;
                    event.detail = 4;
                    long l3 = this.topHandle();
                    event.x = OS.GTK_WIDGET_X(l3);
                    if ((this.parent.style & 0x8000000) != 0) {
                        event.x = this.parent.getClientWidth() - OS.GTK_WIDGET_WIDTH(l3) - event.x;
                    }
                    event.y = OS.GTK_WIDGET_Y(l3) + OS.GTK_WIDGET_HEIGHT(l3);
                    break;
                }
            }
            OS.gdk_event_free(l2);
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.postEvent(13, event);
        return 0L;
    }

    @Override
    long gtk_enter_notify_event(long l, long l2) {
        int n;
        ImageList imageList;
        this.parent.gtk_enter_notify_event(l, l2);
        boolean bl = this.drawHotImage = (this.parent.style & 0x800000) != 0 && this.hotImage != null;
        if (this.drawHotImage && this.imageHandle != 0L && (imageList = this.parent.imageList) != null && (n = imageList.indexOf(this.hotImage)) != -1) {
            long l3 = imageList.getPixbuf(n);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, l3);
        }
        return 0L;
    }

    @Override
    long gtk_event_after(long l, long l2) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, l2, (long)GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 4: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
                if (gdkEventButton.button != 3) break;
                this.parent.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
                break;
            }
        }
        return 0L;
    }

    @Override
    long gtk_focus_out_event(long l, long l2) {
        OS.GTK_WIDGET_UNSET_FLAGS(this.handle, 2048);
        this.parent.lastFocus = this;
        return 0L;
    }

    @Override
    long gtk_leave_notify_event(long l, long l2) {
        this.parent.gtk_leave_notify_event(l, l2);
        if (this.drawHotImage) {
            int n;
            ImageList imageList;
            this.drawHotImage = false;
            if (this.imageHandle != 0L && this.image != null && (imageList = this.parent.imageList) != null && (n = imageList.indexOf(this.image)) != -1) {
                long l3 = imageList.getPixbuf(n);
                OS.gtk_image_set_from_pixbuf(this.imageHandle, l3);
            }
        }
        return 0L;
    }

    @Override
    long gtk_map(long l) {
        this.parent.fixZOrder();
        return 0L;
    }

    @Override
    long gtk_mnemonic_activate(long l, long l2) {
        return this.parent.gtk_mnemonic_activate(l, l2);
    }

    boolean hasFocus() {
        return OS.GTK_WIDGET_HAS_FOCUS(this.handle);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if ((this.style & 2) != 0) {
            return;
        }
        OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.closures[8], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[14], 0, this.display.closures[14], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[29], 0, this.display.closures[29], false);
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.closures[32], false);
        }
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[22], 0, this.display.closures[22], false);
        int n = 32518;
        OS.gtk_widget_add_events(this.handle, n);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.closures[2], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[4], 0, this.display.closures[4], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[16], 0, this.display.closures[16], false);
        long l = this.topHandle();
        OS.g_signal_connect_closure_by_id(l, this.display.signalIds[30], 0, this.display.closures[30], true);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    @Override
    void register() {
        super.register();
        if (this.labelHandle != 0L) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0L;
        this.labelHandle = 0L;
        this.separatorHandle = 0L;
        this.arrowHandle = 0L;
        this.boxHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.parent.lastFocus == this) {
            this.parent.lastFocus = null;
        }
        this.parent = null;
        this.control = null;
        this.disabledImage = null;
        this.hotImage = null;
        this.toolTipText = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void resizeControl() {
        if (this.control != null && !this.control.isDisposed()) {
            if (this.separatorHandle != 0L) {
                OS.gtk_widget_hide(this.separatorHandle);
            }
            Rectangle rectangle = this.getBounds();
            this.control.setSize(rectangle.width, rectangle.height);
            OS.gtk_widget_set_size_request(this.handle, rectangle.width, rectangle.height);
            Rectangle rectangle2 = this.control.getBounds();
            rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
            rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
            this.control.setLocation(rectangle2.x, rectangle2.y);
        } else if (this.separatorHandle != 0L) {
            OS.gtk_widget_show(this.separatorHandle);
        }
    }

    void selectRadio() {
        ToolItem[] toolItemArray = this.parent.getItems();
        for (int i = 0; i < toolItemArray.length && toolItemArray[i] != this; ++i) {
        }
        for (int i = i - 1; i >= 0 && toolItemArray[i].setRadioSelection(false); --i) {
        }
        for (int i = i + 1; i < toolItemArray.length && toolItemArray[i].setRadioSelection(false); ++i) {
        }
        this.setSelection(true);
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        this.parent.relayout();
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        long l = this.topHandle();
        OS.gtk_widget_set_sensitive(l, bl);
        if (bl) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gdk_window_get_pointer(this.parent.paintWindow(), nArray, nArray2, null);
            if (this.getBounds().contains(nArray[0], nArray2[0])) {
                OS.gtk_widget_hide(this.handle);
                OS.gtk_widget_show(this.handle);
            }
        }
    }

    boolean setFocus() {
        if ((this.style & 2) != 0) {
            return false;
        }
        if (!OS.gtk_widget_get_child_visible(this.handle)) {
            return false;
        }
        OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        OS.gtk_widget_grab_focus(this.handle);
        boolean bl = OS.gtk_widget_is_focus(this.handle);
        if (!bl) {
            OS.GTK_WIDGET_UNSET_FLAGS(this.handle, 2048);
        }
        return bl;
    }

    void setFontDescription(long l) {
        OS.gtk_widget_modify_font(this.handle, l);
        if (this.labelHandle != 0L) {
            OS.gtk_widget_modify_font(this.labelHandle, l);
        }
        if (this.imageHandle != 0L) {
            OS.gtk_widget_modify_font(this.imageHandle, l);
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        this.setForegroundColor(this.handle, gdkColor);
        if (this.labelHandle != 0L) {
            this.setForegroundColor(this.labelHandle, gdkColor);
        }
        if (this.imageHandle != 0L) {
            this.setForegroundColor(this.imageHandle, gdkColor);
        }
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        if (image != null) {
            int n;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            } else {
                imageList.put(n, image);
            }
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (this.imageHandle == 0L) {
            return;
        }
        if (image != null) {
            int n;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            } else {
                imageList.put(n, image);
            }
            long l = imageList.getPixbuf(n);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, l);
            OS.gtk_widget_show(this.imageHandle);
        } else {
            OS.gtk_image_set_from_pixbuf(this.imageHandle, 0L);
            OS.gtk_widget_hide(this.imageHandle);
        }
        this.parent.relayout();
    }

    @Override
    void setOrientation() {
        if ((this.parent.style & 0x4000000) != 0) {
            if (this.handle != 0L) {
                OS.gtk_widget_set_direction(this.handle, 2);
            }
            if (this.labelHandle != 0L) {
                OS.gtk_widget_set_direction(this.labelHandle, 2);
            }
            if (this.imageHandle != 0L) {
                OS.gtk_widget_set_direction(this.imageHandle, 2);
            }
            if (this.separatorHandle != 0L) {
                OS.gtk_widget_set_direction(this.separatorHandle, 2);
            }
            if (this.arrowHandle != 0L) {
                OS.gtk_widget_set_direction(this.arrowHandle, 2);
            }
            if (this.boxHandle != 0L) {
                OS.gtk_widget_set_direction(this.boxHandle, 2);
            }
            if (this.arrowBoxHandle != 0L) {
                OS.gtk_widget_set_direction(this.arrowBoxHandle, 2);
            }
        }
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
        OS.gtk_toggle_button_set_active(this.handle, bl);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        if (this.labelHandle == 0L) {
            return;
        }
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        if (string.length() != 0) {
            OS.gtk_widget_show(this.labelHandle);
        } else {
            OS.gtk_widget_hide(this.labelHandle);
        }
        this.parent.relayout();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (this.parent.toolTipText == null) {
            Shell shell = this.parent._getShell();
            this.setToolTipText(shell, string);
        }
        this.toolTipText = string;
    }

    void setToolTipText(Shell shell, String string) {
        shell.setToolTipText(this.handle, string);
    }

    public void setWidth(int n) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (n < 0) {
            return;
        }
        boolean bl = (this.parent.style & 0x200) != 0;
        OS.gtk_widget_set_size_request(this.separatorHandle, n, bl ? 6 : 15);
        OS.gtk_widget_set_size_request(this.handle, n, bl ? 6 : 15);
        this.parent.relayout();
    }

    void showWidget(int n) {
        if (this.handle != 0L) {
            OS.gtk_widget_show(this.handle);
        }
        if (this.boxHandle != 0L) {
            OS.gtk_widget_show(this.boxHandle);
        }
        if (this.separatorHandle != 0L) {
            OS.gtk_widget_show(this.separatorHandle);
        }
        if (this.arrowBoxHandle != 0L) {
            OS.gtk_widget_show(this.arrowBoxHandle);
        }
        if (this.arrowHandle != 0L) {
            OS.gtk_widget_show(this.arrowHandle);
        }
        OS.gtk_toolbar_insert_widget(this.parent.handle, this.handle, null, null, n);
    }
}

