/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.undoredo;

import org.openscience.cdk.controller.undoredo.IUndoRedoable;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.tools.manipulator.ReactionSetManipulator;

public class MakeReactantOrProductInExistingReactionEdit
implements IUndoRedoable {
    private static final long serialVersionUID = -7667903450980188402L;
    private IAtomContainer movedContainer;
    private IAtomContainer oldContainer;
    private String type;
    private IChemModel chemModel;
    private String reactionID;
    private boolean reactantOrProduct;

    public MakeReactantOrProductInExistingReactionEdit(IChemModel chemModel, IAtomContainer ac, IAtomContainer oldcontainer, String s, boolean reactantOrProduct, String type) {
        this.type = type;
        this.movedContainer = ac;
        this.oldContainer = oldcontainer;
        this.chemModel = chemModel;
        this.reactionID = s;
        this.reactantOrProduct = reactantOrProduct;
    }

    @Override
    public void redo() {
        this.chemModel.getMoleculeSet().removeAtomContainer(this.movedContainer);
        IReaction reaction = ReactionSetManipulator.getReactionByReactionID((IReactionSet)this.chemModel.getReactionSet(), (String)this.reactionID);
        IMolecule mol = (IMolecule)this.chemModel.getBuilder().newInstance(IMolecule.class, new Object[]{this.movedContainer});
        mol.setID(this.movedContainer.getID());
        if (this.reactantOrProduct) {
            reaction.addReactant(mol);
        } else {
            reaction.addProduct(mol);
        }
        this.chemModel.getReactionSet().addReaction(reaction);
        this.chemModel.getMoleculeSet().removeAtomContainer(this.oldContainer);
    }

    @Override
    public void undo() {
        if (this.chemModel.getMoleculeSet() == null) {
            this.chemModel.setMoleculeSet((IMoleculeSet)this.chemModel.getBuilder().newInstance(IMoleculeSet.class, new Object[0]));
        }
        this.chemModel.getMoleculeSet().addAtomContainer(this.oldContainer);
        IMoleculeSet reactantsorproducts = this.reactantOrProduct ? ReactionSetManipulator.getReactionByReactionID((IReactionSet)this.chemModel.getReactionSet(), (String)this.reactionID).getReactants() : ReactionSetManipulator.getReactionByReactionID((IReactionSet)this.chemModel.getReactionSet(), (String)this.reactionID).getProducts();
        int count = 0;
        for (IAtomContainer mol : reactantsorproducts.atomContainers()) {
            if (mol.getID().equals(this.movedContainer.getID())) {
                reactantsorproducts.removeAtomContainer(count);
                break;
            }
            ++count;
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    public String getPresentationName() {
        return this.type;
    }
}

