/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.ArrayList;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;

@TestClass(value="org.openscience.cdk.graph.ConnectivityCheckerTest")
public class ConnectivityChecker {
    @TestMethod(value="testIsConnected_IAtomContainer,testPartitionIntoMolecules_IsConnected_Consistency")
    public static boolean isConnected(IAtomContainer atomContainer) {
        if (atomContainer.getAtomCount() < 2) {
            return true;
        }
        IAtomContainer newContainer = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IMolecule molecule = atomContainer.getBuilder().newInstance(IMolecule.class, new Object[0]);
        ArrayList<IAtom> sphere = new ArrayList<IAtom>();
        for (IAtom atom : atomContainer.atoms()) {
            atom.setFlag(4, false);
            newContainer.addAtom(atom);
        }
        for (IBond bond : atomContainer.bonds()) {
            bond.setFlag(4, false);
            newContainer.addBond(bond);
        }
        IAtom atom = newContainer.getAtom(0);
        sphere.add(atom);
        atom.setFlag(4, true);
        PathTools.breadthFirstSearch(newContainer, sphere, molecule);
        return molecule.getAtomCount() == atomContainer.getAtomCount();
    }

    @TestMethod(value="testPartitionIntoMolecules_IAtomContainer,testPartitionIntoMoleculesKeepsAtomIDs,testPartitionIntoMolecules_IsConnected_Consistency")
    public static IMoleculeSet partitionIntoMolecules(IAtomContainer atomContainer) {
        IAtomContainer newContainer = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IMoleculeSet molecules = atomContainer.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        ArrayList<IAtom> sphere = new ArrayList<IAtom>();
        for (IAtom atom : atomContainer.atoms()) {
            atom.setFlag(4, false);
            newContainer.addAtom(atom);
        }
        for (IBond bond : atomContainer.bonds()) {
            bond.setFlag(4, false);
            newContainer.addBond(bond);
        }
        for (IElectronContainer eContainer : atomContainer.electronContainers()) {
            eContainer.setFlag(4, false);
            newContainer.addElectronContainer(eContainer);
        }
        while (newContainer.getAtomCount() > 0) {
            IAtom atom = newContainer.getAtom(0);
            IMolecule molecule = atomContainer.getBuilder().newInstance(IMolecule.class, new Object[0]);
            sphere.clear();
            sphere.add(atom);
            atom.setFlag(4, true);
            PathTools.breadthFirstSearch(newContainer, sphere, molecule);
            molecules.addMolecule(molecule);
            newContainer.remove(molecule);
        }
        return molecules;
    }
}

