/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.NoSuchElementException;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SMILESFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.io.iterator.IteratingSMILESReaderTest")
public class IteratingSMILESReader
extends DefaultIteratingChemObjectReader {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(IteratingSMILESReader.class);
    private String currentLine;
    private SmilesParser sp = null;
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private IMolecule nextMolecule;

    @TestMethod(value="testSMILESFileWithNames")
    public IteratingSMILESReader(Reader in, IChemObjectBuilder builder) {
        this.sp = new SmilesParser(builder);
        this.setReader(in);
    }

    @TestMethod(value="testSMILESFileWithNames")
    public IteratingSMILESReader(InputStream in) {
        this(new InputStreamReader(in), DefaultChemObjectBuilder.getInstance());
    }

    public IteratingSMILESReader(InputStream in, IChemObjectBuilder builder) {
        this(new InputStreamReader(in), builder);
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return SMILESFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSMILESFileWithNames,testSMILESFileWithSpacesAndTabs,testSMILESTitles,testSMILESFile")
    public boolean hasNext() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = false;
            try {
                if (this.input.ready()) {
                    this.currentLine = this.input.readLine().trim();
                    logger.debug("Line: ", this.currentLine);
                    int indexSpace = this.currentLine.indexOf(" ");
                    if (indexSpace == -1) {
                        indexSpace = this.currentLine.indexOf("\t");
                    }
                    String SMILES = this.currentLine;
                    String name = null;
                    if (indexSpace != -1) {
                        logger.debug("Space found at index: ", indexSpace);
                        SMILES = this.currentLine.substring(0, indexSpace);
                        name = this.currentLine.substring(indexSpace + 1);
                        name = name.trim();
                        logger.debug("Line contains SMILES and name: ", SMILES, " + ", name);
                    }
                    this.nextMolecule = this.sp.parseSmiles(SMILES);
                    if (name != null) {
                        this.nextMolecule.setProperty("cdk:Title", name);
                    }
                    this.hasNext = this.nextMolecule.getAtomCount() > 0;
                } else {
                    this.hasNext = false;
                }
            }
            catch (Exception exception) {
                logger.error("Error while reading next molecule: ", exception.getMessage());
                logger.debug(exception);
                this.hasNext = false;
            }
            if (!this.hasNext) {
                this.nextMolecule = null;
            }
            this.nextAvailableIsKnown = true;
        }
        return this.hasNext;
    }

    @TestMethod(value="testSMILESFileWithNames,testSMILESFileWithSpacesAndTabs,testSMILESTitles,testSMILESFile")
    public IChemObject next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextMolecule;
    }

    @Override
    @TestMethod(value="testSMILESFileWithNames,testSMILESFileWithSpacesAndTabs,testClose")
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    @TestMethod(value="testRemove")
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    @Override
    @TestMethod(value="testSetReader1,testSetReader_InputStream")
    public void setReader(InputStream reader) {
        this.setReader(new InputStreamReader(reader));
    }
}

