/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers.smarts;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSAtom;

public class LogicalOperatorAtom
extends SMARTSAtom {
    private static final long serialVersionUID = -5752396252307536738L;
    private IQueryAtom left;
    private String operator;
    private IQueryAtom right;

    public IQueryAtom getLeft() {
        return this.left;
    }

    public String getOperator() {
        return this.operator;
    }

    public IQueryAtom getRight() {
        return this.right;
    }

    public void setLeft(IQueryAtom left) {
        this.left = left;
    }

    public void setOperator(String name) {
        this.operator = name;
    }

    public void setRight(IQueryAtom right) {
        this.right = right;
    }

    @Override
    public boolean matches(IAtom atom) {
        boolean val = false;
        boolean matchesLeft = this.left.matches(atom);
        if (this.right != null) {
            if ("and".equals(this.operator) && matchesLeft) {
                boolean matchesRight = this.right.matches(atom);
                val = matchesLeft && matchesRight;
            } else if ("or".equals(this.operator)) {
                boolean matchesRight = this.right.matches(atom);
                val = matchesLeft || matchesRight;
            }
        } else {
            val = "not".equals(this.operator) ? !matchesLeft : matchesLeft;
        }
        return val;
    }

    @Override
    public boolean getFlag(int flagType) {
        boolean val = false;
        boolean leftFlag = this.left.getFlag(flagType);
        if (this.right != null) {
            if ("and".equals(this.operator) && leftFlag) {
                boolean rightFlag = this.right.getFlag(flagType);
                val = leftFlag && rightFlag;
            } else if ("or".equals(this.operator)) {
                boolean rightFlag = this.right.getFlag(flagType);
                val = leftFlag || rightFlag;
            }
        } else {
            val = "not".equals(this.operator) ? !leftFlag : leftFlag;
        }
        return val;
    }
}

