/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.ConnectionMatrix;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.WienerNumbersDescriptorTest")
public class WienerNumbersDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"WPATH", "WPOL"};
    double[][] matr = null;
    DoubleArrayResult wienerNumbers = null;
    ConnectionMatrix connectionMatrix = new ConnectionMatrix();
    AtomContainerManipulator atm = new AtomContainerManipulator();

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#wienerNumbers", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        this.wienerNumbers = new DoubleArrayResult(2);
        double wienerPathNumber = 0.0;
        double wienerPolarityNumber = 0.0;
        this.matr = ConnectionMatrix.getMatrix(AtomContainerManipulator.removeHydrogens(atomContainer));
        int[][] distances = PathTools.computeFloydAPSP(this.matr);
        for (int i = 0; i < distances.length; ++i) {
            for (int j = 0; j < distances.length; ++j) {
                int partial = distances[i][j];
                wienerPathNumber += (double)partial;
                if (partial != 3) continue;
                wienerPolarityNumber += 1.0;
            }
        }
        this.wienerNumbers.add(wienerPathNumber /= 2.0);
        this.wienerNumbers.add(wienerPolarityNumber /= 2.0);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), this.wienerNumbers, this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(2);
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }
}

