/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles.smarts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.smarts.HydrogenAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.LogicalOperatorAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.RecursiveSmartsAtom;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.ringsearch.SSSRFinder;
import org.openscience.cdk.smiles.smarts.parser.SMARTSParser;
import org.openscience.cdk.smiles.smarts.parser.TokenMgrError;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.smiles.smarts.SMARTSQueryToolTest")
public class SMARTSQueryTool {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(SMARTSQueryTool.class);
    private String smarts;
    private IAtomContainer atomContainer = null;
    private QueryAtomContainer query = null;
    private List<List<Integer>> matchingAtoms = null;

    public SMARTSQueryTool(String smarts) throws CDKException {
        this.smarts = smarts;
        try {
            this.initializeQuery();
        }
        catch (TokenMgrError error) {
            throw new CDKException("Error parsing SMARTS", error);
        }
    }

    @TestMethod(value="testQueryTool")
    public String getSmarts() {
        return this.smarts;
    }

    @TestMethod(value="testQueryTool, testQueryToolResetSmart")
    public void setSmarts(String smarts) throws CDKException {
        this.smarts = smarts;
        this.initializeQuery();
    }

    public boolean matches(IAtomContainer atomContainer) throws CDKException {
        return this.matches(atomContainer, false);
    }

    @TestMethod(value="testQueryTool, testQueryToolSingleAtomCase, testQuery")
    public boolean matches(IAtomContainer atomContainer, boolean forceInitialization) throws CDKException {
        if (this.atomContainer == atomContainer) {
            if (forceInitialization) {
                this.initializeMolecule();
            }
        } else {
            this.atomContainer = atomContainer;
            this.initializeMolecule();
        }
        this.initializeRecursiveSmarts(this.atomContainer);
        if (this.query.getAtomCount() == 1) {
            IQueryAtom queryAtom = (IQueryAtom)this.query.getAtom(0);
            this.matchingAtoms = new ArrayList<List<Integer>>();
            for (IAtom atom : this.atomContainer.atoms()) {
                if (!queryAtom.matches(atom)) continue;
                ArrayList<Integer> tmp = new ArrayList<Integer>();
                tmp.add(this.atomContainer.getAtomNumber(atom));
                this.matchingAtoms.add(tmp);
            }
        } else {
            List<List<RMap>> bondMapping = UniversalIsomorphismTester.getSubgraphMaps(this.atomContainer, this.query);
            this.matchingAtoms = this.getAtomMappings(bondMapping, this.atomContainer);
        }
        return this.matchingAtoms.size() != 0;
    }

    @TestMethod(value="testQueryTool")
    public int countMatches() {
        return this.matchingAtoms.size();
    }

    @TestMethod(value="testQueryTool")
    public List<List<Integer>> getMatchingAtoms() {
        return this.matchingAtoms;
    }

    @TestMethod(value="testUniqueQueries")
    public List<List<Integer>> getUniqueMatchingAtoms() {
        ArrayList<List<Integer>> ret = new ArrayList<List<Integer>>();
        for (List<Integer> atomMapping : this.matchingAtoms) {
            Collections.sort(atomMapping);
            boolean present = false;
            for (List list : ret) {
                if (list.size() != atomMapping.size()) continue;
                Collections.sort(list);
                boolean matches = true;
                for (int i = 0; i < atomMapping.size(); ++i) {
                    int index2;
                    int index1 = atomMapping.get(i);
                    if (index1 == (index2 = ((Integer)list.get(i)).intValue())) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                present = true;
                break;
            }
            if (present) continue;
            ret.add(atomMapping);
        }
        return ret;
    }

    private void initializeMolecule() throws CDKException {
        IRingSet allRings;
        HashMap<String, Integer> valencesTable = new HashMap<String, Integer>();
        valencesTable.put("H", 1);
        valencesTable.put("Li", 1);
        valencesTable.put("Be", 2);
        valencesTable.put("B", 3);
        valencesTable.put("C", 4);
        valencesTable.put("N", 5);
        valencesTable.put("O", 6);
        valencesTable.put("F", 7);
        valencesTable.put("Na", 1);
        valencesTable.put("Mg", 2);
        valencesTable.put("Al", 3);
        valencesTable.put("Si", 4);
        valencesTable.put("P", 5);
        valencesTable.put("S", 6);
        valencesTable.put("Cl", 7);
        valencesTable.put("K", 1);
        valencesTable.put("Ca", 2);
        valencesTable.put("Ga", 3);
        valencesTable.put("Ge", 4);
        valencesTable.put("As", 5);
        valencesTable.put("Se", 6);
        valencesTable.put("Br", 7);
        valencesTable.put("Rb", 1);
        valencesTable.put("Sr", 2);
        valencesTable.put("In", 3);
        valencesTable.put("Sn", 4);
        valencesTable.put("Sb", 5);
        valencesTable.put("Te", 6);
        valencesTable.put("I", 7);
        valencesTable.put("Cs", 1);
        valencesTable.put("Ba", 2);
        valencesTable.put("Tl", 3);
        valencesTable.put("Pb", 4);
        valencesTable.put("Bi", 5);
        valencesTable.put("Po", 6);
        valencesTable.put("At", 7);
        valencesTable.put("Fr", 1);
        valencesTable.put("Ra", 2);
        valencesTable.put("Cu", 2);
        valencesTable.put("Mn", 2);
        valencesTable.put("Co", 2);
        AllRingsFinder arf = new AllRingsFinder();
        try {
            allRings = arf.findAllRings(this.atomContainer);
        }
        catch (CDKException e) {
            logger.debug(e.toString());
            throw new CDKException(e.toString(), e);
        }
        SSSRFinder finder = new SSSRFinder(this.atomContainer);
        IRingSet sssr = finder.findEssentialRings();
        for (IAtom atom : this.atomContainer.atoms()) {
            if (allRings.contains(atom)) {
                atom.setFlag(1, true);
                ArrayList<Integer> ringsizes = new ArrayList<Integer>();
                IRingSet currentRings = allRings.getRings(atom);
                int min = 0;
                for (int i = 0; i < currentRings.getAtomContainerCount(); ++i) {
                    int size = currentRings.getAtomContainer(i).getAtomCount();
                    if (min > size) {
                        min = size;
                    }
                    ringsizes.add(size);
                }
                atom.setProperty("cdk:RingSizes", ringsizes);
                atom.setProperty("cdk:SmallestRings", sssr.getRings(atom));
            } else {
                atom.setFlag(1, false);
            }
            int hCount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
            List<IAtom> connectedAtoms = this.atomContainer.getConnectedAtomsList(atom);
            int total = hCount + connectedAtoms.size();
            for (IAtom connectedAtom : connectedAtoms) {
                if (!connectedAtom.getSymbol().equals("H")) continue;
                ++hCount;
            }
            atom.setProperty("cdk:TotalConnections", total);
            atom.setProperty("cdk:TotalHydrogenCount", hCount);
            if (valencesTable.get(atom.getSymbol()) == null) continue;
            int formalCharge = atom.getFormalCharge() == CDKConstants.UNSET ? 0 : atom.getFormalCharge();
            atom.setValency((Integer)valencesTable.get(atom.getSymbol()) - formalCharge);
        }
        for (IBond bond : this.atomContainer.bonds()) {
            if (allRings.getRings(bond).getAtomContainerCount() <= 0) continue;
            bond.setFlag(1, true);
        }
        for (IAtom atom : this.atomContainer.atoms()) {
            List<IAtom> connectedAtoms = this.atomContainer.getConnectedAtomsList(atom);
            int counter = 0;
            for (IAtom connectedAtom : connectedAtoms) {
                IAtom any = connectedAtom;
                if (!any.getFlag(1)) continue;
                ++counter;
            }
            atom.setProperty("cdk:RingConnections", counter);
        }
        try {
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(this.atomContainer);
            CDKHueckelAromaticityDetector.detectAromaticity(this.atomContainer);
        }
        catch (CDKException e) {
            logger.debug(e.toString());
            throw new CDKException(e.toString(), e);
        }
    }

    private void initializeRecursiveSmarts(IAtomContainer atomContainer) throws CDKException {
        for (IAtom atom : this.query.atoms()) {
            this.initializeRecursiveSmartsAtom(atom, atomContainer);
        }
    }

    private void initializeRecursiveSmartsAtom(IAtom atom, IAtomContainer atomContainer) throws CDKException {
        if (atom instanceof LogicalOperatorAtom) {
            this.initializeRecursiveSmartsAtom(((LogicalOperatorAtom)atom).getLeft(), atomContainer);
            if (((LogicalOperatorAtom)atom).getRight() != null) {
                this.initializeRecursiveSmartsAtom(((LogicalOperatorAtom)atom).getRight(), atomContainer);
            }
        } else if (atom instanceof RecursiveSmartsAtom) {
            ((RecursiveSmartsAtom)atom).setAtomContainer(atomContainer);
        } else if (atom instanceof HydrogenAtom) {
            ((HydrogenAtom)atom).setAtomContainer(atomContainer);
        }
    }

    private void initializeQuery() throws CDKException {
        this.matchingAtoms = null;
        this.query = SMARTSParser.parse(this.smarts);
    }

    private List<List<Integer>> getAtomMappings(List bondMapping, IAtomContainer atomContainer) {
        ArrayList<List<Integer>> atomMapping = new ArrayList<List<Integer>>();
        for (Object aBondMapping : bondMapping) {
            List list = (List)aBondMapping;
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            IElement atom1 = null;
            IElement atom2 = null;
            for (Object aList : list) {
                RMap map = (RMap)aList;
                int bondID = map.getId1();
                IBond bond = atomContainer.getBond(bondID);
                atom1 = bond.getAtom(0);
                atom2 = bond.getAtom(1);
                Integer idx1 = atomContainer.getAtomNumber((IAtom)atom1);
                Integer idx2 = atomContainer.getAtomNumber((IAtom)atom2);
                if (!tmp.contains(idx1)) {
                    tmp.add(idx1);
                }
                if (tmp.contains(idx2)) continue;
                tmp.add(idx2);
            }
            if (tmp.size() > 0) {
                atomMapping.add(tmp);
            }
            if (list.size() != 1 || atom1.getAtomicNumber() != atom2.getAtomicNumber()) continue;
            ArrayList tmp2 = new ArrayList();
            tmp2.add(tmp.get(0));
            tmp2.add(tmp.get(1));
            atomMapping.add(tmp2);
        }
        return atomMapping;
    }
}

