/*
 * Decompiled with CFR 0.152.
 */
package sea36.util.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvingProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(ResolvingProperties.class);
    private Map<String, String> parameters = new HashMap<String, String>();

    public ResolvingProperties() {
    }

    public ResolvingProperties(Map<String, String> params) {
        if (params != null) {
            this.parameters.putAll(params);
        }
    }

    public ResolvingProperties(ResolvingProperties defaults) {
        super(defaults);
    }

    public ResolvingProperties(ResolvingProperties defaults, Map<String, String> params) {
        super(defaults);
        if (params != null) {
            this.parameters.putAll(params);
        }
    }

    @Override
    public synchronized Object get(Object key) {
        Object oval;
        String sval;
        if (key instanceof String) {
            key = this.resolveKey((String)key);
        }
        if ((sval = this.parameters.get(key)) == null && (oval = super.get(key)) instanceof String) {
            sval = (String)oval;
        }
        return sval;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (key instanceof String && this.parameters.containsKey(key = this.resolveKey((String)key))) {
            throw new IllegalArgumentException("Parameter value cannot be overridden: " + key);
        }
        return super.put(key, value);
    }

    @Override
    public String getProperty(String key) {
        String value = this.resolvingGetProperty(key);
        return value;
    }

    private synchronized String nonResolvingGetProperty(String key) {
        String sval = null;
        Object oval = this.get(key);
        if (oval != null && oval instanceof String) {
            sval = (String)oval;
        } else if (this.defaults != null) {
            sval = this.defaults instanceof ResolvingProperties ? ((ResolvingProperties)this.defaults).nonResolvingGetProperty(key) : this.defaults.getProperty(key);
        }
        return sval;
    }

    private synchronized String resolvingGetProperty(String key) {
        String value = this.nonResolvingGetProperty(key);
        if (value != null) {
            int i0 = value.indexOf("${");
            while (i0 != -1 && value.length() > i0 + 2) {
                int n = 1;
                int i = i0 + 1;
                char c = value.charAt(i + 1);
                while (n > 0 && i + 1 < value.length()) {
                    c = value.charAt(i + 1);
                    if (c == '}') {
                        --n;
                    } else if (c == '$' && value.charAt(i + 2) == '{') {
                        ++n;
                    }
                    ++i;
                }
                if (n == 0) {
                    String k = value.substring(i0 + 2, i);
                    String val = this.resolvingGetProperty(k);
                    if (val != null) {
                        value = value.substring(0, i0) + val + value.substring(i + 1);
                        i0 = value.indexOf("${", i0);
                        continue;
                    }
                    i0 = value.indexOf("${", i0 + 1);
                    continue;
                }
                i0 = value.indexOf("${", i0 + 1);
            }
        }
        LOG.trace("GET " + key + " = " + value);
        return value;
    }

    private synchronized String resolveKey(String key) {
        int i0 = key.indexOf("${");
        if (i0 == -1) {
            return key;
        }
        String oldkey = key;
        while (i0 != -1 && key.length() > i0 + 2) {
            int n = 1;
            int i = i0 + 2;
            char c = key.charAt(i + 1);
            while (n > 0 && i + 1 < key.length()) {
                c = key.charAt(i + 1);
                if (c == '}') {
                    --n;
                } else if (c == '$' && key.charAt(i + 2) == '{') {
                    ++n;
                }
                ++i;
            }
            if (n == 0) {
                String k = key.substring(i0 + 2, i);
                String val = this.parameters.get(k);
                if (val != null) {
                    String newkey = key.substring(0, i0) + val + key.substring(i + 1);
                    LOG.trace(key + " > " + newkey);
                    key = newkey;
                    i0 = key.indexOf("${", i0);
                    continue;
                }
                LOG.warn("Unknown parameter: " + k);
                i0 = key.indexOf("${", i0 + 1);
                continue;
            }
            i0 = key.indexOf("${", i0 + 1);
        }
        LOG.trace("KEY " + oldkey + " = " + key);
        return key;
    }
}

