/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.ringsearch;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.ringsearch.RingPartitionerTest")
public class RingPartitioner {
    public static final boolean debug = false;

    @TestMethod(value="testPartitionIntoRings")
    public static List<IRingSet> partitionRings(IRingSet ringSet) {
        ArrayList<IRingSet> ringSets = new ArrayList<IRingSet>();
        if (ringSet.getAtomContainerCount() == 0) {
            return ringSets;
        }
        IRing ring = (IRing)ringSet.getAtomContainer(0);
        if (ring == null) {
            return ringSets;
        }
        IRingSet rs = ring.getBuilder().newInstance(IRingSet.class, new Object[0]);
        for (int f = 0; f < ringSet.getAtomContainerCount(); ++f) {
            rs.addAtomContainer(ringSet.getAtomContainer(f));
        }
        do {
            ring = (IRing)rs.getAtomContainer(0);
            IRingSet newRs = ring.getBuilder().newInstance(IRingSet.class, new Object[0]);
            newRs.addAtomContainer(ring);
            ringSets.add(RingPartitioner.walkRingSystem(rs, ring, newRs));
        } while (rs.getAtomContainerCount() > 0);
        return ringSets;
    }

    @TestMethod(value="testConvertToAtomContainer_IRingSet")
    public static IAtomContainer convertToAtomContainer(IRingSet ringSet) {
        IRing ring = (IRing)ringSet.getAtomContainer(0);
        if (ring == null) {
            return null;
        }
        IAtomContainer ac = ring.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (int i = 0; i < ringSet.getAtomContainerCount(); ++i) {
            ring = (IRing)ringSet.getAtomContainer(i);
            for (int r = 0; r < ring.getBondCount(); ++r) {
                IBond bond = ring.getBond(r);
                if (ac.contains(bond)) continue;
                for (int j = 0; j < bond.getAtomCount(); ++j) {
                    ac.addAtom(bond.getAtom(j));
                }
                ac.addBond(bond);
            }
        }
        return ac;
    }

    private static IRingSet walkRingSystem(IRingSet rs, IRing ring, IRingSet newRs) {
        IRingSet tempRings = rs.getConnectedRings(ring);
        rs.removeAtomContainer(ring);
        for (IAtomContainer container : tempRings.atomContainers()) {
            IRing tempRing = (IRing)container;
            if (newRs.contains(tempRing)) continue;
            newRs.addAtomContainer(tempRing);
            newRs.add(RingPartitioner.walkRingSystem(rs, tempRing, newRs));
        }
        return newRs;
    }
}

