/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.formula.MolecularFormula;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugMolecularFormula
extends MolecularFormula
implements IMolecularFormula {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugMolecularFormula.class);

    @Override
    public IMolecularFormula add(IMolecularFormula formula) {
        this.logger.debug("Adding formula: ", formula);
        return super.add(formula);
    }

    @Override
    public IMolecularFormula addIsotope(IIsotope isotope) {
        this.logger.debug("Adding isotope: ", isotope);
        return super.addIsotope(isotope);
    }

    @Override
    public IMolecularFormula addIsotope(IIsotope isotope, int count) {
        this.logger.debug("Adding 'count' isotopes: ", isotope);
        return super.addIsotope(isotope, count);
    }

    @Override
    public boolean contains(IIsotope isotope) {
        this.logger.debug("Contains isotope?: ", isotope);
        return super.contains(isotope);
    }

    @Override
    public Integer getCharge() {
        Integer charge = super.getCharge();
        this.logger.debug("Getting charge: ", charge);
        return charge;
    }

    @Override
    public int getIsotopeCount(IIsotope isotope) {
        this.logger.debug("Getting isotope count for: ", isotope);
        return super.getIsotopeCount(isotope);
    }

    @Override
    public int getIsotopeCount() {
        this.logger.debug("Getting isotope count: ", super.getIsotopeCount());
        return super.getIsotopeCount();
    }

    @Override
    public Map<Object, Object> getProperties() {
        this.logger.debug("Getting properties...");
        return super.getProperties();
    }

    @Override
    public Object getProperty(Object description) {
        this.logger.debug("Getting property: " + description);
        return super.getProperty(description);
    }

    @Override
    public Iterable<IIsotope> isotopes() {
        this.logger.debug("Getting isotope iterator..");
        return super.isotopes();
    }

    @Override
    public void removeAllIsotopes() {
        this.logger.debug("Removing all isotopes...");
        super.removeAllIsotopes();
    }

    @Override
    public void removeIsotope(IIsotope isotope) {
        this.logger.debug("Removing this isotope: ", isotope);
        super.removeIsotope(isotope);
    }

    @Override
    public void removeProperty(Object description) {
        this.logger.debug("Removing property: " + description);
        super.removeProperty(description);
    }

    @Override
    public void setCharge(Integer charge) {
        this.logger.debug("Setting the charge to: ", charge);
        super.setCharge(charge);
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
        this.logger.debug("Setting new properties...");
        super.setProperties(properties);
    }

    @Override
    public void setProperty(Object description, Object property) {
        this.logger.debug("Setting new property: " + description + " -> " + property);
        super.setProperty(description, property);
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }
}

