/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.BitSet;
import java.util.Random;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.fingerprint.Fingerprinter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

@TestClass(value="org.openscience.cdk.fingerprint.GraphOnlyFingerprinterTest")
public class GraphOnlyFingerprinter
extends Fingerprinter {
    public GraphOnlyFingerprinter() {
        super(1024, 8);
    }

    public GraphOnlyFingerprinter(int size) {
        super(size, 8);
    }

    public GraphOnlyFingerprinter(int size, int searchDepth) {
        super(size, searchDepth);
    }

    protected String getBondSymbol(IBond bond) {
        return "";
    }

    @TestMethod(value="testFingerPrint,testFingerprint")
    public BitSet getBitFingerprint(IAtomContainer container, int size) throws Exception {
        int[] hashes = this.findPathes(container, super.getSearchDepth());
        BitSet bitSet = new BitSet(size);
        for (int hash : hashes) {
            bitSet.set(new Random(hash).nextInt(size));
        }
        return bitSet;
    }
}

