/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fragment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fragment.FragmentUtils;
import org.openscience.cdk.fragment.IFragmenter;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.SpanningTree;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.smiles.SmilesGenerator;

@TestClass(value="org.openscience.cdk.fragment.MurckoFragmenterTest")
public class MurckoFragmenter
implements IFragmenter {
    private static final String IS_SIDECHAIN_ATOM = "sidechain";
    private static final String IS_LINKER_ATOM = "linker";
    SmilesGenerator smilesGenerator = new SmilesGenerator(true);
    IRingSet ringSet;
    Map<String, IAtomContainer> frameMap = new HashMap<String, IAtomContainer>();
    Map<String, IAtomContainer> ringMap = new HashMap<String, IAtomContainer>();
    SpanningTree spanningTree;
    boolean singleFrameworkOnly = false;
    int minimumFragmentSize = 5;

    @TestMethod(value="testMF1,testMF2,testMF3")
    public MurckoFragmenter() {
        this(false, 5);
    }

    @TestMethod(value="testSingleFramework")
    public MurckoFragmenter(boolean singleFrameworkOnly, int minimumFragmentSize) {
        this.singleFrameworkOnly = singleFrameworkOnly;
        this.minimumFragmentSize = minimumFragmentSize;
    }

    @TestMethod(value="testMF1, testMF2, testMF3, testMF4, testMF5, testMF6")
    public void generateFragments(IAtomContainer atomContainer) throws CDKException {
        this.frameMap.clear();
        this.ringMap.clear();
        this.run(atomContainer);
    }

    private void run(IAtomContainer atomContainer) throws CDKException {
        String smiles;
        IAtomContainer currentFramework;
        AllRingsFinder arf = new AllRingsFinder(false);
        arf.findAllRings(atomContainer);
        for (IAtom atom : atomContainer.atoms()) {
            atom.setProperty(IS_LINKER_ATOM, false);
            atom.setProperty(IS_SIDECHAIN_ATOM, false);
        }
        this.markLinkers(atomContainer);
        this.markSideChains(atomContainer);
        IAtomContainer clone = this.removeSideChains(atomContainer);
        try {
            currentFramework = clone.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new CDKException(exception.getMessage(), exception);
        }
        if (this.hasframework(currentFramework)) {
            smiles = this.smilesGenerator.createSMILES(currentFramework);
            if (this.singleFrameworkOnly) {
                if (this.frameMap.size() == 0) {
                    this.frameMap.put(smiles, currentFramework);
                }
            } else {
                this.frameMap.put(smiles, currentFramework);
            }
        }
        ArrayList<IAtom> atomsToDelete = new ArrayList<IAtom>();
        for (IAtom atom : clone.atoms()) {
            if (!this.islinker(atom)) continue;
            atomsToDelete.add(atom);
        }
        for (IAtom atom : atomsToDelete) {
            clone.removeAtomAndConnectedElectronContainers(atom);
        }
        ArrayList<IBond> bondsToDelete = new ArrayList<IBond>();
        for (IBond bond : clone.bonds()) {
            if (!this.isZeroAtomLinker(bond, clone)) continue;
            bondsToDelete.add(bond);
        }
        for (IBond bond : bondsToDelete) {
            clone.removeBond(bond);
        }
        IAtomContainerSet ringSystems = ConnectivityChecker.partitionIntoMolecules(clone);
        for (IAtomContainer ringSystem : ringSystems.atomContainers()) {
            if (ringSystem.getAtomCount() < this.minimumFragmentSize) continue;
            smiles = this.smilesGenerator.createSMILES(ringSystem);
            this.ringMap.put(smiles, ringSystem);
        }
        if (!this.hasframework(currentFramework)) {
            return;
        }
        assert (currentFramework != null);
        for (IBond bond : currentFramework.bonds()) {
            if (!this.islinker(bond) && !this.isZeroAtomLinker(bond, currentFramework)) continue;
            List<IAtomContainer> candidates = FragmentUtils.splitMolecule(currentFramework, bond);
            for (IAtomContainer candidate : candidates) {
                for (IAtom atom : candidate.atoms()) {
                    atom.setProperty(IS_LINKER_ATOM, false);
                    atom.setProperty(IS_SIDECHAIN_ATOM, false);
                }
                this.markLinkers(candidate);
                this.markSideChains(candidate);
                if (!this.hasframework(candidate = this.removeSideChains(candidate)) || candidate.getAtomCount() < this.minimumFragmentSize) continue;
                this.run(candidate);
            }
        }
    }

    private IAtomContainer removeSideChains(IAtomContainer atomContainer) throws CDKException {
        IAtomContainer clone;
        try {
            clone = atomContainer.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new CDKException("Error in clone" + exception.toString(), exception);
        }
        ArrayList<IAtom> atomsToDelete = new ArrayList<IAtom>();
        for (IAtom atom : clone.atoms()) {
            if (!this.issidechain(atom)) continue;
            atomsToDelete.add(atom);
        }
        for (IAtom anAtomsToDelete : atomsToDelete) {
            clone.removeAtomAndConnectedElectronContainers(anAtomsToDelete);
        }
        return clone;
    }

    private boolean isConnectedToRing(IAtomContainer atomContainer, IAtom atom) {
        List<IAtom> connectedAtoms = atomContainer.getConnectedAtomsList(atom);
        for (IAtom connectedAtom : connectedAtoms) {
            if (!connectedAtom.getFlag(2)) continue;
            return true;
        }
        return false;
    }

    private void markLinkers(IAtomContainer atomContainer) {
        for (IAtom atom : atomContainer.atoms()) {
            List<IAtom> conatoms;
            if (atom.getFlag(2) || (conatoms = atomContainer.getConnectedAtomsList(atom)).size() == 1) continue;
            boolean allRingAtoms = true;
            int nRingAtom = 0;
            for (IAtom iAtom : conatoms) {
                if (!iAtom.getFlag(2)) continue;
                ++nRingAtom;
            }
            if (nRingAtom < 2) continue;
            atom.setProperty(IS_LINKER_ATOM, true);
        }
        for (IAtom atom1 : atomContainer.atoms()) {
            if (atom1.getFlag(2) || !this.isConnectedToRing(atomContainer, atom1)) continue;
            for (IAtom atom2 : atomContainer.atoms()) {
                if (atom2.getFlag(2) || !this.isConnectedToRing(atomContainer, atom2)) continue;
                List<List<IAtom>> paths = PathTools.getAllPaths(atomContainer, atom1, atom2);
                for (List list : paths) {
                    boolean allNonRing = true;
                    for (IAtom atom : list) {
                        if (!atom.getFlag(2)) continue;
                        allNonRing = false;
                        break;
                    }
                    if (!allNonRing) continue;
                    for (IAtom atom : list) {
                        atom.setProperty(IS_LINKER_ATOM, true);
                    }
                }
            }
        }
    }

    private void markSideChains(IAtomContainer atomContainer) {
        for (IAtom atom : atomContainer.atoms()) {
            if (this.isring(atom) || this.islinker(atom)) continue;
            atom.setProperty(IS_SIDECHAIN_ATOM, true);
        }
    }

    @TestMethod(value="testMF1")
    public String[] getFragments() {
        ArrayList<String> allfrags = new ArrayList<String>();
        allfrags.addAll(this.frameMap.keySet());
        allfrags.addAll(this.ringMap.keySet());
        return allfrags.toArray(new String[0]);
    }

    public IAtomContainer[] getFragmentsAsContainers() {
        ArrayList<IAtomContainer> allfrags = new ArrayList<IAtomContainer>();
        allfrags.addAll(this.frameMap.values());
        allfrags.addAll(this.ringMap.values());
        return allfrags.toArray(new IAtomContainer[0]);
    }

    @TestMethod(value="testMF1")
    public String[] getRingSystems() {
        return this.ringMap.keySet().toArray(new String[0]);
    }

    @TestMethod(value="testMF2,testMF3")
    public IAtomContainer[] getRingSystemsAsContainers() {
        return this.ringMap.values().toArray(new IAtomContainer[0]);
    }

    @TestMethod(value="testMF2,testMF3")
    public String[] getFrameworks() {
        return this.frameMap.keySet().toArray(new String[0]);
    }

    public IAtomContainer[] getFrameworksAsContainers() {
        return this.frameMap.values().toArray(new IAtomContainer[0]);
    }

    private boolean isring(IAtom atom) {
        return atom.getFlag(2);
    }

    private boolean islinker(IAtom atom) {
        Boolean o = (Boolean)atom.getProperty(IS_LINKER_ATOM);
        return o != null && o != false;
    }

    private boolean issidechain(IAtom atom) {
        Boolean o = (Boolean)atom.getProperty(IS_SIDECHAIN_ATOM);
        return o != null && o != false;
    }

    private boolean islinker(IBond bond) {
        return this.islinker(bond.getAtom(0)) || this.islinker(bond.getAtom(1));
    }

    private boolean isZeroAtomLinker(IBond bond, IAtomContainer mol) {
        boolean isRingBond = new SpanningTree(mol).getCyclicFragmentsContainer().contains(bond);
        return this.isring(bond.getAtom(0)) && this.isring(bond.getAtom(1)) && !isRingBond;
    }

    private boolean hasframework(IAtomContainer atomContainer) {
        boolean hasLinker = false;
        boolean hasRing = false;
        for (IAtom atom : atomContainer.atoms()) {
            if (this.islinker(atom)) {
                hasLinker = true;
            }
            if (this.isring(atom)) {
                hasRing = true;
            }
            if (!hasLinker || !hasRing) continue;
            break;
        }
        for (IBond bond : atomContainer.bonds()) {
            if (!this.isZeroAtomLinker(bond, atomContainer)) continue;
            hasLinker = true;
            break;
        }
        return hasLinker && hasRing;
    }
}

