/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.MDLV2000Writer;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SDFFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

@TestClass(value="org.openscience.cdk.io.SDFWriterTest")
public class SDFWriter
extends DefaultChemObjectWriter {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(SDFWriter.class);
    private BufferedWriter writer;
    private BooleanIOSetting writerProperties;
    private static List<String> cdkInternalProperties = new ArrayList<String>();

    public SDFWriter(Writer out) {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        this.initIOSettings();
    }

    public SDFWriter(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    public SDFWriter() {
        this(new StringWriter());
    }

    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return SDFFormat.getInstance();
    }

    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.writer.close();
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IAtomContainer.class.equals(interfaces[i])) {
                return true;
            }
            if (IChemFile.class.equals(interfaces[i])) {
                return true;
            }
            if (IChemModel.class.equals(interfaces[i])) {
                return true;
            }
            if (!IAtomContainerSet.class.equals(interfaces[i])) continue;
            return true;
        }
        if (IAtomContainer.class.equals((Object)classObject)) {
            return true;
        }
        if (IChemFile.class.equals((Object)classObject)) {
            return true;
        }
        if (IChemModel.class.equals((Object)classObject)) {
            return true;
        }
        if (IAtomContainerSet.class.equals((Object)classObject)) {
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public void write(IChemObject object) throws CDKException {
        try {
            if (object instanceof IAtomContainerSet) {
                this.writeMoleculeSet((IAtomContainerSet)object);
                return;
            }
            if (object instanceof IChemFile) {
                this.writeChemFile((IChemFile)object);
                return;
            }
            if (object instanceof IChemModel) {
                IChemFile file = object.getBuilder().newInstance(IChemFile.class, new Object[0]);
                IChemSequence sequence = object.getBuilder().newInstance(IChemSequence.class, new Object[0]);
                sequence.addChemModel((IChemModel)object);
                file.addChemSequence(sequence);
                this.writeChemFile(file);
                return;
            }
            if (object instanceof IAtomContainer) {
                this.writeMolecule((IAtomContainer)object);
                return;
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            logger.debug(ex);
            throw new CDKException("Exception while writing MDL file: " + ex.getMessage(), ex);
        }
        throw new CDKException("Only supported is writing of ChemFile, MoleculeSet, AtomContainer and Molecule objects.");
    }

    private void writeMoleculeSet(IAtomContainerSet som) throws Exception {
        for (IAtomContainer mol : som.atomContainers()) {
            this.writeMolecule(mol);
        }
    }

    private void writeChemFile(IChemFile file) throws Exception {
        for (IAtomContainer container : ChemFileManipulator.getAllAtomContainers(file)) {
            this.writeMolecule(container);
        }
    }

    private void writeMolecule(IAtomContainer container) throws CDKException {
        try {
            StringWriter stringWriter = new StringWriter();
            MDLV2000Writer mdlWriter = new MDLV2000Writer(stringWriter);
            mdlWriter.addSettings(this.getSettings());
            mdlWriter.write(container);
            mdlWriter.close();
            this.writer.write(stringWriter.toString());
            Map<Object, Object> sdFields = container.getProperties();
            if (sdFields != null) {
                for (Object propKey : sdFields.keySet()) {
                    if (this.isCDKInternalProperty(propKey)) continue;
                    this.writer.write("> <" + propKey + ">");
                    this.writer.newLine();
                    this.writer.write("" + sdFields.get(propKey));
                    this.writer.newLine();
                    this.writer.newLine();
                }
            }
            this.writer.write("$$$$\n");
        }
        catch (IOException exception) {
            throw new CDKException("Error while writing a SD file entry: " + exception.getMessage(), exception);
        }
    }

    private boolean isCDKInternalProperty(Object propKey) {
        return cdkInternalProperties.contains(propKey);
    }

    private void initIOSettings() {
        this.writerProperties = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("writeProperties", IOSetting.Importance.LOW, "Should molecular properties be written?", "true"));
        this.addSettings(new MDLV2000Writer().getSettings());
    }

    public void customizeJob() {
        for (IOSetting setting : this.getSettings()) {
            this.fireIOSettingQuestion(setting);
        }
    }

    static {
        cdkInternalProperties.add("CanonicalLabel");
        cdkInternalProperties.add("InvariancePair");
    }
}

