/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;

@TestClass(value="org.openscience.cdk.io.formats.MDLRXNV3000FormatTest")
public class MDLRXNV3000Format
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;
    boolean isRXN = false;

    private MDLRXNV3000Format() {
    }

    @TestMethod(value="testResourceFormatSet")
    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new MDLRXNV3000Format();
        }
        return myself;
    }

    @TestMethod(value="testGetFormatName")
    public String getFormatName() {
        return "MDL RXN V3000";
    }

    @TestMethod(value="testGetMIMEType")
    public String getMIMEType() {
        return "chemical/x-mdl-rxnfile";
    }

    @TestMethod(value="testGetPreferredNameExtension")
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @TestMethod(value="testGetNameExtensions")
    public String[] getNameExtensions() {
        return new String[]{"rxn"};
    }

    @TestMethod(value="testGetReaderClassName")
    public String getReaderClassName() {
        return "org.openscience.cdk.io.MDLRXNV3000Reader";
    }

    @TestMethod(value="testGetWriterClassName")
    public String getWriterClassName() {
        return null;
    }

    @TestMethod(value="testMatches")
    public boolean matches(int lineNumber, String line) {
        if (lineNumber == 1) {
            this.isRXN = line.indexOf("$RXN") != -1;
        } else if (lineNumber == 5 && this.isRXN) {
            try {
                String atomCountString = line.substring(0, 3).trim();
                String bondCountString = line.substring(3, 6).trim();
                Integer.valueOf(atomCountString);
                Integer.valueOf(bondCountString);
                if (line.length() > 6) {
                    String remainder = line.substring(6).trim();
                    for (int i = 0; i < remainder.length(); ++i) {
                        char c = remainder.charAt(i);
                        if (Character.isDigit(c) || Character.isWhitespace(c)) continue;
                        return false;
                    }
                }
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            return true;
        }
        return false;
    }

    @TestMethod(value="testIsXMLBased")
    public boolean isXMLBased() {
        return false;
    }

    @TestMethod(value="testGetSupportedDataFeatures")
    public int getSupportedDataFeatures() {
        return 0;
    }

    @TestMethod(value="testGetRequiredDataFeatures")
    public int getRequiredDataFeatures() {
        return 0;
    }
}

