/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.isomorphism.mcss.RGraph;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.isomorphism.mcss.RNode;
import org.openscience.cdk.tools.manipulator.BondManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniversalIsomorphismTester {
    static final int ID1 = 0;
    static final int ID2 = 1;
    private long start;
    private long timeout = -1L;

    public boolean isIsomorph(IAtomContainer g1, IAtomContainer g2) throws CDKException {
        if (g1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        if (g2.getAtomCount() != g1.getAtomCount()) {
            return false;
        }
        if (g2.getAtomCount() == 1) {
            IAtom atom = g1.getAtom(0);
            IAtom atom2 = g2.getAtom(0);
            if (atom instanceof IQueryAtom) {
                IQueryAtom qAtom = (IQueryAtom)atom;
                return qAtom.matches(g2.getAtom(0));
            }
            if (atom2 instanceof IQueryAtom) {
                IQueryAtom qAtom = (IQueryAtom)atom2;
                return qAtom.matches(g1.getAtom(0));
            }
            String atomSymbol = atom.getSymbol();
            return g1.getAtom(0).getSymbol().equals(atomSymbol);
        }
        return this.getIsomorphMap(g1, g2) != null;
    }

    public List<RMap> getIsomorphMap(IAtomContainer g1, IAtomContainer g2) throws CDKException {
        if (g1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        List<RMap> result = null;
        List<List<RMap>> rMapsList = this.search(g1, g2, UniversalIsomorphismTester.getBitSet(g1), UniversalIsomorphismTester.getBitSet(g2), false, false);
        if (!rMapsList.isEmpty()) {
            result = rMapsList.get(0);
        }
        return result;
    }

    public List<RMap> getIsomorphAtomsMap(IAtomContainer g1, IAtomContainer g2) throws CDKException {
        if (g1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        List<RMap> list = UniversalIsomorphismTester.checkSingleAtomCases(g1, g2);
        if (list == null) {
            return UniversalIsomorphismTester.makeAtomsMapOfBondsMap(this.getIsomorphMap(g1, g2), g1, g2);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<List<RMap>> getIsomorphMaps(IAtomContainer g1, IAtomContainer g2) throws CDKException {
        return this.search(g1, g2, UniversalIsomorphismTester.getBitSet(g1), UniversalIsomorphismTester.getBitSet(g2), true, true);
    }

    public List<List<RMap>> getSubgraphMaps(IAtomContainer g1, IAtomContainer g2) throws CDKException {
        return this.search(g1, g2, new BitSet(), UniversalIsomorphismTester.getBitSet(g2), true, true);
    }

    public List<RMap> getSubgraphMap(IAtomContainer g1, IAtomContainer g2) throws CDKException {
        List<RMap> result = null;
        List<List<RMap>> rMapsList = this.search(g1, g2, new BitSet(), UniversalIsomorphismTester.getBitSet(g2), false, false);
        if (!rMapsList.isEmpty()) {
            result = rMapsList.get(0);
        }
        return result;
    }

    public List<List<RMap>> getSubgraphAtomsMaps(IAtomContainer g1, IAtomContainer g2) throws CDKException {
        List<RMap> list = UniversalIsomorphismTester.checkSingleAtomCases(g1, g2);
        if (list == null) {
            return UniversalIsomorphismTester.makeAtomsMapsOfBondsMaps(this.getSubgraphMaps(g1, g2), g1, g2);
        }
        ArrayList<List<RMap>> atomsMap = new ArrayList<List<RMap>>();
        atomsMap.add(list);
        return atomsMap;
    }

    public List<RMap> getSubgraphAtomsMap(IAtomContainer g1, IAtomContainer g2) throws CDKException {
        List<RMap> list = UniversalIsomorphismTester.checkSingleAtomCases(g1, g2);
        if (list == null) {
            return UniversalIsomorphismTester.makeAtomsMapOfBondsMap(this.getSubgraphMap(g1, g2), g1, g2);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public boolean isSubgraph(IAtomContainer g1, IAtomContainer g2) throws CDKException {
        if (g1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        if (g2.getAtomCount() > g1.getAtomCount()) {
            return false;
        }
        if (g2.getAtomCount() == 1) {
            IAtom atom = g2.getAtom(0);
            for (int i = 0; i < g1.getAtomCount(); ++i) {
                IQueryAtom qAtom;
                IAtom atom2 = g1.getAtom(i);
                if (!(atom instanceof IQueryAtom ? (qAtom = (IQueryAtom)atom).matches(atom2) : (atom2 instanceof IQueryAtom ? (qAtom = (IQueryAtom)atom2).matches(atom) : atom2.getSymbol().equals(atom.getSymbol())))) continue;
                return true;
            }
            return false;
        }
        if (!UniversalIsomorphismTester.testSubgraphHeuristics(g1, g2)) {
            return false;
        }
        return this.getSubgraphMap(g1, g2) != null;
    }

    public List<IAtomContainer> getOverlaps(IAtomContainer g1, IAtomContainer g2) throws CDKException {
        this.start = System.currentTimeMillis();
        List<List<RMap>> rMapsList = this.search(g1, g2, new BitSet(), new BitSet(), true, false);
        List<IAtomContainer> graphList = UniversalIsomorphismTester.projectList(rMapsList, g1, 0);
        return this.getMaximum(graphList);
    }

    public static BitSet getBitSet(IAtomContainer ac) {
        BitSet bs;
        int n = ac.getBondCount();
        if (n != 0) {
            bs = new BitSet(n);
            for (int i = 0; i < n; ++i) {
                bs.set(i);
            }
        } else {
            bs = new BitSet();
        }
        return bs;
    }

    public static RGraph buildRGraph(IAtomContainer g1, IAtomContainer g2) throws CDKException {
        RGraph rGraph = new RGraph();
        UniversalIsomorphismTester.nodeConstructor(rGraph, g1, g2);
        UniversalIsomorphismTester.arcConstructor(rGraph, g1, g2);
        return rGraph;
    }

    public List<List<RMap>> search(IAtomContainer g1, IAtomContainer g2, BitSet c1, BitSet c2, boolean findAllStructure, boolean findAllMap) throws CDKException {
        this.start = System.currentTimeMillis();
        if (g2.getAtomCount() == 1) {
            ArrayList<List<RMap>> matches = new ArrayList<List<RMap>>();
            IAtom queryAtom = g2.getAtom(0);
            if (queryAtom instanceof IQueryAtom) {
                IQueryAtom qAtom = (IQueryAtom)queryAtom;
                for (IAtom atom : g1.atoms()) {
                    if (!qAtom.matches(atom)) continue;
                    ArrayList<RMap> lmap = new ArrayList<RMap>();
                    lmap.add(new RMap(g1.getAtomNumber(atom), 0));
                    matches.add(lmap);
                }
            } else {
                for (IAtom atom : g1.atoms()) {
                    if (!queryAtom.getSymbol().equals(atom.getSymbol())) continue;
                    ArrayList<RMap> lmap = new ArrayList<RMap>();
                    lmap.add(new RMap(g1.getAtomNumber(atom), 0));
                    matches.add(lmap);
                }
            }
            return matches;
        }
        ArrayList<List<RMap>> rMapsList = new ArrayList<List<RMap>>();
        RGraph rGraph = UniversalIsomorphismTester.buildRGraph(g1, g2);
        rGraph.setTimeout(this.timeout);
        rGraph.setStart(this.start);
        rGraph.parse(c1, c2, findAllStructure, findAllMap);
        List<BitSet> solutionList = rGraph.getSolutions();
        for (BitSet set : solutionList) {
            rMapsList.add(rGraph.bitSetToRMap(set));
        }
        return rMapsList;
    }

    public static IAtomContainer project(List<RMap> rMapList, IAtomContainer g, int id) {
        IAtomContainer ac = g.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        HashMap<IAtom, IAtom> table = new HashMap<IAtom, IAtom>();
        for (RMap rMap : rMapList) {
            IAtom a2;
            IBond bond = id == 0 ? g.getBond(rMap.getId1()) : g.getBond(rMap.getId2());
            IAtom a = bond.getAtom(0);
            IAtom a1 = (IAtom)table.get(a);
            if (a1 == null) {
                try {
                    a1 = (IAtom)a.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                ac.addAtom(a1);
                table.put(a, a1);
            }
            if ((a2 = (IAtom)table.get(a = bond.getAtom(1))) == null) {
                try {
                    a2 = (IAtom)a.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                ac.addAtom(a2);
                table.put(a, a2);
            }
            IBond newBond = g.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, bond.getOrder()});
            newBond.setFlag(32, bond.getFlag(32));
            ac.addBond(newBond);
        }
        return ac;
    }

    public static List<IAtomContainer> projectList(List<List<RMap>> rMapsList, IAtomContainer g, int id) {
        ArrayList<IAtomContainer> graphList = new ArrayList<IAtomContainer>();
        for (List<RMap> rMapList : rMapsList) {
            IAtomContainer ac = UniversalIsomorphismTester.project(rMapList, g, id);
            graphList.add(ac);
        }
        return graphList;
    }

    private List<IAtomContainer> getMaximum(List<IAtomContainer> graphList) throws CDKException {
        ArrayList<IAtomContainer> reducedGraphList = new ArrayList<IAtomContainer>();
        reducedGraphList.addAll(graphList);
        for (int i = 0; i < graphList.size(); ++i) {
            IAtomContainer gi = graphList.get(i);
            for (int j = i + 1; j < graphList.size(); ++j) {
                IAtomContainer gj = graphList.get(j);
                if (this.isSubgraph(gj, gi)) {
                    reducedGraphList.remove(gi);
                    continue;
                }
                if (!this.isSubgraph(gi, gj)) continue;
                reducedGraphList.remove(gj);
            }
        }
        return reducedGraphList;
    }

    public static List<RMap> checkSingleAtomCases(IAtomContainer g1, IAtomContainer g2) throws CDKException {
        if (g1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        if (g2.getAtomCount() == 1) {
            ArrayList<RMap> arrayList = new ArrayList<RMap>();
            IAtom atom = g2.getAtom(0);
            if (atom instanceof IQueryAtom) {
                IQueryAtom qAtom = (IQueryAtom)atom;
                for (int i = 0; i < g1.getAtomCount(); ++i) {
                    if (!qAtom.matches(g1.getAtom(i))) continue;
                    arrayList.add(new RMap(i, 0));
                }
            } else {
                String atomSymbol = atom.getSymbol();
                for (int i = 0; i < g1.getAtomCount(); ++i) {
                    if (!g1.getAtom(i).getSymbol().equals(atomSymbol)) continue;
                    arrayList.add(new RMap(i, 0));
                }
            }
            return arrayList;
        }
        if (g1.getAtomCount() == 1) {
            ArrayList<RMap> arrayList = new ArrayList<RMap>();
            IAtom atom = g1.getAtom(0);
            for (int i = 0; i < g2.getAtomCount(); ++i) {
                IAtom atom2 = g2.getAtom(i);
                if (atom2 instanceof IQueryAtom) {
                    IQueryAtom qAtom = (IQueryAtom)atom2;
                    if (!qAtom.matches(atom)) continue;
                    arrayList.add(new RMap(0, i));
                    continue;
                }
                if (!atom2.getSymbol().equals(atom.getSymbol())) continue;
                arrayList.add(new RMap(0, i));
            }
            return arrayList;
        }
        return null;
    }

    public static List<List<RMap>> makeAtomsMapsOfBondsMaps(List<List<RMap>> l, IAtomContainer g1, IAtomContainer g2) {
        if (l == null) {
            return l;
        }
        if (g2.getAtomCount() == 1) {
            return l;
        }
        ArrayList<List<RMap>> result = new ArrayList<List<RMap>>();
        for (List<RMap> l2 : l) {
            result.add(UniversalIsomorphismTester.makeAtomsMapOfBondsMap(l2, g1, g2));
        }
        return result;
    }

    public static List<RMap> makeAtomsMapOfBondsMap(List<RMap> l, IAtomContainer g1, IAtomContainer g2) {
        if (l == null) {
            return l;
        }
        ArrayList<RMap> result = new ArrayList<RMap>();
        for (int i = 0; i < l.size(); ++i) {
            IBond bond1 = g1.getBond(l.get(i).getId1());
            IBond bond2 = g2.getBond(l.get(i).getId2());
            IAtom[] atom1 = BondManipulator.getAtomArray(bond1);
            IAtom[] atom2 = BondManipulator.getAtomArray(bond2);
            for (int j = 0; j < 2; ++j) {
                List<IBond> bondsConnectedToAtom1j = g1.getConnectedBondsList(atom1[j]);
                for (int k = 0; k < bondsConnectedToAtom1j.size(); ++k) {
                    if (bondsConnectedToAtom1j.get(k) == bond1) continue;
                    IBond testBond = bondsConnectedToAtom1j.get(k);
                    for (int m = 0; m < l.size(); ++m) {
                        if (l.get(m).getId1() != g1.getBondNumber(testBond)) continue;
                        IBond testBond2 = g2.getBond(l.get(m).getId2());
                        for (int n = 0; n < 2; ++n) {
                            RMap map2;
                            List<IBond> bondsToTest = g2.getConnectedBondsList(atom2[n]);
                            if (!bondsToTest.contains(testBond2)) continue;
                            RMap map = j == n ? new RMap(g1.getAtomNumber(atom1[0]), g2.getAtomNumber(atom2[0])) : new RMap(g1.getAtomNumber(atom1[1]), g2.getAtomNumber(atom2[0]));
                            if (!result.contains(map)) {
                                result.add(map);
                            }
                            if (result.contains(map2 = j == n ? new RMap(g1.getAtomNumber(atom1[1]), g2.getAtomNumber(atom2[1])) : new RMap(g1.getAtomNumber(atom1[0]), g2.getAtomNumber(atom2[1])))) continue;
                            result.add(map2);
                        }
                    }
                }
            }
        }
        return result;
    }

    private static void nodeConstructor(RGraph gr, IAtomContainer ac1, IAtomContainer ac2) throws CDKException {
        if (ac1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        gr.clear();
        for (int i = 0; i < ac1.getBondCount(); ++i) {
            for (int j = 0; j < ac2.getBondCount(); ++j) {
                IBond bondA2 = ac2.getBond(j);
                if (bondA2 instanceof IQueryBond) {
                    IQueryBond queryBond = (IQueryBond)bondA2;
                    IQueryAtom atom1 = (IQueryAtom)bondA2.getAtom(0);
                    IQueryAtom atom2 = (IQueryAtom)bondA2.getAtom(1);
                    IBond bond = ac1.getBond(i);
                    if (!queryBond.matches(bond) || (!atom1.matches(bond.getAtom(0)) || !atom2.matches(bond.getAtom(1))) && (!atom1.matches(bond.getAtom(1)) || !atom2.matches(bond.getAtom(0)))) continue;
                    gr.addNode(new RNode(i, j));
                    continue;
                }
                if ((ac1.getBond(i).getOrder() != ac2.getBond(j).getOrder() || ac1.getBond(i).getFlag(32) != ac2.getBond(j).getFlag(32)) && (!ac1.getBond(i).getFlag(32) || !ac2.getBond(j).getFlag(32)) || (!ac1.getBond(i).getAtom(0).getSymbol().equals(ac2.getBond(j).getAtom(0).getSymbol()) || !ac1.getBond(i).getAtom(1).getSymbol().equals(ac2.getBond(j).getAtom(1).getSymbol())) && (!ac1.getBond(i).getAtom(0).getSymbol().equals(ac2.getBond(j).getAtom(1).getSymbol()) || !ac1.getBond(i).getAtom(1).getSymbol().equals(ac2.getBond(j).getAtom(0).getSymbol()))) continue;
                gr.addNode(new RNode(i, j));
            }
        }
    }

    private static void arcConstructor(RGraph gr, IAtomContainer ac1, IAtomContainer ac2) throws CDKException {
        for (int i = 0; i < gr.getGraph().size(); ++i) {
            RNode x = gr.getGraph().get(i);
            x.getForbidden().set(i);
        }
        gr.setFirstGraphSize(ac1.getBondCount());
        gr.setSecondGraphSize(ac2.getBondCount());
        for (int i = 0; i < gr.getGraph().size(); ++i) {
            RNode x = gr.getGraph().get(i);
            for (int j = i + 1; j < gr.getGraph().size(); ++j) {
                RNode y = gr.getGraph().get(j);
                IBond a1 = ac1.getBond(x.getRMap().getId1());
                IBond a2 = ac2.getBond(x.getRMap().getId2());
                IBond b1 = ac1.getBond(y.getRMap().getId1());
                IBond b2 = ac2.getBond(y.getRMap().getId2());
                if (a2 instanceof IQueryBond) {
                    if (a1.equals(b1) || a2.equals(b2) || !UniversalIsomorphismTester.queryAdjacencyAndOrder(a1, b1, a2, b2)) {
                        x.getForbidden().set(j);
                        y.getForbidden().set(i);
                        continue;
                    }
                    if (!UniversalIsomorphismTester.hasCommonAtom(a1, b1)) continue;
                    x.getExtension().set(j);
                    y.getExtension().set(i);
                    continue;
                }
                if (a1.equals(b1) || a2.equals(b2) || !UniversalIsomorphismTester.getCommonSymbol(a1, b1).equals(UniversalIsomorphismTester.getCommonSymbol(a2, b2))) {
                    x.getForbidden().set(j);
                    y.getForbidden().set(i);
                    continue;
                }
                if (!UniversalIsomorphismTester.hasCommonAtom(a1, b1)) continue;
                x.getExtension().set(j);
                y.getExtension().set(i);
            }
        }
    }

    private static boolean hasCommonAtom(IBond a, IBond b) {
        return a.contains(b.getAtom(0)) || a.contains(b.getAtom(1));
    }

    private static String getCommonSymbol(IBond a, IBond b) {
        String symbol = "";
        if (a.contains(b.getAtom(0))) {
            symbol = b.getAtom(0).getSymbol();
        } else if (a.contains(b.getAtom(1))) {
            symbol = b.getAtom(1).getSymbol();
        }
        return symbol;
    }

    private static boolean queryAdjacency(IBond a1, IBond b1, IBond a2, IBond b2) {
        IAtom atom1 = null;
        IAtom atom2 = null;
        if (a1.contains(b1.getAtom(0))) {
            atom1 = b1.getAtom(0);
        } else if (a1.contains(b1.getAtom(1))) {
            atom1 = b1.getAtom(1);
        }
        if (a2.contains(b2.getAtom(0))) {
            atom2 = b2.getAtom(0);
        } else if (a2.contains(b2.getAtom(1))) {
            atom2 = b2.getAtom(1);
        }
        if (atom1 != null && atom2 != null) {
            return ((IQueryAtom)atom2).matches(atom1);
        }
        return atom1 == null && atom2 == null;
    }

    private static boolean queryAdjacencyAndOrder(IBond bond1, IBond bond2, IBond queryBond1, IBond queryBond2) {
        IAtom centralAtom = null;
        IAtom centralQueryAtom = null;
        if (bond1.contains(bond2.getAtom(0))) {
            centralAtom = bond2.getAtom(0);
        } else if (bond1.contains(bond2.getAtom(1))) {
            centralAtom = bond2.getAtom(1);
        }
        if (queryBond1.contains(queryBond2.getAtom(0))) {
            centralQueryAtom = queryBond2.getAtom(0);
        } else if (queryBond1.contains(queryBond2.getAtom(1))) {
            centralQueryAtom = queryBond2.getAtom(1);
        }
        if (centralAtom != null && centralQueryAtom != null && ((IQueryAtom)centralQueryAtom).matches(centralAtom)) {
            IQueryAtom queryAtom1 = (IQueryAtom)queryBond1.getConnectedAtom(centralQueryAtom);
            IQueryAtom queryAtom2 = (IQueryAtom)queryBond2.getConnectedAtom(centralQueryAtom);
            IAtom atom1 = bond1.getConnectedAtom(centralAtom);
            IAtom atom2 = bond2.getConnectedAtom(centralAtom);
            return queryAtom1.matches(atom1) && queryAtom2.matches(atom2) || queryAtom1.matches(atom2) && queryAtom2.matches(atom1);
        }
        return centralAtom == null && centralQueryAtom == null;
    }

    private static boolean testSubgraphHeuristics(IAtomContainer ac1, IAtomContainer ac2) throws CDKException {
        IAtom atom;
        IBond bond;
        int i;
        if (ac1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        int ac1SingleBondCount = 0;
        int ac1DoubleBondCount = 0;
        int ac1TripleBondCount = 0;
        int ac1AromaticBondCount = 0;
        int ac2SingleBondCount = 0;
        int ac2DoubleBondCount = 0;
        int ac2TripleBondCount = 0;
        int ac2AromaticBondCount = 0;
        int ac1SCount = 0;
        int ac1OCount = 0;
        int ac1NCount = 0;
        int ac1FCount = 0;
        int ac1ClCount = 0;
        int ac1BrCount = 0;
        int ac1ICount = 0;
        int ac1CCount = 0;
        int ac2SCount = 0;
        int ac2OCount = 0;
        int ac2NCount = 0;
        int ac2FCount = 0;
        int ac2ClCount = 0;
        int ac2BrCount = 0;
        int ac2ICount = 0;
        int ac2CCount = 0;
        for (i = 0; i < ac1.getBondCount(); ++i) {
            bond = ac1.getBond(i);
            if (bond.getFlag(32)) {
                ++ac1AromaticBondCount;
                continue;
            }
            if (bond.getOrder() == IBond.Order.SINGLE) {
                ++ac1SingleBondCount;
                continue;
            }
            if (bond.getOrder() == IBond.Order.DOUBLE) {
                ++ac1DoubleBondCount;
                continue;
            }
            if (bond.getOrder() != IBond.Order.TRIPLE) continue;
            ++ac1TripleBondCount;
        }
        for (i = 0; i < ac2.getBondCount(); ++i) {
            bond = ac2.getBond(i);
            if (bond instanceof IQueryBond) continue;
            if (bond.getFlag(32)) {
                ++ac2AromaticBondCount;
                continue;
            }
            if (bond.getOrder() == IBond.Order.SINGLE) {
                ++ac2SingleBondCount;
                continue;
            }
            if (bond.getOrder() == IBond.Order.DOUBLE) {
                ++ac2DoubleBondCount;
                continue;
            }
            if (bond.getOrder() != IBond.Order.TRIPLE) continue;
            ++ac2TripleBondCount;
        }
        if (ac2SingleBondCount > ac1SingleBondCount) {
            return false;
        }
        if (ac2AromaticBondCount > ac1AromaticBondCount) {
            return false;
        }
        if (ac2DoubleBondCount > ac1DoubleBondCount) {
            return false;
        }
        if (ac2TripleBondCount > ac1TripleBondCount) {
            return false;
        }
        for (i = 0; i < ac1.getAtomCount(); ++i) {
            atom = ac1.getAtom(i);
            if (atom.getSymbol().equals("S")) {
                ++ac1SCount;
                continue;
            }
            if (atom.getSymbol().equals("N")) {
                ++ac1NCount;
                continue;
            }
            if (atom.getSymbol().equals("O")) {
                ++ac1OCount;
                continue;
            }
            if (atom.getSymbol().equals("F")) {
                ++ac1FCount;
                continue;
            }
            if (atom.getSymbol().equals("Cl")) {
                ++ac1ClCount;
                continue;
            }
            if (atom.getSymbol().equals("Br")) {
                ++ac1BrCount;
                continue;
            }
            if (atom.getSymbol().equals("I")) {
                ++ac1ICount;
                continue;
            }
            if (!atom.getSymbol().equals("C")) continue;
            ++ac1CCount;
        }
        for (i = 0; i < ac2.getAtomCount(); ++i) {
            atom = ac2.getAtom(i);
            if (atom instanceof IQueryAtom) continue;
            if (atom.getSymbol().equals("S")) {
                ++ac2SCount;
                continue;
            }
            if (atom.getSymbol().equals("N")) {
                ++ac2NCount;
                continue;
            }
            if (atom.getSymbol().equals("O")) {
                ++ac2OCount;
                continue;
            }
            if (atom.getSymbol().equals("F")) {
                ++ac2FCount;
                continue;
            }
            if (atom.getSymbol().equals("Cl")) {
                ++ac2ClCount;
                continue;
            }
            if (atom.getSymbol().equals("Br")) {
                ++ac2BrCount;
                continue;
            }
            if (atom.getSymbol().equals("I")) {
                ++ac2ICount;
                continue;
            }
            if (!atom.getSymbol().equals("C")) continue;
            ++ac2CCount;
        }
        if (ac1SCount < ac2SCount) {
            return false;
        }
        if (ac1NCount < ac2NCount) {
            return false;
        }
        if (ac1OCount < ac2OCount) {
            return false;
        }
        if (ac1FCount < ac2FCount) {
            return false;
        }
        if (ac1ClCount < ac2ClCount) {
            return false;
        }
        if (ac1BrCount < ac2BrCount) {
            return false;
        }
        if (ac1ICount < ac2ICount) {
            return false;
        }
        return ac1CCount >= ac2CCount;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

