/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.List;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class CDKUtilities {
    public static String fixSmiles(String Smiles) {
        Smiles = Smiles.replaceAll("CL", "Cl");
        Smiles = Smiles.replaceAll("(H)", "([H])");
        Smiles = Smiles.trim();
        return Smiles;
    }

    private static boolean fixNitroGroups(IAtomContainer m) {
        boolean changed = false;
        try {
            for (int i = 0; i <= m.getAtomCount() - 1; ++i) {
                int j;
                List<IAtom> ca;
                IAtom a = m.getAtom(i);
                boolean nitro = false;
                if (!a.getSymbol().equals("N") || (ca = m.getConnectedAtomsList(a)).size() != 3) continue;
                IAtom[] cao = new IAtom[2];
                int count = 0;
                for (j = 0; j <= 2; ++j) {
                    if (!ca.get(j).getSymbol().equals("O")) continue;
                    ++count;
                }
                if (count <= true) continue;
                count = 0;
                for (j = 0; j <= 2; ++j) {
                    IAtom caj = ca.get(j);
                    if (!caj.getSymbol().equals("O") || m.getConnectedAtomsCount(caj) != 1) continue;
                    cao[count] = caj;
                    ++count;
                }
                IBond.Order order1 = m.getBond(a, cao[0]).getOrder();
                IBond.Order order2 = m.getBond(a, cao[1]).getOrder();
                if (order1 != IBond.Order.SINGLE || order2 != IBond.Order.DOUBLE) continue;
                a.setFormalCharge(1);
                cao[0].setFormalCharge(-1);
                m.getBond(a, cao[0]).setOrder(IBond.Order.SINGLE);
                changed = true;
            }
            return changed;
        }
        catch (Exception e) {
            return changed;
        }
    }

    public static boolean fixNitroGroups2(IAtomContainer m) {
        boolean changed = false;
        try {
            for (int i = 0; i <= m.getAtomCount() - 1; ++i) {
                IAtom caj;
                int j;
                List<IAtom> ca;
                IAtom a = m.getAtom(i);
                boolean nitro = false;
                if (!a.getSymbol().equals("N") || (ca = m.getConnectedAtomsList(a)).size() != 3) continue;
                IAtom[] cao = new IAtom[2];
                int count = 0;
                for (j = 0; j <= 2; ++j) {
                    caj = ca.get(j);
                    if (!caj.getSymbol().equals("O")) continue;
                    ++count;
                }
                if (count <= true) continue;
                count = 0;
                for (j = 0; j <= 2; ++j) {
                    caj = ca.get(j);
                    if (!caj.getSymbol().equals("O") || m.getConnectedAtomsCount(caj) != 1) continue;
                    cao[count] = caj;
                    ++count;
                }
                IBond.Order order1 = m.getBond(a, cao[0]).getOrder();
                IBond.Order order2 = m.getBond(a, cao[1]).getOrder();
                if ((order1 != IBond.Order.SINGLE || order2 != IBond.Order.DOUBLE) && (order1 != IBond.Order.DOUBLE || order2 != IBond.Order.SINGLE)) continue;
                a.setFormalCharge(0);
                cao[0].setFormalCharge(0);
                cao[1].setFormalCharge(0);
                m.getBond(a, cao[0]).setOrder(IBond.Order.DOUBLE);
                m.getBond(a, cao[1]).setOrder(IBond.Order.DOUBLE);
                changed = true;
            }
            return changed;
        }
        catch (Exception e) {
            return changed;
        }
    }

    public static void fixAromaticityForXLogP(IAtomContainer m) {
        IRingSet rs = null;
        try {
            AllRingsFinder arf = new AllRingsFinder();
            rs = arf.findAllRings(m);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(m);
            CDKHueckelAromaticityDetector.detectAromaticity(m);
            RingSetManipulator.markAromaticRings(rs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i <= m.getAtomCount() - 1; ++i) {
            m.getAtom(i).setFlag(32, false);
            for (int j = 0; j <= rs.getAtomContainerCount() - 1; ++j) {
                boolean haveatom;
                IRing r = (IRing)rs.getAtomContainer(j);
                if (!r.getFlag(32) || !(haveatom = r.contains(m.getAtom(i))) || r.getAtomCount() != 6) continue;
                m.getAtom(i).setFlag(32, true);
            }
        }
    }

    public static void fixSulphurH(IAtomContainer m) {
        for (int i = 0; i <= m.getAtomCount() - 1; ++i) {
            IAtom conAtom;
            int j;
            IAtom a = m.getAtom(i);
            if (!a.getSymbol().equals("S")) continue;
            List<IAtom> connectedAtoms = m.getConnectedAtomsList(a);
            int bondOrderSum = 0;
            double oldBondOrderSum = m.getBondOrderSum(a);
            for (j = 0; j < connectedAtoms.size(); ++j) {
                conAtom = connectedAtoms.get(j);
                if (conAtom.getSymbol().equals("H")) continue;
                IBond bond = m.getBond(a, conAtom);
                if (bond.getOrder() == IBond.Order.SINGLE) {
                    ++bondOrderSum;
                    continue;
                }
                if (bond.getOrder() == IBond.Order.DOUBLE) {
                    bondOrderSum += 2;
                    continue;
                }
                if (bond.getOrder() == IBond.Order.TRIPLE) {
                    bondOrderSum += 3;
                    continue;
                }
                if (bond.getOrder() != IBond.Order.QUADRUPLE) continue;
                bondOrderSum += 4;
            }
            if (bondOrderSum <= true) continue;
            for (j = 0; j < connectedAtoms.size(); ++j) {
                conAtom = connectedAtoms.get(j);
                if (!conAtom.getSymbol().equals("H")) continue;
                m.removeAtomAndConnectedElectronContainers(conAtom);
            }
        }
    }
}

