/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.inchi;

import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.AtomContainerSet;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.io.inchi.INChIContentProcessorTool;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class INChIHandler
extends DefaultHandler {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(INChIHandler.class);
    private INChIContentProcessorTool inchiTool = new INChIContentProcessorTool();
    private ChemFile chemFile;
    private ChemSequence chemSequence;
    private ChemModel chemModel;
    private IAtomContainerSet setOfMolecules;
    private IAtomContainer tautomer;
    private String currentChars;

    public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
        logger.info("DocType root element: " + name);
        logger.info("DocType root PUBLIC: " + publicId);
        logger.info("DocType root SYSTEM: " + systemId);
    }

    @Override
    public void startDocument() {
        this.chemFile = new ChemFile();
        this.chemSequence = new ChemSequence();
        this.chemModel = new ChemModel();
        this.setOfMolecules = new AtomContainerSet();
    }

    @Override
    public void endDocument() {
        this.chemFile.addChemSequence(this.chemSequence);
    }

    @Override
    public void endElement(String uri, String local, String raw) {
        logger.debug("end element: ", raw);
        if ("identifier".equals(local)) {
            if (this.tautomer != null) {
                this.setOfMolecules.addAtomContainer(this.tautomer);
                this.chemModel.setMoleculeSet(this.setOfMolecules);
                this.chemSequence.addChemModel(this.chemModel);
            }
        } else if ("formula".equals(local)) {
            if (this.tautomer != null) {
                logger.info("Parsing <formula> chars: ", this.currentChars);
                this.tautomer = new AtomContainer(this.inchiTool.processFormula(this.setOfMolecules.getBuilder().newInstance(IAtomContainer.class, new Object[0]), this.currentChars));
            } else {
                logger.warn("Cannot set atom info for empty tautomer");
            }
        } else if ("connections".equals(local)) {
            if (this.tautomer != null) {
                logger.info("Parsing <connections> chars: ", this.currentChars);
                this.inchiTool.processConnections(this.currentChars, this.tautomer, -1);
            } else {
                logger.warn("Cannot set dbond info for empty tautomer");
            }
        }
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes atts) {
        this.currentChars = "";
        logger.debug("startElement: ", raw);
        logger.debug("uri: ", uri);
        logger.debug("local: ", local);
        logger.debug("raw: ", raw);
        if ("INChI".equals(local)) {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!atts.getQName(i).equals("version")) continue;
                logger.info("INChI version: ", atts.getValue(i));
            }
        } else if ("structure".equals(local)) {
            this.tautomer = new AtomContainer();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        logger.debug("character data");
        this.currentChars = this.currentChars + new String(ch, start, length);
    }

    public ChemFile getChemFile() {
        return this.chemFile;
    }
}

