/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

final class UniqueBondMatches
implements Predicate<int[]> {
    private final Set<Set<Tuple>> unique;
    private final int[][] g;

    private UniqueBondMatches(int[][] g, int expectedHits) {
        this.unique = Sets.newHashSetWithExpectedSize(expectedHits);
        this.g = g;
    }

    public UniqueBondMatches(int[][] g) {
        this(g, 10);
    }

    @Override
    public boolean apply(int[] input) {
        return this.unique.add(this.toEdgeSet(input));
    }

    private Set<Tuple> toEdgeSet(int[] mapping) {
        HashSet<Tuple> edges = new HashSet<Tuple>(mapping.length * 2);
        for (int u = 0; u < this.g.length; ++u) {
            for (int v : this.g[u]) {
                edges.add(new Tuple(mapping[u], mapping[v]));
            }
        }
        return edges;
    }

    private static final class Tuple {
        final int u;
        final int v;

        private Tuple(int u, int v) {
            this.u = u;
            this.v = v;
        }

        public int hashCode() {
            return this.u ^ this.v;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tuple that = (Tuple)o;
            return this.u == that.u && this.v == that.v || this.u == that.v && this.v == that.u;
        }
    }
}

