/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.mcsplus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.smsd.algorithm.mcsplus.MCSPlus;
import org.openscience.cdk.smsd.filters.PostFilter;
import org.openscience.cdk.smsd.helper.FinalMappings;
import org.openscience.cdk.smsd.interfaces.AbstractMCSAlgorithm;
import org.openscience.cdk.smsd.interfaces.IMCSBase;
import org.openscience.cdk.smsd.tools.MolHandler;

public class MCSPlusHandler
extends AbstractMCSAlgorithm
implements IMCSBase {
    private static List<Map<IAtom, IAtom>> allAtomMCS = null;
    private static Map<IAtom, IAtom> atomsMCS = null;
    private static Map<Integer, Integer> firstMCS = null;
    private static List<Map<Integer, Integer>> allMCS = null;
    private IAtomContainer source = null;
    private IAtomContainer target = null;
    private boolean flagExchange = false;

    public MCSPlusHandler() {
        allAtomMCS = new ArrayList<Map<IAtom, IAtom>>();
        atomsMCS = new HashMap<IAtom, IAtom>();
        firstMCS = new TreeMap<Integer, Integer>();
        allMCS = new ArrayList<Map<Integer, Integer>>();
    }

    @Override
    public synchronized void set(MolHandler source, MolHandler target) {
        this.source = source.getMolecule();
        this.target = target.getMolecule();
    }

    @Override
    public void set(IQueryAtomContainer source, IAtomContainer target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public synchronized void searchMCS(boolean shouldMatchBonds) {
        List<List<Integer>> mappings = null;
        try {
            if (this.source.getAtomCount() >= this.target.getAtomCount()) {
                mappings = new MCSPlus().getOverlaps(this.source, this.target, shouldMatchBonds);
            } else {
                this.flagExchange = true;
                mappings = new MCSPlus().getOverlaps(this.target, this.source, shouldMatchBonds);
            }
            PostFilter.filter(mappings);
            this.setAllMapping();
            this.setAllAtomMapping();
            this.setFirstMapping();
            this.setFirstAtomMapping();
        }
        catch (CDKException e) {
            mappings = null;
        }
    }

    private synchronized void setAllMapping() {
        try {
            List<Map<Integer, Integer>> finalSolution = FinalMappings.getInstance().getFinalMapping();
            int counter = 0;
            for (Map<Integer, Integer> solution : finalSolution) {
                TreeMap<Integer, Integer> validSolution = new TreeMap<Integer, Integer>();
                if (!this.flagExchange) {
                    for (Map.Entry<Integer, Integer> map : solution.entrySet()) {
                        validSolution.put(map.getKey(), map.getValue());
                    }
                } else {
                    for (Map.Entry<Integer, Integer> map : solution.entrySet()) {
                        validSolution.put(map.getValue(), map.getKey());
                    }
                }
                allMCS.add(counter++, validSolution);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private synchronized void setAllAtomMapping() {
        try {
            int counter = 0;
            for (Map<Integer, Integer> solution : allMCS) {
                HashMap<IAtom, IAtom> atomMappings = new HashMap<IAtom, IAtom>();
                for (Map.Entry<Integer, Integer> map : solution.entrySet()) {
                    int iIndex = map.getKey();
                    int jIndex = map.getValue();
                    IAtom sourceAtom = null;
                    IAtom targetAtom = null;
                    sourceAtom = this.source.getAtom(iIndex);
                    targetAtom = this.target.getAtom(jIndex);
                    atomMappings.put(sourceAtom, targetAtom);
                }
                allAtomMCS.add(counter++, atomMappings);
            }
        }
        catch (Exception I) {
            I.getCause();
        }
    }

    private synchronized void setFirstMapping() {
        if (!allMCS.isEmpty()) {
            firstMCS = new TreeMap<Integer, Integer>(allMCS.iterator().next());
        }
    }

    private synchronized void setFirstAtomMapping() {
        if (!allAtomMCS.isEmpty()) {
            atomsMCS = new HashMap<IAtom, IAtom>(allAtomMCS.iterator().next());
        }
    }

    @Override
    public synchronized List<Map<Integer, Integer>> getAllMapping() {
        return allMCS;
    }

    @Override
    public synchronized Map<Integer, Integer> getFirstMapping() {
        return firstMCS;
    }

    @Override
    public synchronized List<Map<IAtom, IAtom>> getAllAtomMapping() {
        return allAtomMCS;
    }

    @Override
    public synchronized Map<IAtom, IAtom> getFirstAtomMapping() {
        return atomsMCS;
    }
}

