/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.OrderQueryBond;
import org.openscience.cdk.isomorphism.matchers.OrderQueryBondOrderOnly;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.SymbolAndChargeQueryAtom;
import org.openscience.cdk.isomorphism.matchers.SymbolChargeIDQueryAtom;
import org.openscience.cdk.isomorphism.matchers.SymbolQueryAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AnyAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AnyOrderQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.AromaticAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AromaticQueryBond;

public class QueryAtomContainerCreator {
    public static QueryAtomContainer createBasicQueryContainer(IAtomContainer container) {
        QueryAtomContainer queryContainer = new QueryAtomContainer(container.getBuilder());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            queryContainer.addAtom(new SymbolQueryAtom(container.getAtom(i)));
        }
        for (IBond bond : container.bonds()) {
            int index1 = container.getAtomNumber(bond.getAtom(0));
            int index2 = container.getAtomNumber(bond.getAtom(1));
            if (bond.getFlag(32)) {
                queryContainer.addBond(new AromaticQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), IBond.Order.SINGLE, container.getBuilder()));
                continue;
            }
            queryContainer.addBond(new OrderQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), bond.getOrder(), container.getBuilder()));
        }
        return queryContainer;
    }

    public static QueryAtomContainer createSymbolAndBondOrderQueryContainer(IAtomContainer container) {
        QueryAtomContainer queryContainer = new QueryAtomContainer(container.getBuilder());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            queryContainer.addAtom(new SymbolQueryAtom(container.getAtom(i)));
        }
        for (IBond bond : container.bonds()) {
            int index1 = container.getAtomNumber(bond.getAtom(0));
            int index2 = container.getAtomNumber(bond.getAtom(1));
            queryContainer.addBond(new OrderQueryBondOrderOnly((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), bond.getOrder(), container.getBuilder()));
        }
        return queryContainer;
    }

    public static QueryAtomContainer createSymbolAndChargeQueryContainer(IAtomContainer container) {
        QueryAtomContainer queryContainer = new QueryAtomContainer(container.getBuilder());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            queryContainer.addAtom(new SymbolAndChargeQueryAtom(container.getAtom(i)));
        }
        for (IBond bond : container.bonds()) {
            int index1 = container.getAtomNumber(bond.getAtom(0));
            int index2 = container.getAtomNumber(bond.getAtom(1));
            if (bond.getFlag(32)) {
                queryContainer.addBond(new AromaticQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), IBond.Order.SINGLE, container.getBuilder()));
                continue;
            }
            queryContainer.addBond(new OrderQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), bond.getOrder(), container.getBuilder()));
        }
        return queryContainer;
    }

    public static QueryAtomContainer createSymbolChargeIDQueryContainer(IAtomContainer container) {
        QueryAtomContainer queryContainer = new QueryAtomContainer(container.getBuilder());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            queryContainer.addAtom(new SymbolChargeIDQueryAtom(container.getAtom(i)));
        }
        for (IBond bond : container.bonds()) {
            int index1 = container.getAtomNumber(bond.getAtom(0));
            int index2 = container.getAtomNumber(bond.getAtom(1));
            if (bond.getFlag(32)) {
                queryContainer.addBond(new AromaticQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), IBond.Order.SINGLE, container.getBuilder()));
                continue;
            }
            queryContainer.addBond(new OrderQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), bond.getOrder(), container.getBuilder()));
        }
        return queryContainer;
    }

    public static QueryAtomContainer createAnyAtomContainer(IAtomContainer container, boolean aromaticity) {
        QueryAtomContainer queryContainer = new QueryAtomContainer(container.getBuilder());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            if (aromaticity && container.getAtom(i).getFlag(32)) {
                queryContainer.addAtom(new AromaticAtom(container.getBuilder()));
                continue;
            }
            queryContainer.addAtom(new AnyAtom(container.getBuilder()));
        }
        for (IBond bond : container.bonds()) {
            int index1 = container.getAtomNumber(bond.getAtom(0));
            int index2 = container.getAtomNumber(bond.getAtom(1));
            if (aromaticity && bond.getFlag(32)) {
                queryContainer.addBond(new AromaticQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), IBond.Order.SINGLE, container.getBuilder()));
                continue;
            }
            queryContainer.addBond(new OrderQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), bond.getOrder(), container.getBuilder()));
        }
        return queryContainer;
    }

    public static QueryAtomContainer createAnyAtomAnyBondContainer(IAtomContainer container, boolean aromaticity) {
        QueryAtomContainer queryContainer = new QueryAtomContainer(container.getBuilder());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            if (aromaticity && container.getAtom(i).getFlag(32)) {
                queryContainer.addAtom(new AromaticAtom(container.getBuilder()));
                continue;
            }
            queryContainer.addAtom(new AnyAtom(container.getBuilder()));
        }
        for (IBond bond : container.bonds()) {
            int index1 = container.getAtomNumber(bond.getAtom(0));
            int index2 = container.getAtomNumber(bond.getAtom(1));
            queryContainer.addBond(new AnyOrderQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), bond.getOrder(), container.getBuilder()));
        }
        return queryContainer;
    }

    public static QueryAtomContainer createAnyAtomForPseudoAtomQueryContainer(IAtomContainer container) {
        QueryAtomContainer queryContainer = new QueryAtomContainer(container.getBuilder());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            if (container.getAtom(i) instanceof IPseudoAtom) {
                queryContainer.addAtom(new AnyAtom(container.getBuilder()));
                continue;
            }
            queryContainer.addAtom(new SymbolQueryAtom(container.getAtom(i)));
        }
        for (IBond bond : container.bonds()) {
            int index1 = container.getAtomNumber(bond.getAtom(0));
            int index2 = container.getAtomNumber(bond.getAtom(1));
            if (bond.getFlag(32)) {
                queryContainer.addBond(new AromaticQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), IBond.Order.SINGLE, container.getBuilder()));
                continue;
            }
            queryContainer.addBond(new OrderQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), bond.getOrder(), container.getBuilder()));
        }
        return queryContainer;
    }
}

