/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.graph.ConnectedComponents;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.Ullmann;
import org.openscience.cdk.isomorphism.matchers.smarts.SmartsMatchers;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.smiles.smarts.parser.SMARTSParser;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.fingerprint.MACCSFingerprinterTest")
public class MACCSFingerprinter
implements IFingerprinter {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MACCSFingerprinter.class);
    private static final String KEY_DEFINITIONS = "data/maccs.txt";
    private volatile MaccsKey[] keys = null;
    private final Object lock = new Object();

    @TestMethod(value="testFingerprint")
    public MACCSFingerprinter() {
    }

    public MACCSFingerprinter(IChemObjectBuilder builder) {
        try {
            this.keys = this.readKeyDef(builder);
        }
        catch (IOException e) {
            logger.debug(e);
        }
        catch (CDKException e) {
            logger.debug(e);
        }
    }

    @Override
    @TestMethod(value="testFingerprint,testfp2")
    public IBitFingerprint getBitFingerprint(IAtomContainer container) throws CDKException {
        MaccsKey[] keys = this.keys(container.getBuilder());
        BitSet fp = new BitSet(keys.length);
        SmartsMatchers.prepare(container, false);
        for (int i = 0; i < keys.length; ++i) {
            Pattern pattern = keys[i].pattern;
            if (pattern == null || !pattern.matchAll(container).uniqueAtoms().atLeast(keys[i].count + 1)) continue;
            fp.set(i);
        }
        AllRingsFinder ringFinder = new AllRingsFinder();
        IRingSet rings = ringFinder.findAllRings(container);
        int ringCount = 0;
        for (int i = 0; i < rings.getAtomContainerCount(); ++i) {
            IAtomContainer ring = rings.getAtomContainer(i);
            boolean allAromatic = true;
            if (ringCount < 2) {
                for (IBond bond : ring.bonds()) {
                    if (bond.getFlag(32)) continue;
                    allAromatic = false;
                    break;
                }
            }
            if (allAromatic) {
                ++ringCount;
            }
            if (ringCount > 1) {
                fp.set(124);
            }
            if (ring.getAtomCount() < 8) continue;
            fp.set(100);
        }
        ConnectedComponents cc = new ConnectedComponents(GraphUtil.toAdjList(container));
        if (cc.nComponents() > 1) {
            fp.set(165);
        }
        return new BitSetFingerprint(fp);
    }

    @Override
    @TestMethod(value="testGetRawFingerprint")
    public Map<String, Integer> getRawFingerprint(IAtomContainer iAtomContainer) throws CDKException {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="getsize")
    public int getSize() {
        if (this.keys != null) {
            return this.keys.length;
        }
        return 0;
    }

    private MaccsKey[] readKeyDef(IChemObjectBuilder builder) throws IOException, CDKException {
        String line;
        ArrayList<MaccsKey> keys = new ArrayList<MaccsKey>(166);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(KEY_DEFINITIONS)));
        while ((line = reader.readLine()) != null) {
            if (line.charAt(0) == '#') continue;
            String data = line.substring(0, line.indexOf(124)).trim();
            String[] toks = data.split("\\s");
            keys.add(new MaccsKey(toks[1], this.createPattern(toks[1], builder), Integer.parseInt(toks[2])));
        }
        if (keys.size() != 166) {
            throw new CDKException("Found " + keys.size() + " keys during setup. Should be 166");
        }
        return keys.toArray(new MaccsKey[166]);
    }

    @Override
    @TestMethod(value="testGetRawFingerprint")
    public ICountFingerprint getCountFingerprint(IAtomContainer container) throws CDKException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MaccsKey[] keys(IChemObjectBuilder builder) throws CDKException {
        MaccsKey[] result = this.keys;
        if (result == null) {
            Object object = this.lock;
            synchronized (object) {
                result = this.keys;
                if (result == null) {
                    try {
                        result = this.readKeyDef(builder);
                        this.keys = result;
                    }
                    catch (IOException e) {
                        throw new CDKException("could not read MACCS definitions", e);
                    }
                }
            }
        }
        return result;
    }

    private Pattern createPattern(String smarts, IChemObjectBuilder builder) {
        if (smarts.equals("?")) {
            return null;
        }
        return Ullmann.findSubstructure(SMARTSParser.parse(smarts, builder));
    }

    private class MaccsKey {
        private String smarts;
        private int count;
        private Pattern pattern;

        private MaccsKey(String smarts, Pattern pattern, int count) {
            this.smarts = smarts;
            this.pattern = pattern;
            this.count = count;
        }

        public String getSmarts() {
            return this.smarts;
        }

        public int getCount() {
            return this.count;
        }
    }
}

