/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;

@TestClass(value="org.openscience.cdk.formula.MolecularFormulaTest")
public class MolecularFormula
implements IMolecularFormula {
    private static final long serialVersionUID = -2011407700837295287L;
    private Map<IIsotope, Integer> isotopes;
    private Integer charge = (Integer)CDKConstants.UNSET;
    private Map<Object, Object> properties;

    public MolecularFormula() {
        this.isotopes = new HashMap<IIsotope, Integer>();
    }

    @Override
    @TestMethod(value="testAdd_IMolecularFormula")
    public IMolecularFormula add(IMolecularFormula formula) {
        for (IIsotope newIsotope : formula.isotopes()) {
            this.addIsotope(newIsotope, formula.getIsotopeCount(newIsotope));
        }
        if (formula.getCharge() != null) {
            this.charge = this.charge + formula.getCharge();
        }
        return this;
    }

    @Override
    @TestMethod(value="addIsotope_IIsotope")
    public IMolecularFormula addIsotope(IIsotope isotope) {
        return this.addIsotope(isotope, 1);
    }

    @Override
    @TestMethod(value="testAddIsotope_IIsotope_int")
    public IMolecularFormula addIsotope(IIsotope isotope, int count) {
        boolean flag = false;
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(thisIsotope, isotope)) continue;
            this.isotopes.put(thisIsotope, this.isotopes.get(thisIsotope) + count);
            flag = true;
            break;
        }
        if (!flag) {
            this.isotopes.put(isotope, count);
        }
        return this;
    }

    @Override
    @TestMethod(value="testContains_IIsotope")
    public boolean contains(IIsotope isotope) {
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(thisIsotope, isotope)) continue;
            return true;
        }
        return false;
    }

    @Override
    @TestMethod(value="testGetCharge")
    public Integer getCharge() {
        return this.charge;
    }

    @Override
    @TestMethod(value="testGetIsotopeCount_IIsotope")
    public int getIsotopeCount(IIsotope isotope) {
        return !this.contains(isotope) ? 0 : this.isotopes.get(this.getIsotope(isotope));
    }

    @Override
    @TestMethod(value="testGetIsotopeCount")
    public int getIsotopeCount() {
        return this.isotopes.size();
    }

    private IIsotope getIsotope(IIsotope isotope) {
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(isotope, thisIsotope)) continue;
            return thisIsotope;
        }
        return null;
    }

    @Override
    @TestMethod(value="testIsotopes")
    public Iterable<IIsotope> isotopes() {
        return this.isotopes.keySet();
    }

    @Override
    @TestMethod(value="testSetCharge_Integer")
    public void setCharge(Integer charge) {
        this.charge = charge;
    }

    @Override
    @TestMethod(value="testRemoveAllIsotopes")
    public void removeAllIsotopes() {
        this.isotopes.clear();
    }

    @Override
    @TestMethod(value="testRemoveIsotope_IIsotope")
    public void removeIsotope(IIsotope isotope) {
        this.isotopes.remove(this.getIsotope(isotope));
    }

    @Override
    @TestMethod(value="testClone")
    public Object clone() throws CloneNotSupportedException {
        MolecularFormula clone = new MolecularFormula();
        for (IIsotope isotope : this.isotopes()) {
            clone.addIsotope((IIsotope)isotope.clone(), this.getIsotopeCount(isotope));
        }
        clone.setCharge(this.getCharge());
        return clone;
    }

    private Map<Object, Object> lazyProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable<Object, Object>();
        }
        return this.properties;
    }

    @Override
    @TestMethod(value="testSetProperty_Object_Object")
    public void setProperty(Object description, Object property) {
        this.lazyProperties().put(description, property);
    }

    @Override
    @TestMethod(value="testRemoveProperty_Object")
    public void removeProperty(Object description) {
        if (this.properties == null) {
            return;
        }
        this.lazyProperties().remove(description);
    }

    @Override
    public <T> T getProperty(Object description) {
        if (this.properties == null) {
            return null;
        }
        Object value = this.lazyProperties().get(description);
        return (T)value;
    }

    @Override
    public <T> T getProperty(Object description, Class<T> c) {
        Object value = this.lazyProperties().get(description);
        if (c.isInstance(value)) {
            Object typed = value;
            return (T)typed;
        }
        if (value != null) {
            throw new IllegalArgumentException("attempted to access a property of incorrect type, expected " + c.getSimpleName() + " got " + value.getClass().getSimpleName());
        }
        return null;
    }

    @Override
    @TestMethod(value="testGetProperties")
    public Map<Object, Object> getProperties() {
        return this.lazyProperties();
    }

    @Override
    @TestMethod(value="testSetProperties_Hashtable")
    public void setProperties(Map<Object, Object> properties) {
        for (Object key : properties.keySet()) {
            this.lazyProperties().put(key, properties.get(key));
        }
    }

    @TestMethod(value="testIsTheSame")
    protected boolean isTheSame(IIsotope isotopeOne, IIsotope isotopeTwo) {
        Double natAbund1 = isotopeOne.getNaturalAbundance();
        Double natAbund2 = isotopeTwo.getNaturalAbundance();
        Double exactMass1 = isotopeOne.getExactMass();
        Double exactMass2 = isotopeTwo.getExactMass();
        if (natAbund1 == null) {
            natAbund1 = -1.0;
        }
        if (natAbund2 == null) {
            natAbund2 = -1.0;
        }
        if (exactMass1 == null) {
            exactMass1 = -1.0;
        }
        if (exactMass2 == null) {
            exactMass2 = -1.0;
        }
        if (!isotopeOne.getSymbol().equals(isotopeTwo.getSymbol())) {
            return false;
        }
        if (natAbund1.doubleValue() != natAbund2.doubleValue()) {
            return false;
        }
        return exactMass1.doubleValue() == exactMass2.doubleValue();
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DefaultChemObjectBuilder.getInstance();
    }
}

