/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.HOSECodeGenerator;
import org.openscience.cdk.tools.LonePairElectronChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.IPAtomicHOSEDescriptorTest")
public class IPAtomicHOSEDescriptor
extends AbstractAtomicDescriptor {
    private static final String[] descriptorNames = new String[]{"ipAtomicHOSE"};
    int maxSpheresToUse = 10;
    private IPdb db = new IPdb();

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#ionizationPotential", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return descriptorNames;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom atom, IAtomContainer container) {
        String originalAtomtypeName = atom.getAtomTypeName();
        Integer originalNeighborCount = atom.getFormalNeighbourCount();
        Integer originalValency = atom.getValency();
        Double originalBondOrderSum = atom.getBondOrderSum();
        IBond.Order originalMaxBondOrder = atom.getMaxBondOrder();
        IAtomType.Hybridization originalHybridization = atom.getHybridization();
        if (!this.isCachedAtomContainer(container)) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(container);
                LonePairElectronChecker lpcheck = new LonePairElectronChecker();
                lpcheck.saturate(container);
            }
            catch (CDKException e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), descriptorNames, e);
            }
        }
        double value = this.db.extractIP(container, atom);
        atom.setAtomTypeName(originalAtomtypeName);
        atom.setFormalNeighbourCount(originalNeighborCount);
        atom.setValency(originalValency);
        atom.setHybridization(originalHybridization);
        atom.setMaxBondOrder(originalMaxBondOrder);
        atom.setBondOrderSum(originalBondOrderSum);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(value), descriptorNames);
    }

    private boolean familyHalogen(IAtom atom) {
        String symbol = atom.getSymbol();
        return symbol.equals("F") || symbol.equals("Cl") || symbol.equals("Br") || symbol.equals("I");
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }

    private static List<String> extractInfo(String str) {
        StringBuffer idEdited = new StringBuffer();
        StringBuffer valEdited = new StringBuffer();
        int strlen = str.length();
        boolean foundSpace = false;
        boolean countSpace = false;
        boolean foundDigit = false;
        for (int i = 0; i < strlen; ++i) {
            if (!foundDigit && Character.isLetter(str.charAt(i))) {
                foundDigit = true;
            }
            if (!foundDigit) continue;
            if (Character.isWhitespace(str.charAt(i))) {
                if (countSpace) break;
                foundSpace = true;
                continue;
            }
            if (foundSpace) {
                valEdited.append(str.charAt(i));
                continue;
            }
            idEdited.append(str.charAt(i));
        }
        ArrayList<String> objec = new ArrayList<String>();
        objec.add(idEdited.toString());
        objec.add(valEdited.toString());
        return objec;
    }

    private class IPdb {
        HashMap<String, HashMap<String, Double>> listGroup = new HashMap();
        HashMap<String, HashMap<String, Double>> listGroupS = new HashMap();

        public double extractIP(IAtomContainer container, IAtom atom) {
            String name = "";
            String nameS = "";
            HashMap<Object, Object> hoseVSenergy = new HashMap();
            HashMap<Object, Object> hoseVSenergyS = new HashMap();
            if (IPAtomicHOSEDescriptor.this.familyHalogen(atom)) {
                name = "X_IP_HOSE.db";
                nameS = "X_IP_HOSE_S.db";
                if (this.listGroup.containsKey(name)) {
                    hoseVSenergy = this.listGroup.get(name);
                    hoseVSenergyS = this.listGroupS.get(nameS);
                } else {
                    String path = "org/openscience/cdk/qsar/descriptors/atomic/data/" + name;
                    String pathS = "org/openscience/cdk/qsar/descriptors/atomic/data/" + nameS;
                    InputStream ins = this.getClass().getClassLoader().getResourceAsStream(path);
                    BufferedReader insr = new BufferedReader(new InputStreamReader(ins));
                    hoseVSenergy = this.extractAttributes(insr);
                    ins = this.getClass().getClassLoader().getResourceAsStream(pathS);
                    insr = new BufferedReader(new InputStreamReader(ins));
                    hoseVSenergyS = this.extractAttributes(insr);
                }
            } else {
                return 0.0;
            }
            try {
                HOSECodeGenerator hcg = new HOSECodeGenerator();
                int exactSphere = 0;
                String hoseCode = "";
                for (int spheres = IPAtomicHOSEDescriptor.this.maxSpheresToUse; spheres > 0; --spheres) {
                    hcg.getSpheres(container, atom, spheres, true);
                    List<IAtom> atoms = hcg.getNodesInSphere(spheres);
                    if (atoms.size() == 0) continue;
                    exactSphere = spheres;
                    hoseCode = hcg.getHOSECode(container, atom, spheres, true);
                    if (hoseVSenergy.containsKey(hoseCode)) {
                        return (Double)hoseVSenergy.get(hoseCode);
                    }
                    if (!hoseVSenergyS.containsKey(hoseCode)) break;
                    return (Double)hoseVSenergyS.get(hoseCode);
                }
                for (int i = 0; i < 3; ++i) {
                    for (int plusMinus = 0; plusMinus < 2; ++plusMinus) {
                        int sign = -1;
                        if (plusMinus == 1) {
                            sign = 1;
                        }
                        StringTokenizer st = new StringTokenizer(hoseCode, "()/");
                        StringBuffer hoseCodeBuffer = new StringBuffer();
                        int sum = exactSphere + sign * (i + 1);
                        for (int k = 0; k < sum; ++k) {
                            if (st.hasMoreTokens()) {
                                String partcode = st.nextToken();
                                hoseCodeBuffer.append(partcode);
                            }
                            if (k == 0) {
                                hoseCodeBuffer.append("(");
                                continue;
                            }
                            if (k == 3) {
                                hoseCodeBuffer.append(")");
                                continue;
                            }
                            hoseCodeBuffer.append("/");
                        }
                        String hoseCodeBU = hoseCodeBuffer.toString();
                        if (!hoseVSenergyS.containsKey(hoseCodeBU)) continue;
                        return (Double)hoseVSenergyS.get(hoseCodeBU);
                    }
                }
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
            return 0.0;
        }

        private HashMap<String, Double> extractAttributes(BufferedReader input) {
            HashMap<String, Double> hoseVSenergy = new HashMap<String, Double>();
            try {
                String line;
                while ((line = input.readLine()) != null) {
                    List values;
                    if (line.startsWith("#") || ((String)(values = IPAtomicHOSEDescriptor.extractInfo(line)).get(1)).equals("")) continue;
                    hoseVSenergy.put((String)values.get(0), Double.valueOf((String)values.get(1)));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return hoseVSenergy;
        }
    }
}

