/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractCrystal;
import org.xmlcml.cml.element.CMLCellParameter;
import org.xmlcml.cml.element.CMLLattice;
import org.xmlcml.cml.element.CMLLatticeVector;
import org.xmlcml.cml.element.CMLScalar;
import org.xmlcml.cml.element.CMLSymmetry;
import org.xmlcml.cml.element.CMLTransform3;
import org.xmlcml.cml.element.CMLVector3;
import org.xmlcml.euclid.RealSquareMatrix;
import org.xmlcml.euclid.Transform3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLCrystal
extends AbstractCrystal {
    public static final String NS = "cml:crystal";
    public static final String A = "cml:a";
    public static final String B = "cml:b";
    public static final String C = "cml:c";
    public static final String ALPHA = "cml:alpha";
    public static final String BETA = "cml:beta";
    public static final String GAMMA = "cml:gamma";
    public static final String Z2OP = "cml:z2op";

    public CMLCrystal() {
    }

    public CMLCrystal(CMLCrystal old) {
        super(old);
    }

    @Override
    public Node copy() {
        return new CMLCrystal(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLCrystal();
    }

    public CMLCrystal(CMLLattice lattice) {
        this(lattice.getCellParameters());
    }

    public CMLCrystal(double[] params) throws RuntimeException {
        this(CMLCrystal.createScalars(params, null));
    }

    public CMLCrystal(CMLScalar[] scalars) {
        this();
        if (scalars == null || scalars.length != 6) {
            throw new RuntimeException("scalar must be of length 6");
        }
        for (CMLScalar scalar : scalars) {
            this.appendChild(scalar);
        }
    }

    public Transform3 getOrthogonalizationTransform() {
        Transform3 t = null;
        try {
            t = new Transform3(this.getOrthogonalizationMatrix());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("BUG " + e);
        }
        return t;
    }

    public RealSquareMatrix getOrthogonalizationMatrix() {
        double[] param = this.getCellParameterValues();
        RealSquareMatrix orthMat = new RealSquareMatrix(3);
        double dtor = Math.PI / 180;
        double sina = Math.sin(dtor * param[3]);
        double cosa = Math.cos(dtor * param[3]);
        double sinb = Math.sin(dtor * param[4]);
        double cosb = Math.cos(dtor * param[4]);
        double cosg = Math.cos(dtor * param[5]);
        double cosgstar = (cosa * cosb - cosg) / (sina * sinb);
        double singstar = Math.sqrt(1.0 - cosgstar * cosgstar);
        double[][] flmat = orthMat.getMatrix();
        flmat[0][0] = param[0] * sinb * singstar;
        flmat[0][1] = 0.0;
        flmat[0][2] = 0.0;
        flmat[1][0] = -1.0 * param[0] * sinb * cosgstar;
        flmat[1][1] = param[1] * sina;
        flmat[1][2] = 0.0;
        flmat[2][0] = param[0] * cosb;
        flmat[2][1] = param[1] * cosa;
        flmat[2][2] = param[2];
        return orthMat;
    }

    public void setCellParameters(double a, double b, double c, double alpha, double beta, double gamma) {
        double[] temp = new double[]{a, b, c, alpha, beta, gamma};
        this.setCellParameters(temp, null);
    }

    public void setCellParameters(double[] params) {
        this.setCellParameters(params, null);
    }

    public void setCellParameters(double[] params, double[] error) {
        if (params == null || params.length != 6) {
            throw new RuntimeException("Must have 6 cell parameters");
        }
        Elements cellParamVector = this.getChildCMLElements("scalar");
        if (cellParamVector.size() == 0) {
            for (int i = 0; i < 6; ++i) {
                CMLScalar cellParam = CMLCrystal.createScalar(CRYSTAL_DICT_REFS[i], params[i], CRYSTAL_DICT_UNITS[i], Double.NaN);
                this.addScalar(cellParam);
            }
        } else if (cellParamVector.size() == 6) {
            for (int i = 0; i < 6; ++i) {
                CMLScalar cellParam = (CMLScalar)cellParamVector.get(i);
                cellParam.setValue(params[i]);
                if (error != null) {
                    cellParam.setErrorValue(error[i]);
                }
                cellParam.setDictRef(CRYSTAL_DICT_REFS[i]);
            }
        } else {
            throw new RuntimeException("Corrupted cell parameters: must be exactly 6 (found: " + cellParamVector.size() + ")");
        }
    }

    public List<CMLScalar> getCellScalars() throws RuntimeException {
        ArrayList<CMLScalar> cellScalars = new ArrayList();
        Nodes cellScalarNodes = this.query("cml:scalar[@dictRef]", CMLConstants.CML_XPATH);
        int cellScalarCount = cellScalarNodes.size();
        if (cellScalarCount != 6) {
            throw new RuntimeException("Bad number of cell scalars: " + cellScalarCount);
        }
        CMLElements<CMLCellParameter> cellParameterElements = this.getCellParameterElements();
        if (cellParameterElements != null && cellParameterElements.size() == 2) {
            cellScalars = CMLCellParameter.createCMLScalars(cellParameterElements);
        } else if (cellScalarNodes != null && cellScalarNodes.size() == 6) {
            for (int i = 0; i < 6; ++i) {
                cellScalars.add(new CMLScalar((CMLScalar)cellScalarNodes.get(i)));
            }
        } else if (cellScalarNodes == null || cellParameterElements != null) {
            this.debug("CELLPAR");
            throw new RuntimeException("Bad number of cell parameter children: " + cellScalarNodes.size());
        }
        return cellScalars;
    }

    public List<CMLCellParameter> createCellParameterElements() throws RuntimeException {
        CMLElements<CMLScalar> cellScalarElements = this.getScalarElements();
        CMLElements<CMLCellParameter> cellParameterElements = this.getCellParameterElements();
        ArrayList<CMLCellParameter> cellParameterList = new ArrayList<CMLCellParameter>();
        if (cellParameterElements != null && cellParameterElements.size() == 2) {
            CMLCellParameter length = CMLCellParameter.getCellParameter(cellParameterElements, CMLCellParameter.Type.LENGTH);
            CMLCellParameter angle = CMLCellParameter.getCellParameter(cellParameterElements, CMLCellParameter.Type.ANGLE);
            if (length != null && angle != null) {
                cellParameterList.add(length);
                cellParameterList.add(angle);
            }
        } else if (cellScalarElements != null && cellScalarElements.size() == 6) {
            ArrayList<CMLScalar> lengthParams = new ArrayList<CMLScalar>();
            for (int i = 0; i < 3; ++i) {
                lengthParams.add(new CMLScalar(cellScalarElements.get(i)));
            }
            ArrayList<CMLScalar> angleParams = new ArrayList<CMLScalar>();
            for (int i = 3; i < 6; ++i) {
                angleParams.add(new CMLScalar(cellScalarElements.get(i)));
            }
            cellParameterList.add(new CMLCellParameter(lengthParams, CMLCellParameter.Type.LENGTH));
            cellParameterList.add(new CMLCellParameter(angleParams, CMLCellParameter.Type.ANGLE));
        } else {
            if (cellScalarElements.size() > 0) {
                throw new RuntimeException("Bad number of cell parameter children: " + cellScalarElements.size());
            }
            throw new RuntimeException("no cell params");
        }
        return cellParameterList;
    }

    public double[] getCellParameterValues() {
        List<CMLScalar> paramElements = this.getCellScalars();
        double[] temp = new double[6];
        if (paramElements == null) {
            return null;
        }
        for (int i = 0; i < 6; ++i) {
            temp[i] = new Double(paramElements.get(i).getXMLContent());
        }
        return temp;
    }

    public CMLLattice getLattice() {
        RealSquareMatrix matrix = this.getOrthogonalizationMatrix();
        double[][] flmat = matrix.getMatrix();
        CMLLattice lattice = new CMLLattice();
        double[] v = new double[]{flmat[0][0], flmat[1][0], flmat[2][0]};
        CMLLatticeVector aVector = new CMLLatticeVector(v);
        lattice.addLatticeVector(aVector);
        v[0] = flmat[0][1];
        v[1] = flmat[1][1];
        v[2] = flmat[2][1];
        CMLLatticeVector bVector = new CMLLatticeVector(v);
        lattice.addLatticeVector(bVector);
        v[0] = flmat[0][2];
        v[1] = flmat[1][2];
        v[2] = flmat[2][2];
        CMLLatticeVector cVector = new CMLLatticeVector(v);
        lattice.addLatticeVector(cVector);
        return lattice;
    }

    public double getCellVolume() {
        double[] param = this.getCellParameterValues();
        double dtor = Math.PI / 180;
        double cosa = Math.cos(dtor * param[3]);
        double cosb = Math.cos(dtor * param[4]);
        double cosg = Math.cos(dtor * param[5]);
        double vol = param[0] * param[1] * param[2] * Math.sqrt(1.0 - cosa * cosa - cosb * cosb - cosg * cosg + 2.0 * cosa * cosb * cosg);
        return vol;
    }

    public double getCellVolume1() {
        CMLLattice lattice = this.getLattice();
        CMLVector3 a = lattice.getLatticeVectorElements().get(0).getCMLVector3();
        CMLVector3 b = lattice.getLatticeVectorElements().get(1).getCMLVector3();
        CMLVector3 c = lattice.getLatticeVectorElements().get(2).getCMLVector3();
        return a.getScalarTripleProduct(b, c);
    }

    public double getCellVolume2() {
        RealSquareMatrix orthMat = this.getOrthogonalizationMatrix();
        return orthMat.determinant();
    }

    public double getReciprocalCellVolume() {
        return 1.0 / this.getCellVolume();
    }

    public CMLCrystal getReciprocalCell() {
        CMLLattice reciprocalLattice = this.getReciprocalLattice();
        CMLCrystal crystal = new CMLCrystal(reciprocalLattice);
        return crystal;
    }

    public CMLLattice getReciprocalLattice() {
        CMLLattice lattice = this.getLattice();
        CMLVector3 a = lattice.getLatticeVectorElements().get(0).getCMLVector3();
        CMLVector3 b = lattice.getLatticeVectorElements().get(1).getCMLVector3();
        CMLVector3 c = lattice.getLatticeVectorElements().get(2).getCMLVector3();
        double recipvol = 1.0 / a.getScalarTripleProduct(b, c);
        CMLVector3 astar = b.getCrossProduct(c).multiplyBy(recipvol);
        CMLLatticeVector astarVect = new CMLLatticeVector(astar);
        CMLVector3 bstar = c.getCrossProduct(a).multiplyBy(recipvol);
        CMLLatticeVector bstarVect = new CMLLatticeVector(bstar);
        CMLVector3 cstar = a.getCrossProduct(b).multiplyBy(recipvol);
        CMLLatticeVector cstarVect = new CMLLatticeVector(cstar);
        return new CMLLattice(astarVect, bstarVect, cstarVect);
    }

    private static CMLScalar[] createScalars(double[] params, double[] error) throws RuntimeException {
        if (params == null || params.length != 6) {
            throw new RuntimeException("params must be of length 6");
        }
        CMLScalar[] scalar = new CMLScalar[6];
        for (int i = 0; i < 6; ++i) {
            double err = error == null ? Double.NaN : error[i];
            scalar[i] = CMLCrystal.createScalar(CRYSTAL_DICT_REFS[i], params[i], CRYSTAL_DICT_UNITS[i], err);
        }
        return scalar;
    }

    public static CMLScalar createScalar(String dictRef, double param, String unitRef) {
        return CMLCrystal.createScalar(dictRef, param, unitRef, Double.NaN);
    }

    public static CMLScalar createScalar(String dictRef, double param, String unitRef, double error) {
        CMLScalar scalar = new CMLScalar(param);
        scalar.setDictRef(dictRef);
        if (unitRef != null) {
            scalar.setUnits(unitRef);
        }
        if (!Double.isNaN(error)) {
            scalar.setErrorValue(error);
        }
        return scalar;
    }

    public CMLLattice getPrimitiveLattice() {
        CMLElements<CMLSymmetry> symmetry = this.getSymmetryElements();
        Centering centering = symmetry.size() == 0 ? Centering.P : symmetry.get(0).getCentering();
        return this.getPrimitiveLattice(centering);
    }

    public CMLLattice getPrimitiveLattice(Centering centering) {
        CMLLattice lattice = this.getLattice();
        CMLLatticeVector[] latticeVectors = new CMLLatticeVector[3];
        if (centering.equals((Object)Centering.P) || centering.equals((Object)Centering.UNKNOWN)) {
            int i = 0;
            for (CMLLatticeVector lv : lattice.getLatticeVectorElements()) {
                latticeVectors[i++] = new CMLLatticeVector(lv);
            }
        } else if (centering.equals((Object)Centering.A)) {
            latticeVectors[0] = new CMLLatticeVector(lattice.getCMLVector3(0));
            CMLVector3 bPlusC = lattice.getCMLVector3(1).plus(lattice.getCMLVector3(2));
            latticeVectors[1] = new CMLLatticeVector(bPlusC.multiplyBy(0.5));
            CMLVector3 bMinusC = lattice.getCMLVector3(1).subtract(lattice.getCMLVector3(2));
            latticeVectors[2] = new CMLLatticeVector(bMinusC.multiplyBy(0.5));
        } else if (centering.equals((Object)Centering.B)) {
            CMLVector3 aPlusC = lattice.getCMLVector3(0).plus(lattice.getCMLVector3(2));
            latticeVectors[0] = new CMLLatticeVector(aPlusC.multiplyBy(0.5));
            CMLVector3 aMinusC = lattice.getCMLVector3(0).subtract(lattice.getCMLVector3(2));
            latticeVectors[1] = new CMLLatticeVector(lattice.getCMLVector3(1));
            latticeVectors[2] = new CMLLatticeVector(aMinusC.multiplyBy(0.5));
        } else if (centering.equals((Object)Centering.C)) {
            CMLVector3 aPlusB = lattice.getCMLVector3(0).plus(lattice.getCMLVector3(1));
            latticeVectors[0] = new CMLLatticeVector(aPlusB.multiplyBy(0.5));
            CMLVector3 aMinusB = lattice.getCMLVector3(0).subtract(lattice.getCMLVector3(1));
            latticeVectors[1] = new CMLLatticeVector(aMinusB.multiplyBy(0.5));
            latticeVectors[2] = new CMLLatticeVector(lattice.getCMLVector3(2));
        } else if (centering.equals((Object)Centering.I)) {
            latticeVectors[0] = new CMLLatticeVector(lattice.getCMLVector3(0));
            CMLVector3 aPlusBplusC = lattice.getCMLVector3(0).plus(lattice.getCMLVector3(1)).plus(lattice.getCMLVector3(2));
            latticeVectors[1] = new CMLLatticeVector(aPlusBplusC.multiplyBy(0.5));
            CMLVector3 aPlusBminusC = lattice.getCMLVector3(0).plus(lattice.getCMLVector3(1)).subtract(lattice.getCMLVector3(2));
            latticeVectors[2] = new CMLLatticeVector(aPlusBminusC.multiplyBy(0.5));
        } else if (centering.equals((Object)Centering.F)) {
            CMLVector3 bPlusC = lattice.getCMLVector3(1).plus(lattice.getCMLVector3(2));
            latticeVectors[0] = new CMLLatticeVector(bPlusC.multiplyBy(0.5));
            CMLVector3 cPlusA = lattice.getCMLVector3(2).plus(lattice.getCMLVector3(0));
            latticeVectors[1] = new CMLLatticeVector(cPlusA.multiplyBy(0.5));
            CMLVector3 aPlusB = lattice.getCMLVector3(0).plus(lattice.getCMLVector3(1));
            latticeVectors[2] = new CMLLatticeVector(aPlusB.multiplyBy(0.5));
        } else if (centering.equals((Object)Centering.R)) {
            throw new RuntimeException("R not implemented");
        }
        CMLLattice primitiveLattice = new CMLLattice(latticeVectors);
        return primitiveLattice;
    }

    public static CMLCrystal getContainedCrystal(CMLElement element) throws RuntimeException {
        Nodes crystalNodes = element.query(".//cml:crystal", CMLConstants.CML_XPATH);
        if (crystalNodes.size() == 0) {
            throw new RuntimeException("NO <crystal> FOUND");
        }
        if (crystalNodes.size() > 1) {
            throw new RuntimeException("TOO MANY <crystal> FOUND " + crystalNodes.size());
        }
        return (CMLCrystal)crystalNodes.get(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Centering {
        P("P", "primitive", new String[0]),
        I("I", "body-centered", new String[]{"1/2+x, 1/2+y, 1/2+z"}),
        R("R", "rhomohedral", new String[]{"1/3+x, 2/3+y, 2/3+z", "2/3+x, 1/3+y, 1/3+z"}),
        F("F", "face-centered", new String[]{"x, 1/2+y, 1/2+z", "1/2+x, y, 1/2+z", "1/2+x, 1/2+y, z"}),
        A("A", "A-centered", new String[]{"x, 1/2+y, 1/2+z"}),
        B("B", "B-centered", new String[]{"1/2+x, y, 1/2+z"}),
        C("C", "C-centered", new String[]{"1/2+x, 1/2+y, z"}),
        UNKNOWN("?", "unknown", new String[0]);

        String symbol;
        String desc;
        List<CMLTransform3> translations;

        private Centering(String symbol, String description, String[] operators) {
            this.symbol = symbol;
            this.desc = description;
            this.translations = new ArrayList<CMLTransform3>();
            for (String operator : operators) {
                try {
                    this.translations.add(new CMLTransform3(operator));
                }
                catch (Exception e) {
                    throw new RuntimeException("bug " + e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Bravais {
        TRICLINIC("triclinic"),
        MONOCLINIC("monoclinic"),
        ORTHORHOMBIC("orthorhombic"),
        TETRAGONAL("tetragonal"),
        TRIGONAL("trigonal"),
        HEXAGONAL("hexagonal"),
        CUBIC("cubic"),
        UNKNOWN("unknown");

        String desc;

        private Bravais(String description) {
            this.desc = description;
        }
    }
}

