/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.apache.log4j.Logger;
import org.xmlcml.euclid.ArrayBase;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Int;
import org.xmlcml.euclid.IntRange;
import org.xmlcml.euclid.IntSet;

public class IntArray
extends ArrayBase {
    static final Logger logger = Logger.getLogger((String)IntArray.class.getName());
    private int maxelem = 10000;
    int nelem;
    int[] array;
    int bufsize = 5;
    static final int CUTOFF = 16;
    private static final int XXCUTOFF = 16;

    public IntArray() {
        this.nelem = 0;
        this.bufsize = 5;
        this.array = new int[this.bufsize];
    }

    private boolean checkSize(int n) {
        if (n < 0) {
            n = 0;
            return false;
        }
        this.nelem = n;
        if (this.nelem > this.maxelem) {
            this.maxelem = this.nelem;
        }
        if (this.bufsize < this.nelem) {
            this.bufsize = this.nelem;
        }
        return true;
    }

    private void makeSpace(int newCount) {
        if (newCount > this.bufsize) {
            while (newCount > this.bufsize) {
                this.bufsize *= 2;
            }
            int[] array1 = new int[this.bufsize];
            System.arraycopy(this.array, 0, array1, 0, this.nelem);
            this.array = array1;
        }
    }

    public IntArray(int n) {
        this(n, 0);
    }

    public IntArray(int n, int elem1, int delta) {
        if (!this.checkSize(n)) {
            return;
        }
        this.array = new int[n];
        this.bufsize = n;
        int ff = elem1;
        for (int i = 0; i < n; ++i) {
            this.array[i] = ff;
            ff += delta;
        }
    }

    public IntArray(int n, int elem1) {
        if (!this.checkSize(n)) {
            return;
        }
        this.array = new int[n];
        this.bufsize = n;
        for (int i = 0; i < n; ++i) {
            this.array[i] = elem1;
        }
    }

    public IntArray(int n, int[] arr) throws EuclidRuntimeException {
        if (!this.checkSize(n)) {
            throw new EuclidRuntimeException("Cannot have negative array length");
        }
        if (n > arr.length) {
            throw new EuclidRuntimeException("Array would overflow");
        }
        this.array = new int[n];
        this.bufsize = n;
        System.arraycopy(arr, 0, this.array, 0, n);
    }

    public IntArray(int[] arr) {
        this.nelem = arr.length;
        this.array = new int[this.nelem];
        this.bufsize = this.nelem;
        System.arraycopy(arr, 0, this.array, 0, this.nelem);
    }

    public IntArray(IntArray m, int low, int high) throws EuclidRuntimeException {
        if (low < 0 || low > high || high >= m.size()) {
            throw new EuclidRuntimeException("index out of range: " + low + "/" + high);
        }
        this.nelem = high - low + 1;
        this.checkSize(this.nelem);
        this.array = new int[this.nelem];
        this.bufsize = this.nelem;
        System.arraycopy(m.array, low, this.array, 0, this.nelem);
    }

    public IntArray(IntArray ref, IntArray sub) throws EuclidRuntimeException {
        this(sub.size());
        for (int i = 0; i < sub.size(); ++i) {
            int j = sub.elementAt(i);
            if (j < 0 || j >= ref.size()) {
                throw new EuclidRuntimeException();
            }
            this.setElementAt(i, ref.elementAt(j));
        }
    }

    public Object clone() {
        IntArray temp = new IntArray(this.nelem);
        temp.nelem = this.nelem;
        temp.maxelem = this.maxelem;
        System.arraycopy(this.array, 0, temp.array, 0, this.nelem);
        temp.bufsize = this.nelem;
        return temp;
    }

    public IntArray(IntArray m) {
        this.shallowCopy(m);
        System.arraycopy(m.array, 0, this.array, 0, this.nelem);
    }

    public IntArray(int nn, String shape, int maxval) {
        if (shape.toUpperCase().equals("TRIANGLE")) {
            this.nelem = nn * 2 - 1;
            if (!this.checkSize(this.nelem)) {
                return;
            }
            this.array = new int[this.nelem];
            int delta = maxval / nn;
            for (int i = 0; i < nn; ++i) {
                this.array[i] = (i + 1) * delta;
                this.array[this.nelem - i - 1] = this.array[i];
            }
        } else if (shape.toUpperCase().equals("ZIGZAG")) {
            this.nelem = nn * 4 - 1;
            if (!this.checkSize(this.nelem)) {
                return;
            }
            this.array = new int[this.nelem];
            int delta = maxval / nn;
            for (int i = 0; i < nn; ++i) {
                this.array[i] = (i + 1) * delta;
                this.array[2 * nn - i - 2] = this.array[i];
                this.array[2 * nn + i] = -this.array[i];
                this.array[this.nelem - i - 1] = -this.array[i];
            }
            this.array[2 * nn - 1] = 0;
        }
    }

    public IntArray(String[] strings) throws NumberFormatException {
        this(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            this.array[i] = Integer.valueOf(strings[i]);
        }
    }

    public IntArray(String string) throws NumberFormatException {
        this(string.split("\\s+"));
    }

    public void contractArray() {
        int[] array1 = new int[this.nelem];
        System.arraycopy(this.array, 0, array1, 0, this.nelem);
        this.array = array1;
    }

    public void shallowCopy(IntArray m) {
        this.nelem = m.nelem;
        this.bufsize = m.bufsize;
        this.maxelem = m.maxelem;
        this.array = m.array;
    }

    public int elementAt(int elem) throws ArrayIndexOutOfBoundsException {
        return this.array[elem];
    }

    public int size() {
        return this.nelem;
    }

    public int[] getArray() {
        if (this.nelem != this.array.length) {
            int[] temp = new int[this.nelem];
            System.arraycopy(this.array, 0, temp, 0, this.nelem);
            this.array = temp;
        }
        return this.array;
    }

    public boolean equals(IntArray f) {
        boolean equal = false;
        try {
            this.checkConformable(f);
            equal = true;
            for (int i = 0; i < this.nelem; ++i) {
                if (this.array[i] == f.array[i]) continue;
                equal = false;
                break;
            }
        }
        catch (Exception e) {
            equal = false;
        }
        return equal;
    }

    public void clearArray() {
        for (int i = 0; i < this.size(); ++i) {
            this.array[i] = 0;
        }
    }

    public int[] getReverseArray() {
        int count = this.size();
        int[] temp = new int[count];
        for (int i = 0; i < this.size(); ++i) {
            temp[i] = this.array[--count];
        }
        return temp;
    }

    private void checkConformable(IntArray m) throws EuclidRuntimeException {
        if (this.nelem != m.nelem) {
            throw new EuclidRuntimeException();
        }
    }

    public boolean isEqualTo(IntArray f) {
        boolean equal = false;
        try {
            this.checkConformable(f);
            equal = true;
            for (int i = 0; i < this.nelem; ++i) {
                if (this.array[i] == f.array[i]) continue;
                equal = false;
                break;
            }
        }
        catch (Exception e) {
            equal = false;
        }
        return equal;
    }

    public IntArray plus(IntArray f) throws EuclidRuntimeException {
        this.checkConformable(f);
        IntArray m = (IntArray)this.clone();
        for (int i = 0; i < this.nelem; ++i) {
            m.array[i] = f.array[i] + this.array[i];
        }
        return m;
    }

    public IntArray subtract(IntArray f) throws EuclidRuntimeException {
        this.checkConformable(f);
        IntArray m = (IntArray)this.clone();
        for (int i = 0; i < this.nelem; ++i) {
            m.array[i] = this.array[i] - f.array[i];
        }
        return m;
    }

    public void subtractEquals(IntArray f) throws EuclidRuntimeException {
        this.checkConformable(f);
        for (int i = 0; i < this.nelem; ++i) {
            int n = i;
            this.array[n] = this.array[n] - f.array[i];
        }
    }

    public void negative() {
        for (int i = 0; i < this.size(); ++i) {
            this.array[i] = -this.array[i];
        }
    }

    public IntArray multiplyBy(int f) {
        IntArray m = (IntArray)this.clone();
        int i = 0;
        while (i < this.nelem) {
            int n = i++;
            m.array[n] = m.array[n] * f;
        }
        return m;
    }

    public void setElementAt(int elem, int f) throws ArrayIndexOutOfBoundsException {
        this.array[elem] = f;
    }

    public IntArray getSubArray(int start, int end) {
        int nel = end - start + 1;
        IntArray f = new IntArray(nel, 0);
        System.arraycopy(this.array, start, f.array, 0, nel);
        return f;
    }

    public void setElements(int start, int[] a) {
        if (start < 0 || start + a.length > this.nelem) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(a, 0, this.array, start, a.length);
    }

    public boolean isClear() {
        for (int i = 0; i < this.nelem; ++i) {
            if (this.array[i] == 0) continue;
            return false;
        }
        return true;
    }

    public void setAllElements(int f) {
        Int.initArray(this.nelem, this.array, f);
    }

    public int sumAllElements() {
        int sum = 0;
        for (int i = 0; i < this.nelem; ++i) {
            sum += this.array[i];
        }
        return sum;
    }

    public int absSumAllElements() {
        int sum = 0;
        for (int i = 0; i < this.nelem; ++i) {
            sum += Math.abs(this.array[i]);
        }
        return sum;
    }

    public int innerProduct() {
        int result = Integer.MIN_VALUE;
        try {
            result = this.dotProduct(this);
        }
        catch (EuclidRuntimeException x) {
            throw new EuclidRuntimeException("bug " + x);
        }
        return result;
    }

    public int dotProduct(IntArray f) throws EuclidRuntimeException {
        this.checkConformable(f);
        int sum = 0;
        for (int i = 0; i < this.nelem; ++i) {
            sum += this.array[i] * f.array[i];
        }
        return sum;
    }

    public IntArray cumulativeSum() {
        IntArray temp = new IntArray(this.nelem);
        int sum = 0;
        for (int i = 0; i < this.nelem; ++i) {
            temp.array[i] = sum += this.array[i];
        }
        return temp;
    }

    public IntArray applyFilter(IntArray filter) {
        int k;
        int l;
        int j;
        if (this.nelem == 0 || filter == null || filter.nelem <= 1) {
            return this;
        }
        int nfilter = filter.size();
        int midfilter = (nfilter - 1) / 2;
        IntArray temp = new IntArray(this.nelem);
        int wt = 0;
        int sum = 0;
        for (j = 0; j < midfilter; ++j) {
            wt = 0;
            sum = 0;
            l = 0;
            for (k = midfilter - j; k < nfilter; ++k) {
                wt += Math.abs(filter.array[k]);
                sum += filter.array[k] * this.array[l++];
            }
            temp.array[j] = sum / wt;
        }
        wt = filter.absSumAllElements();
        for (j = midfilter; j < this.nelem - midfilter; ++j) {
            sum = 0;
            l = j - midfilter;
            for (k = 0; k < nfilter; ++k) {
                sum += filter.array[k] * this.array[l++];
            }
            temp.array[j] = sum / wt;
        }
        for (j = this.nelem - midfilter; j < this.nelem; ++j) {
            wt = 0;
            sum = 0;
            l = j - midfilter;
            for (k = 0; k < midfilter + this.nelem - j; ++k) {
                wt += Math.abs(filter.array[k]);
                sum += filter.array[k] * this.array[l++];
            }
            temp.array[j] = sum / wt;
        }
        return temp;
    }

    public IntArray trim(ArrayBase.Trim flag, int limit) {
        IntArray temp = new IntArray(this.nelem);
        for (int i = 0; i < this.nelem; ++i) {
            int v = this.array[i];
            if (flag == ArrayBase.Trim.BELOW && v < limit || flag == ArrayBase.Trim.ABOVE && v > limit) {
                v = limit;
            }
            temp.array[i] = v;
        }
        return temp;
    }

    public int indexOfLargestElement() throws ArrayIndexOutOfBoundsException {
        if (this.nelem == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int index = -1;
        int value = Integer.MIN_VALUE;
        for (int i = 0; i < this.nelem; ++i) {
            if (this.array[i] <= value) continue;
            value = this.array[i];
            index = i;
        }
        return index;
    }

    public int indexOfSmallestElement() throws ArrayIndexOutOfBoundsException {
        if (this.nelem == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int index = -1;
        int value = Integer.MAX_VALUE;
        for (int i = 0; i < this.nelem; ++i) {
            if (this.array[i] >= value) continue;
            value = this.array[i];
            index = i;
        }
        return index;
    }

    public int largestElement() throws ArrayIndexOutOfBoundsException {
        return this.array[this.indexOfLargestElement()];
    }

    public int getMax() throws ArrayIndexOutOfBoundsException {
        return this.array[this.indexOfLargestElement()];
    }

    public int smallestElement() throws ArrayIndexOutOfBoundsException {
        return this.array[this.indexOfSmallestElement()];
    }

    public int getMin() throws ArrayIndexOutOfBoundsException {
        return this.array[this.indexOfSmallestElement()];
    }

    public IntRange getRange() throws ArrayIndexOutOfBoundsException {
        if (this.nelem == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        IntRange r = new IntRange();
        for (int i = 0; i < this.nelem; ++i) {
            r.add(this.array[i]);
        }
        return r;
    }

    public void deleteElement(int elem) throws ArrayIndexOutOfBoundsException {
        if (elem < 0 || elem >= this.nelem) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.nelem;
        if (this.bufsize > this.nelem * 2) {
            this.bufsize /= 2;
        }
        int[] temp = new int[this.bufsize];
        System.arraycopy(this.array, 0, temp, 0, elem);
        System.arraycopy(this.array, elem + 1, temp, elem, this.nelem - elem);
        this.array = temp;
    }

    public void deleteElements(int low, int high) throws ArrayIndexOutOfBoundsException {
        if (low < 0 || low > high || high >= this.nelem) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int ndeleted = high - low + 1;
        int[] temp = new int[this.nelem - ndeleted];
        System.arraycopy(this.array, 0, temp, 0, low);
        System.arraycopy(this.array, high + 1, temp, low, this.nelem - low - ndeleted);
        this.array = temp;
        this.nelem -= ndeleted;
        this.bufsize = this.nelem;
        int[] array = new int[this.nelem];
        System.arraycopy(temp, 0, array, 0, this.nelem);
    }

    public void insertElementAt(int elem, int f) throws ArrayIndexOutOfBoundsException {
        if (elem < 0 || elem > this.nelem) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] array1 = new int[this.nelem + 1];
        System.arraycopy(this.array, 0, array1, 0, elem);
        array1[elem] = f;
        System.arraycopy(this.array, elem, array1, elem + 1, this.nelem - elem);
        ++this.nelem;
        this.array = array1;
    }

    public void insertArray(int elem, IntArray f) throws ArrayIndexOutOfBoundsException {
        int n = f.size();
        if (elem < 0 || elem >= this.nelem || n < 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.nelem += n;
        int[] array1 = new int[this.nelem];
        System.arraycopy(this.array, 0, array1, 0, elem);
        System.arraycopy(f.getArray(), 0, array1, elem, n);
        System.arraycopy(this.array, elem, array1, n + elem, this.nelem - elem - n);
        this.array = array1;
    }

    public void addElement(int f) {
        this.makeSpace(this.nelem + 1);
        this.array[this.nelem++] = f;
    }

    public void addArray(IntArray f) {
        this.makeSpace(this.nelem + f.nelem);
        System.arraycopy(f.array, 0, this.array, this.nelem, f.nelem);
        this.nelem += f.nelem;
    }

    public IntArray getReorderedArray(IntSet idx) throws EuclidRuntimeException {
        IntArray temp = new IntArray(this.nelem);
        for (int i = 0; i < this.nelem; ++i) {
            int index = idx.elementAt(i);
            if (index > this.nelem) {
                throw new EuclidRuntimeException();
            }
            temp.array[i] = this.array[index];
        }
        return temp;
    }

    public IntSet inRange(IntRange r) {
        int n = this.size();
        IntSet temp = new IntSet();
        for (int i = 0; i < n; ++i) {
            if (!r.isValid() || !r.includes(this.array[i])) continue;
            temp.addElement(i);
        }
        return temp;
    }

    public IntSet outOfRange(IntRange r) {
        int n = this.size();
        IntSet temp = new IntSet();
        for (int i = 0; i < n; ++i) {
            if (!r.isValid() || r.includes(this.array[i])) continue;
            temp.addElement(i);
        }
        return temp;
    }

    public String[] getStringValues() {
        String[] temp = new String[this.nelem];
        for (int i = 0; i < this.nelem; ++i) {
            temp[i] = Integer.toString(this.array[i]);
        }
        return temp;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("(");
        for (int i = 0; i < this.nelem; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(this.array[i]);
        }
        s.append(")");
        return s.toString();
    }

    static int[] deleteElements(int[] f, int low, int hi) {
        int ndel;
        if (hi >= f.length) {
            hi = f.length - 1;
        }
        if (low < 0) {
            low = 0;
        }
        if ((ndel = hi - low + 1) <= 0) {
            return f;
        }
        int[] temp = new int[f.length - ndel];
        System.arraycopy(f, 0, temp, 0, low);
        System.arraycopy(f, hi + 1, temp, low, f.length - hi - 1);
        return temp;
    }

    static int[] copy(int[] f) {
        int[] temp = new int[f.length];
        System.arraycopy(f, 0, temp, 0, f.length);
        return temp;
    }

    void xfswap(int[] x, int a, int b) {
        int tmp = x[a];
        x[a] = x[b];
        x[b] = tmp;
    }

    private void inssort(int left, int right) {
        for (int i = left + 1; i <= right; ++i) {
            int v = this.array[i];
            int j = i;
            int k = j - 1;
            while (j > 0 && this.array[k] > v) {
                this.array[j] = this.array[k];
                --j;
                --k;
            }
            this.array[j] = v;
        }
    }

    private int partition(int left, int right) {
        int mid = (left + right) / 2;
        if (this.array[left] > this.array[mid]) {
            this.xfswap(this.array, left, mid);
        }
        if (this.array[left] > this.array[right]) {
            this.xfswap(this.array, left, right);
        }
        if (this.array[mid] > this.array[right]) {
            this.xfswap(this.array, mid, right);
        }
        int j = right - 1;
        this.xfswap(this.array, mid, j);
        int i = left;
        int v = this.array[j];
        while (true) {
            if (this.array[++i] < v) {
                continue;
            }
            while (this.array[--j] > v) {
            }
            this.xfswap(this.array, i, j);
            if (i >= j) break;
        }
        this.xfswap(this.array, j, i);
        this.xfswap(this.array, i, right - 1);
        return i;
    }

    private void iqsort(int left, int right) {
        while (right - left > 16) {
            int i = this.partition(left, right);
            if (i - left > right - i) {
                this.iqsort(i + 1, right);
                right = i - 1;
                continue;
            }
            this.iqsort(left, i - 1);
            left = i + 1;
        }
    }

    public void sortAscending() {
        if (this.nelem <= 0) {
            return;
        }
        this.iqsort(0, this.nelem - 1);
        this.inssort(0, this.nelem - 1);
    }

    public void sortDescending() {
        this.sortAscending();
        this.reverse();
    }

    public void reverse() {
        int i = 0;
        for (int j = this.nelem - 1; i < j; ++i, --j) {
            this.xfswap(this.array, i, j);
        }
    }

    public IntSet indexSortAscending() {
        if (this.nelem <= 0) {
            return new IntSet();
        }
        IntSet idx = new IntSet(this.nelem);
        IntArray iarray = new IntArray(idx.getElements());
        this.xxiqsort(iarray, this.array, 0, this.nelem - 1);
        this.xxinssort(iarray, this.array, 0, this.nelem - 1);
        try {
            idx = new IntSet(iarray.getArray());
        }
        catch (Exception e) {
            throw new EuclidRuntimeException(e.toString());
        }
        return idx;
    }

    public IntSet indexSortDescending() {
        IntSet idx = this.indexSortAscending();
        int[] temp = new IntArray(idx.getElements()).getReverseArray();
        try {
            idx = new IntSet(temp);
        }
        catch (Exception e) {
            throw new EuclidRuntimeException(e.toString());
        }
        return idx;
    }

    private void xxinssort(IntArray iarr, int[] pfl, int left, int right) {
        for (int i = left + 1; i <= right; ++i) {
            int v = iarr.elementAt(i);
            int j = i;
            int k = j - 1;
            while (j > 0 && pfl[iarr.elementAt(k)] > pfl[v]) {
                iarr.setElementAt(j, iarr.elementAt(k));
                --j;
                --k;
            }
            iarr.setElementAt(j, v);
        }
    }

    private int xxpartition(IntArray iarr, int[] pfl, int left, int right) {
        int mid = (left + right) / 2;
        if (pfl[iarr.elementAt(left)] > pfl[iarr.elementAt(mid)]) {
            this.xxfswap(iarr, left, mid);
        }
        if (pfl[iarr.elementAt(left)] > pfl[iarr.elementAt(right)]) {
            this.xxfswap(iarr, left, right);
        }
        if (pfl[iarr.elementAt(mid)] > pfl[iarr.elementAt(right)]) {
            this.xxfswap(iarr, mid, right);
        }
        int j = right - 1;
        this.xxfswap(iarr, mid, j);
        int i = left;
        int v = pfl[iarr.elementAt(j)];
        while (true) {
            if (pfl[iarr.elementAt(++i)] < v) {
                continue;
            }
            while (pfl[iarr.elementAt(--j)] > v) {
            }
            this.xxfswap(iarr, i, j);
            if (i >= j) break;
        }
        this.xxfswap(iarr, j, i);
        this.xxfswap(iarr, i, right - 1);
        return i;
    }

    private void xxiqsort(IntArray iarr, int[] pfl, int left, int right) {
        while (right - left > 16) {
            int i = this.xxpartition(iarr, pfl, left, right);
            if (i - left > right - i) {
                this.xxiqsort(iarr, pfl, i + 1, right);
                right = i - 1;
                continue;
            }
            this.xxiqsort(iarr, pfl, left, i - 1);
            left = i + 1;
        }
    }

    private void xxfswap(IntArray iarr, int a, int b) {
        int t = iarr.elementAt(a);
        iarr.setElementAt(a, iarr.elementAt(b));
        iarr.setElementAt(b, t);
    }

    public static boolean isIntArray(String s, String delimiterRegex) {
        boolean couldBeIntArray = true;
        String[] ss = s.split(delimiterRegex);
        try {
            new IntArray(ss);
        }
        catch (NumberFormatException e) {
            couldBeIntArray = false;
        }
        return couldBeIntArray;
    }
}

