/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.charges;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

@TestClass(value="org.openscience.cdk.charges.PolarizabilityTest")
public class Polarizability {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(Polarizability.class);

    private void addExplicitHydrogens(IAtomContainer container) {
        try {
            CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)container.getBuilder());
            for (IAtom atom : container.atoms()) {
                IAtomType type = matcher.findMatchingAtomType(container, atom);
                AtomTypeManipulator.configure((IAtom)atom, (IAtomType)type);
            }
            CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)container.getBuilder());
            hAdder.addImplicitHydrogens(container);
            AtomContainerManipulator.convertImplicitToExplicitHydrogens((IAtomContainer)container);
        }
        catch (Exception ex1) {
            logger.debug((Object)"Error in hydrogen addition");
        }
    }

    @TestMethod(value="testGetPolarizabilitiyFactorForAtom_IAtomContainer_IAtom")
    public double getPolarizabilitiyFactorForAtom(IAtomContainer atomContainer, IAtom atom) {
        IAtomContainer acH = (IAtomContainer)atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[]{atomContainer});
        this.addExplicitHydrogens(acH);
        return this.getKJPolarizabilityFactor(acH, atom);
    }

    @TestMethod(value="testCalculateKJMeanMolecularPolarizability")
    public double calculateKJMeanMolecularPolarizability(IAtomContainer atomContainer) {
        double polarizabilitiy = 0.0;
        IAtomContainer acH = (IAtomContainer)atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[]{atomContainer});
        this.addExplicitHydrogens(acH);
        for (int i = 0; i < acH.getAtomCount(); ++i) {
            polarizabilitiy += this.getKJPolarizabilityFactor(acH, acH.getAtom(i));
        }
        return polarizabilitiy;
    }

    @TestMethod(value="testCalculateGHEffectiveAtomPolarizability_IAtomContainer_IAtom_Int_Boolean")
    public double calculateGHEffectiveAtomPolarizability(IAtomContainer atomContainer, IAtom atom, int influenceSphereCutOff, boolean addExplicitH) {
        IAtomContainer acH;
        double polarizabilitiy = 0.0;
        if (addExplicitH) {
            acH = (IAtomContainer)atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[]{atomContainer});
            this.addExplicitHydrogens(acH);
        } else {
            acH = atomContainer;
        }
        ArrayList<IAtom> startAtom = new ArrayList<IAtom>(1);
        startAtom.add(0, atom);
        polarizabilitiy += this.getKJPolarizabilityFactor(acH, atom);
        for (int i = 0; i < acH.getAtomCount(); ++i) {
            if (acH.getAtom(i) == atom) continue;
            double bond = PathTools.breadthFirstTargetSearch((IAtomContainer)acH, startAtom, (IAtom)acH.getAtom(i), (int)0, (int)influenceSphereCutOff);
            if (bond == 1.0) {
                polarizabilitiy += this.getKJPolarizabilityFactor(acH, acH.getAtom(i));
                continue;
            }
            polarizabilitiy += Math.pow(0.5, bond - 1.0) * this.getKJPolarizabilityFactor(acH, acH.getAtom(i));
        }
        return polarizabilitiy;
    }

    @TestMethod(value="testCalculateGHEffectiveAtomPolarizability_IAtomContainer_IAtom_Boolean_IntInt")
    public double calculateGHEffectiveAtomPolarizability(IAtomContainer atomContainer, IAtom atom, boolean addExplicitH, int[][] distanceMatrix) {
        IAtomContainer acH;
        double polarizabilitiy = 0.0;
        if (addExplicitH) {
            acH = (IAtomContainer)atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[]{atomContainer});
            this.addExplicitHydrogens(acH);
        } else {
            acH = atomContainer;
        }
        ArrayList<IAtom> startAtom = new ArrayList<IAtom>(1);
        startAtom.add(0, atom);
        polarizabilitiy += this.getKJPolarizabilityFactor(acH, atom);
        for (int i = 0; i < acH.getAtomCount(); ++i) {
            if (acH.getAtom(i) == atom) continue;
            int atomIndex = atomContainer.getAtomNumber(atom);
            double bond = distanceMatrix[atomIndex][i];
            if (bond == 1.0) {
                polarizabilitiy += this.getKJPolarizabilityFactor(acH, acH.getAtom(i));
                continue;
            }
            polarizabilitiy += Math.pow(0.5, bond - 1.0) * this.getKJPolarizabilityFactor(acH, acH.getAtom(i));
        }
        return polarizabilitiy;
    }

    @TestMethod(value="testCalculateBondPolarizability_IAtomContainer_IBond")
    public double calculateBondPolarizability(IAtomContainer atomContainer, IBond bond) {
        double polarizabilitiy = 0.0;
        IAtomContainer acH = (IAtomContainer)atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[]{atomContainer});
        this.addExplicitHydrogens(acH);
        if (bond.getAtomCount() == 2) {
            polarizabilitiy += this.getKJPolarizabilityFactor(acH, bond.getAtom(0));
            polarizabilitiy += this.getKJPolarizabilityFactor(acH, bond.getAtom(1));
        }
        return polarizabilitiy / 2.0;
    }

    private double getKJPolarizabilityFactor(IAtomContainer atomContainer, IAtom atom) {
        double polarizabilitiyFactor = 0.0;
        String AtomSymbol = atom.getSymbol();
        if (AtomSymbol.equals("H")) {
            polarizabilitiyFactor = 0.387;
        } else if (AtomSymbol.equals("C")) {
            if (atom.getFlag(32)) {
                polarizabilitiyFactor = 1.23;
            } else if (atomContainer.getMaximumBondOrder(atom) == IBond.Order.SINGLE) {
                polarizabilitiyFactor = 1.064;
            } else if (atomContainer.getMaximumBondOrder(atom) == IBond.Order.DOUBLE) {
                polarizabilitiyFactor = this.getNumberOfHydrogen(atomContainer, atom) == 0 ? 1.382 : 1.37;
            } else if (atomContainer.getMaximumBondOrder(atom) == IBond.Order.TRIPLE || atomContainer.getMaximumBondOrder(atom) == IBond.Order.QUADRUPLE) {
                polarizabilitiyFactor = 1.279;
            }
        } else if (AtomSymbol.equals("N")) {
            polarizabilitiyFactor = atom.getCharge() != CDKConstants.UNSET && atom.getCharge() < 0.0 ? 1.09 : (atomContainer.getMaximumBondOrder(atom) == IBond.Order.SINGLE ? 1.094 : (atomContainer.getMaximumBondOrder(atom) == IBond.Order.DOUBLE ? 1.03 : 0.852));
        } else if (AtomSymbol.equals("O")) {
            if (atom.getCharge() != CDKConstants.UNSET && atom.getCharge() == -1.0) {
                polarizabilitiyFactor = 1.791;
            } else if (atom.getCharge() != CDKConstants.UNSET && atom.getCharge() == 1.0) {
                polarizabilitiyFactor = 0.422;
            } else if (atomContainer.getMaximumBondOrder(atom) == IBond.Order.SINGLE) {
                polarizabilitiyFactor = 0.664;
            } else if (atomContainer.getMaximumBondOrder(atom) == IBond.Order.DOUBLE) {
                polarizabilitiyFactor = 0.46;
            }
        } else if (AtomSymbol.equals("P")) {
            if (atomContainer.getConnectedBondsCount(atom) == 4 && atomContainer.getMaximumBondOrder(atom) == IBond.Order.DOUBLE) {
                polarizabilitiyFactor = 0.0;
            }
        } else if (AtomSymbol.equals("S")) {
            polarizabilitiyFactor = atom.getFlag(32) ? 3.38 : (atomContainer.getMaximumBondOrder(atom) == IBond.Order.SINGLE ? 3.2 : (atomContainer.getMaximumBondOrder(atom) == IBond.Order.DOUBLE ? (this.getNumberOfHydrogen(atomContainer, atom) == 0 ? 3.51 : 3.5) : 3.42));
        } else if (AtomSymbol.equals("F")) {
            polarizabilitiyFactor = 0.296;
        } else if (AtomSymbol.equals("Cl")) {
            polarizabilitiyFactor = 2.343;
        } else if (AtomSymbol.equals("Br")) {
            polarizabilitiyFactor = 3.5;
        } else if (AtomSymbol.equals("I")) {
            polarizabilitiyFactor = 5.79;
        }
        return polarizabilitiyFactor;
    }

    private int getNumberOfHydrogen(IAtomContainer atomContainer, IAtom atom) {
        List bonds = atomContainer.getConnectedBondsList(atom);
        int hCounter = 0;
        for (IBond bond : bonds) {
            IAtom connectedAtom = bond.getConnectedAtom(atom);
            if (!connectedAtom.getSymbol().equals("H")) continue;
            ++hCounter;
        }
        return hCounter;
    }
}

