/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.AtomImpl;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.Topology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ToSubsetAtoms
extends AbstractFunction<Graph, Graph> {
    ToSubsetAtoms() {
    }

    public Graph apply(Graph g) {
        Graph h = new Graph(g.order());
        for (int u = 0; u < g.order(); ++u) {
            Topology t = g.topologyOf(u);
            if (t.type() == Configuration.Type.None) {
                h.addAtom(ToSubsetAtoms.toSubset(g.atom(u), g, u));
                continue;
            }
            h.addAtom(g.atom(u));
            h.addTopology(t);
        }
        for (Edge e : g.edges()) {
            h.addEdge(e);
        }
        return h;
    }

    static Atom toSubset(Atom a, Graph g, int u) {
        if (a.subset()) {
            return a;
        }
        if (!a.element().organic()) {
            return a;
        }
        if (a.charge() != 0 || a.atomClass() != 0 || a.isotope() >= 0) {
            return a;
        }
        Atom subset = a.aromatic() ? AtomImpl.AromaticSubset.ofElement((Element)a.element()) : AtomImpl.AliphaticSubset.ofElement((Element)a.element());
        int impliedHCount = subset.hydrogens(g, u);
        return impliedHCount != a.hydrogens() ? a : subset;
    }
}

