/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.HBondAcceptorCountDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.HBondDonorCountDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.RotatableBondsCountDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.WeightDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.XLogPDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;

public class RuleOfFiveDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private boolean checkAromaticity = false;
    private static final String[] NAMES = new String[]{"LipinskiFailures"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#lipinskifailures", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("RuleOfFiveDescriptor expects one parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The first parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer mol) {
        mol = RuleOfFiveDescriptor.clone(mol);
        int lipinskifailures = 0;
        XLogPDescriptor xlogP = new XLogPDescriptor();
        Object[] xlogPparams = new Object[]{this.checkAromaticity, Boolean.TRUE};
        try {
            xlogP.setParameters(xlogPparams);
            double xlogPvalue = ((DoubleResult)xlogP.calculate(mol).getValue()).doubleValue();
            HBondAcceptorCountDescriptor acc = new HBondAcceptorCountDescriptor();
            Object[] hBondparams = new Object[]{this.checkAromaticity};
            acc.setParameters(hBondparams);
            int acceptors = ((IntegerResult)acc.calculate(mol).getValue()).intValue();
            HBondDonorCountDescriptor don = new HBondDonorCountDescriptor();
            don.setParameters(hBondparams);
            int donors = ((IntegerResult)don.calculate(mol).getValue()).intValue();
            WeightDescriptor mw = new WeightDescriptor();
            Object[] mwparams = new Object[]{"*"};
            mw.setParameters(mwparams);
            double mwvalue = ((DoubleResult)mw.calculate(mol).getValue()).doubleValue();
            RotatableBondsCountDescriptor rotata = new RotatableBondsCountDescriptor();
            Object[] rotatableBondsParams = new Object[]{false, true};
            rotata.setParameters(rotatableBondsParams);
            int rotatablebonds = ((IntegerResult)rotata.calculate(mol).getValue()).intValue();
            if (xlogPvalue > 5.0) {
                ++lipinskifailures;
            }
            if (acceptors > 10) {
                ++lipinskifailures;
            }
            if (donors > 5) {
                ++lipinskifailures;
            }
            if (mwvalue > 500.0) {
                ++lipinskifailures;
            }
            if ((double)rotatablebonds > 10.0) {
                ++lipinskifailures;
            }
        }
        catch (CDKException e) {
            new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), e);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(lipinskifailures), this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        return true;
    }
}

