/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.SingleElectron;
import org.openscience.cdk.exception.NoSuchAtomException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.tools.manipulator.SgroupManipulator;

public class AtomContainer
extends ChemObject
implements IAtomContainer,
IChemObjectListener,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 20;
    private static final long serialVersionUID = 5678100348445919254L;
    protected int atomCount;
    protected int bondCount;
    protected int lonePairCount;
    protected int singleElectronCount;
    protected final int growArraySize = 10;
    protected IAtom[] atoms;
    protected IBond[] bonds;
    protected ILonePair[] lonePairs;
    protected ISingleElectron[] singleElectrons;
    protected Set<IStereoElement> stereoElements;

    public AtomContainer() {
        this(0, 0, 0, 0);
    }

    public AtomContainer(IAtomContainer container) {
        int f;
        this.atomCount = container.getAtomCount();
        this.bondCount = container.getBondCount();
        this.lonePairCount = container.getLonePairCount();
        this.singleElectronCount = container.getSingleElectronCount();
        this.atoms = new IAtom[this.atomCount];
        this.bonds = new IBond[this.bondCount];
        this.lonePairs = new ILonePair[this.lonePairCount];
        this.singleElectrons = new ISingleElectron[this.singleElectronCount];
        this.stereoElements = new HashSet<IStereoElement>(this.atomCount / 2);
        for (IStereoElement element : container.stereoElements()) {
            this.addStereoElement(element);
        }
        for (f = 0; f < container.getAtomCount(); ++f) {
            this.atoms[f] = container.getAtom(f);
            container.getAtom(f).addListener((IChemObjectListener)this);
        }
        for (f = 0; f < this.bondCount; ++f) {
            this.bonds[f] = container.getBond(f);
            container.getBond(f).addListener((IChemObjectListener)this);
        }
        for (f = 0; f < this.lonePairCount; ++f) {
            this.lonePairs[f] = container.getLonePair(f);
            container.getLonePair(f).addListener((IChemObjectListener)this);
        }
        for (f = 0; f < this.singleElectronCount; ++f) {
            this.singleElectrons[f] = container.getSingleElectron(f);
            container.getSingleElectron(f).addListener((IChemObjectListener)this);
        }
    }

    public AtomContainer(int atomCount, int bondCount, int lpCount, int seCount) {
        this.atomCount = 0;
        this.bondCount = 0;
        this.lonePairCount = 0;
        this.singleElectronCount = 0;
        this.atoms = new IAtom[atomCount];
        this.bonds = new IBond[bondCount];
        this.lonePairs = new ILonePair[lpCount];
        this.singleElectrons = new ISingleElectron[seCount];
        this.stereoElements = new HashSet<IStereoElement>(atomCount / 2);
    }

    public void addStereoElement(IStereoElement element) {
        this.stereoElements.add(element);
    }

    public void setStereoElements(List<IStereoElement> elements) {
        this.stereoElements = new HashSet<IStereoElement>();
        this.stereoElements.addAll(elements);
    }

    public Iterable<IStereoElement> stereoElements() {
        return Collections.unmodifiableSet(this.stereoElements);
    }

    private boolean isStale(IAtom atom) {
        return this.indexOf(atom) < 0;
    }

    private boolean isStale(IBond bond) {
        return this.indexOf(bond) < 0 || this.indexOf(bond.getBegin()) < 0 || this.indexOf(bond.getEnd()) < 0;
    }

    private boolean isStale(IChemObject cobj) {
        if (cobj instanceof IAtom) {
            return this.isStale((IAtom)cobj);
        }
        if (cobj instanceof IBond) {
            return this.isStale((IBond)cobj);
        }
        return true;
    }

    private boolean isStale(IStereoElement<?, ?> se) {
        if (this.isStale(se.getFocus())) {
            return true;
        }
        for (IChemObject a : se.getCarriers()) {
            if (!this.isStale(a)) continue;
            return true;
        }
        return false;
    }

    private boolean isStale(Sgroup sgroup) {
        for (IAtom a : sgroup.getAtoms()) {
            if (this.indexOf(a) >= 0) continue;
            return true;
        }
        for (IBond b : sgroup.getBonds()) {
            if (!this.isStale(b)) continue;
            return true;
        }
        return false;
    }

    private void validateStereoAndSgroups() {
        ArrayList sgroups;
        if (!this.stereoElements.isEmpty()) {
            ArrayList<IStereoElement> staleStereo = new ArrayList<IStereoElement>();
            for (IStereoElement se : this.stereoElements) {
                if (!this.isStale(se)) continue;
                staleStereo.add(se);
            }
            this.stereoElements.removeAll(staleStereo);
        }
        if ((sgroups = (ArrayList)this.getProperty("cdk:CtabSgroups")) != null) {
            ArrayList<Sgroup> staleSgroups = new ArrayList<Sgroup>();
            for (Sgroup sgroup : sgroups) {
                if (!this.isStale(sgroup)) continue;
                staleSgroups.add(sgroup);
            }
            if (!staleSgroups.isEmpty()) {
                sgroups = new ArrayList(sgroups);
                sgroups.removeAll(staleSgroups);
                this.setProperty("cdk:CtabSgroups", sgroups);
            }
        }
    }

    public void setAtoms(IAtom[] newAtoms) {
        for (int i = 0; i < this.atomCount; ++i) {
            this.atoms[i].removeListener((IChemObjectListener)this);
        }
        for (IAtom atom : newAtoms) {
            atom.addListener((IChemObjectListener)this);
        }
        this.ensureAtomCapacity(newAtoms.length);
        System.arraycopy(newAtoms, 0, this.atoms, 0, newAtoms.length);
        if (newAtoms.length < this.atoms.length) {
            Arrays.fill(this.atoms, newAtoms.length, this.atoms.length, null);
        }
        this.atomCount = newAtoms.length;
        this.validateStereoAndSgroups();
        this.notifyChanged();
    }

    public void setBonds(IBond[] newBonds) {
        for (int i = 0; i < this.bondCount; ++i) {
            this.bonds[i].removeListener((IChemObjectListener)this);
        }
        for (IBond bond : newBonds) {
            bond.addListener((IChemObjectListener)this);
        }
        this.ensureBondCapacity(newBonds.length);
        System.arraycopy(newBonds, 0, this.bonds, 0, newBonds.length);
        if (newBonds.length < this.bonds.length) {
            Arrays.fill(this.bonds, newBonds.length, this.bonds.length, null);
        }
        this.bondCount = newBonds.length;
        this.validateStereoAndSgroups();
    }

    public void setAtom(int idx, IAtom atom) {
        List sgroups;
        if (idx >= this.atomCount) {
            throw new IndexOutOfBoundsException("No atom at index: " + idx);
        }
        int aidx = this.indexOf(atom);
        if (aidx >= 0) {
            throw new IllegalArgumentException("Atom already in container at index: " + idx);
        }
        IAtom oldAtom = this.atoms[idx];
        this.atoms[idx] = atom;
        atom.addListener((IChemObjectListener)this);
        oldAtom.removeListener((IChemObjectListener)this);
        for (IBond bond : this.bonds()) {
            for (int i = 0; i < bond.getAtomCount(); ++i) {
                if (!oldAtom.equals((Object)bond.getAtom(i))) continue;
                bond.setAtom(atom, i);
            }
        }
        for (ISingleElectron ec : this.singleElectrons()) {
            if (!oldAtom.equals((Object)ec.getAtom())) continue;
            ec.setAtom(atom);
        }
        for (ILonePair lp : this.lonePairs()) {
            if (!oldAtom.equals((Object)lp.getAtom())) continue;
            lp.setAtom(atom);
        }
        ArrayList<IStereoElement> oldStereo = null;
        ArrayList<IStereoElement> newStereo = null;
        for (IStereoElement se : this.stereoElements()) {
            if (!se.contains(oldAtom)) continue;
            if (oldStereo == null) {
                oldStereo = new ArrayList<IStereoElement>();
                newStereo = new ArrayList<IStereoElement>();
            }
            oldStereo.add(se);
            Map<IAtom, IAtom> amap = Collections.singletonMap(oldAtom, atom);
            Map bmap = Collections.emptyMap();
            newStereo.add(se.map(amap, bmap));
        }
        if (oldStereo != null) {
            this.stereoElements.removeAll(oldStereo);
            this.stereoElements.addAll(newStereo);
        }
        if ((sgroups = (List)this.getProperty("cdk:CtabSgroups")) != null) {
            for (Sgroup sgroup : sgroups) {
                if (!sgroup.getAtoms().contains(oldAtom)) continue;
                sgroup.removeAtom(oldAtom);
                sgroup.addAtom(atom);
            }
        }
        this.notifyChanged();
    }

    public IAtom getAtom(int idx) {
        if (idx < 0 || idx >= this.atomCount) {
            throw new IndexOutOfBoundsException("Atom index out of bounds: 0 <= " + idx + " < " + this.atomCount);
        }
        return this.atoms[idx];
    }

    public IBond getBond(int idx) {
        if (idx < 0 || idx >= this.bondCount) {
            throw new IndexOutOfBoundsException("Bond index out of bounds: 0 <= " + idx + " < " + this.bondCount);
        }
        return this.bonds[idx];
    }

    public ILonePair getLonePair(int idx) {
        if (idx < 0 || idx >= this.lonePairCount) {
            throw new IndexOutOfBoundsException("Lone Pair index out of bounds: 0 <= " + idx + " < " + this.lonePairCount);
        }
        return this.lonePairs[idx];
    }

    public ISingleElectron getSingleElectron(int idx) {
        if (idx < 0 || idx >= this.singleElectronCount) {
            throw new IndexOutOfBoundsException("Single Electrong index out of bounds: 0 <= " + idx + " < " + this.singleElectronCount);
        }
        return this.singleElectrons[idx];
    }

    public Iterable<IAtom> atoms() {
        return () -> new AtomIterator();
    }

    public Iterable<IBond> bonds() {
        return () -> new BondIterator();
    }

    public Iterable<ILonePair> lonePairs() {
        return () -> new LonePairIterator();
    }

    public Iterable<ISingleElectron> singleElectrons() {
        return () -> new SingleElectronIterator();
    }

    public Iterable<IElectronContainer> electronContainers() {
        return () -> new ElectronContainerIterator();
    }

    public IAtom getFirstAtom() {
        return this.atoms[0];
    }

    public IAtom getLastAtom() {
        return this.getAtomCount() > 0 ? this.atoms[this.getAtomCount() - 1] : null;
    }

    public int getAtomNumber(IAtom atom) {
        return this.indexOf(atom);
    }

    public int getBondNumber(IAtom atom1, IAtom atom2) {
        return this.indexOf(this.getBond(atom1, atom2));
    }

    public int getBondNumber(IBond bond) {
        return this.indexOf(bond);
    }

    public int getLonePairNumber(ILonePair lonePair) {
        return this.indexOf(lonePair);
    }

    public int getSingleElectronNumber(ISingleElectron singleElectron) {
        return this.indexOf(singleElectron);
    }

    public int indexOf(IAtom atom) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (!this.atoms[i].equals((Object)atom)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(IBond bond) {
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].equals((Object)bond)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(ISingleElectron electron) {
        for (int i = 0; i < this.singleElectronCount; ++i) {
            if (this.singleElectrons[i] != electron) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(ILonePair pair) {
        for (int i = 0; i < this.lonePairCount; ++i) {
            if (this.lonePairs[i] != pair) continue;
            return i;
        }
        return -1;
    }

    public IElectronContainer getElectronContainer(int number) {
        if (number < this.bondCount) {
            return this.bonds[number];
        }
        if ((number -= this.bondCount) < this.lonePairCount) {
            return this.lonePairs[number];
        }
        if ((number -= this.lonePairCount) < this.singleElectronCount) {
            return this.singleElectrons[number];
        }
        return null;
    }

    public IBond getBond(IAtom atom1, IAtom atom2) {
        for (int i = 0; i < this.getBondCount(); ++i) {
            if (!this.bonds[i].contains(atom1) || !this.bonds[i].getOther(atom1).equals((Object)atom2)) continue;
            return this.bonds[i];
        }
        return null;
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public int getLonePairCount() {
        return this.lonePairCount;
    }

    public int getSingleElectronCount() {
        return this.singleElectronCount;
    }

    public int getElectronContainerCount() {
        return this.bondCount + this.lonePairCount + this.singleElectronCount;
    }

    public List<IAtom> getConnectedAtomsList(IAtom atom) {
        ArrayList<IAtom> atomsList = new ArrayList<IAtom>(4);
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom)) continue;
            atomsList.add(this.bonds[i].getOther(atom));
        }
        if (atomsList.isEmpty() && !this.contains(atom)) {
            throw new NoSuchAtomException("Atom does not belong to the container!");
        }
        return atomsList;
    }

    public List<IBond> getConnectedBondsList(IAtom atom) {
        ArrayList<IBond> bondsList = new ArrayList<IBond>(4);
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom)) continue;
            bondsList.add(this.bonds[i]);
        }
        if (bondsList.isEmpty() && !this.contains(atom)) {
            throw new NoSuchAtomException("Atom does not belong to the container!");
        }
        return bondsList;
    }

    public List<ILonePair> getConnectedLonePairsList(IAtom atom) {
        ArrayList<ILonePair> lps = new ArrayList<ILonePair>(2);
        for (int i = 0; i < this.lonePairCount; ++i) {
            if (!this.lonePairs[i].contains(atom)) continue;
            lps.add(this.lonePairs[i]);
        }
        if (lps.isEmpty() && !this.contains(atom)) {
            throw new NoSuchAtomException("Atom does not belong to the container!");
        }
        return lps;
    }

    public List<ISingleElectron> getConnectedSingleElectronsList(IAtom atom) {
        ArrayList<ISingleElectron> ses = new ArrayList<ISingleElectron>(2);
        for (int i = 0; i < this.singleElectronCount; ++i) {
            if (!this.singleElectrons[i].contains(atom)) continue;
            ses.add(this.singleElectrons[i]);
        }
        if (ses.isEmpty() && !this.contains(atom)) {
            throw new NoSuchAtomException("Atom does not belong to the container!");
        }
        return ses;
    }

    public List<IElectronContainer> getConnectedElectronContainersList(IAtom atom) {
        int i;
        ArrayList<IElectronContainer> ecs = new ArrayList<IElectronContainer>(4);
        for (i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom)) continue;
            ecs.add((IElectronContainer)this.bonds[i]);
        }
        for (i = 0; i < this.lonePairCount; ++i) {
            if (!this.lonePairs[i].contains(atom)) continue;
            ecs.add((IElectronContainer)this.lonePairs[i]);
        }
        for (i = 0; i < this.singleElectronCount; ++i) {
            if (!this.singleElectrons[i].contains(atom)) continue;
            ecs.add((IElectronContainer)this.singleElectrons[i]);
        }
        if (ecs.isEmpty() && !this.contains(atom)) {
            throw new NoSuchAtomException("Atom does not belong to the container!");
        }
        return ecs;
    }

    public int getConnectedBondsCount(IAtom atom) {
        int count = 0;
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom)) continue;
            ++count;
        }
        if (count == 0 && !this.contains(atom)) {
            throw new NoSuchAtomException("Atom does not belong to the container!");
        }
        return count;
    }

    public int getConnectedAtomsCount(IAtom atom) {
        return this.getConnectedBondsCount(atom);
    }

    public int getConnectedBondsCount(int idx) {
        IAtom atom = this.getAtom(idx);
        int count = 0;
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom)) continue;
            ++count;
        }
        return count;
    }

    public int getConnectedLonePairsCount(IAtom atom) {
        int count = 0;
        for (int i = 0; i < this.lonePairCount; ++i) {
            if (!this.lonePairs[i].contains(atom)) continue;
            ++count;
        }
        if (count == 0 && !this.contains(atom)) {
            throw new NoSuchAtomException("Atom does not belong to the container!");
        }
        return count;
    }

    public int getConnectedSingleElectronsCount(IAtom atom) {
        int count = 0;
        for (int i = 0; i < this.singleElectronCount; ++i) {
            if (!this.singleElectrons[i].contains(atom)) continue;
            ++count;
        }
        if (count == 0 && !this.contains(atom)) {
            throw new NoSuchAtomException("Atom does not belong to the container!");
        }
        return count;
    }

    public double getBondOrderSum(IAtom atom) {
        double count = 0.0;
        for (int i = 0; i < this.bondCount; ++i) {
            IBond.Order order;
            if (!this.bonds[i].contains(atom) || (order = this.bonds[i].getOrder()) == null) continue;
            count += (double)order.numeric().intValue();
        }
        return count;
    }

    public IBond.Order getMaximumBondOrder(IAtom atom) {
        IBond.Order max = null;
        for (IBond bond : this.bonds()) {
            if (!bond.contains(atom) || max != null && bond.getOrder().numeric() <= max.numeric()) continue;
            max = bond.getOrder();
        }
        if (max == null) {
            if (!this.contains(atom)) {
                throw new NoSuchAtomException("Atom does not belong to this container!");
            }
            max = atom.getImplicitHydrogenCount() != null && atom.getImplicitHydrogenCount() > 0 ? IBond.Order.SINGLE : IBond.Order.UNSET;
        }
        return max;
    }

    public IBond.Order getMinimumBondOrder(IAtom atom) {
        IBond.Order min = null;
        for (IBond bond : this.bonds()) {
            if (!bond.contains(atom) || min != null && bond.getOrder().numeric() >= min.numeric()) continue;
            min = bond.getOrder();
        }
        if (min == null) {
            if (!this.contains(atom)) {
                throw new NoSuchAtomException("Atom does not belong to this container!");
            }
            min = atom.getImplicitHydrogenCount() != null && atom.getImplicitHydrogenCount() > 0 ? IBond.Order.SINGLE : IBond.Order.UNSET;
        }
        return min;
    }

    public void add(IAtomContainer that) {
        this.atoms = Arrays.copyOf(this.atoms, this.atomCount + that.getAtomCount());
        this.bonds = Arrays.copyOf(this.bonds, this.bondCount + that.getBondCount());
        for (IAtom atom : that.atoms()) {
            atom.setFlag(16, false);
        }
        for (IBond bond : that.bonds()) {
            bond.setFlag(16, false);
        }
        for (IAtom atom : this.atoms()) {
            atom.setFlag(16, true);
        }
        for (IBond bond : this.bonds()) {
            bond.setFlag(16, true);
        }
        for (IAtom atom : that.atoms()) {
            if (atom.getFlag(16)) continue;
            atom.setFlag(16, true);
            this.atoms[this.atomCount++] = atom;
        }
        for (IBond bond : that.bonds()) {
            if (bond.getFlag(16)) continue;
            bond.setFlag(16, true);
            this.bonds[this.bondCount++] = bond;
        }
        for (ILonePair lp : that.lonePairs()) {
            if (this.contains(lp)) continue;
            this.addLonePair(lp);
        }
        for (ISingleElectron se : that.singleElectrons()) {
            if (this.contains(se)) continue;
            this.addSingleElectron(se);
        }
        for (ISingleElectron se : that.stereoElements()) {
            this.stereoElements.add((IStereoElement)se);
        }
        this.notifyChanged();
    }

    public void addAtom(IAtom atom) {
        if (this.contains(atom)) {
            return;
        }
        this.ensureAtomCapacity(this.atomCount + 1);
        atom.addListener((IChemObjectListener)this);
        this.atoms[this.atomCount++] = atom;
        this.notifyChanged();
    }

    public void addBond(IBond bond) {
        this.ensureBondCapacity(this.bondCount + 1);
        this.bonds[this.bondCount++] = bond;
        this.notifyChanged();
    }

    public void addLonePair(ILonePair lonePair) {
        this.ensureLonePairCapacity(this.lonePairCount + 1);
        this.lonePairs[this.lonePairCount++] = lonePair;
        this.notifyChanged();
    }

    public void addSingleElectron(ISingleElectron singleElectron) {
        this.ensureElectronCapacity(this.singleElectronCount + 1);
        this.singleElectrons[this.singleElectronCount++] = singleElectron;
        this.notifyChanged();
    }

    public void addElectronContainer(IElectronContainer electronContainer) {
        if (electronContainer instanceof IBond) {
            this.addBond((IBond)electronContainer);
        }
        if (electronContainer instanceof ILonePair) {
            this.addLonePair((ILonePair)electronContainer);
        }
        if (electronContainer instanceof ISingleElectron) {
            this.addSingleElectron((ISingleElectron)electronContainer);
        }
    }

    public void remove(IAtomContainer atomContainer) {
        int f;
        for (f = 0; f < atomContainer.getAtomCount(); ++f) {
            this.removeAtomOnly(atomContainer.getAtom(f));
        }
        for (f = 0; f < atomContainer.getBondCount(); ++f) {
            this.removeBond(atomContainer.getBond(f));
        }
        for (f = 0; f < atomContainer.getLonePairCount(); ++f) {
            this.removeLonePair(atomContainer.getLonePair(f));
        }
        for (f = 0; f < atomContainer.getSingleElectronCount(); ++f) {
            this.removeSingleElectron(atomContainer.getSingleElectron(f));
        }
    }

    public void removeAtomOnly(int position) {
        this.atoms[position].removeListener((IChemObjectListener)this);
        for (int i = position; i < this.atomCount - 1; ++i) {
            this.atoms[i] = this.atoms[i + 1];
        }
        this.atoms[this.atomCount - 1] = null;
        --this.atomCount;
        this.notifyChanged();
    }

    public void removeAtomOnly(IAtom atom) {
        int position = this.getAtomNumber(atom);
        if (position != -1) {
            this.removeAtomOnly(position);
        }
    }

    public IBond removeBond(int position) {
        IBond bond = this.bonds[position];
        bond.removeListener((IChemObjectListener)this);
        for (int i = position; i < this.bondCount - 1; ++i) {
            this.bonds[i] = this.bonds[i + 1];
        }
        this.bonds[this.bondCount - 1] = null;
        --this.bondCount;
        this.notifyChanged();
        return bond;
    }

    public IBond removeBond(IAtom atom1, IAtom atom2) {
        int pos = this.indexOf(this.getBond(atom1, atom2));
        IBond bond = null;
        if (pos != -1) {
            bond = this.bonds[pos];
            this.removeBond(pos);
        }
        return bond;
    }

    public void removeBond(IBond bond) {
        int pos = this.getBondNumber(bond);
        if (pos != -1) {
            this.removeBond(pos);
        }
    }

    public ILonePair removeLonePair(int position) {
        ILonePair lp = this.lonePairs[position];
        lp.removeListener((IChemObjectListener)this);
        for (int i = position; i < this.lonePairCount - 1; ++i) {
            this.lonePairs[i] = this.lonePairs[i + 1];
        }
        this.lonePairs[this.lonePairCount - 1] = null;
        --this.lonePairCount;
        this.notifyChanged();
        return lp;
    }

    public void removeLonePair(ILonePair lonePair) {
        int pos = this.indexOf(lonePair);
        if (pos != -1) {
            this.removeLonePair(pos);
        }
    }

    public ISingleElectron removeSingleElectron(int position) {
        ISingleElectron se = this.singleElectrons[position];
        se.removeListener((IChemObjectListener)this);
        for (int i = position; i < this.singleElectronCount - 1; ++i) {
            this.singleElectrons[i] = this.singleElectrons[i + 1];
        }
        this.singleElectrons[this.singleElectronCount - 1] = null;
        --this.singleElectronCount;
        this.notifyChanged();
        return se;
    }

    public void removeSingleElectron(ISingleElectron singleElectron) {
        int pos = this.indexOf(singleElectron);
        if (pos != -1) {
            this.removeSingleElectron(pos);
        }
    }

    public IElectronContainer removeElectronContainer(int number) {
        if (number < this.bondCount) {
            return this.removeBond(number);
        }
        if ((number -= this.bondCount) < this.lonePairCount) {
            return this.removeLonePair(number);
        }
        if ((number -= this.lonePairCount) < this.singleElectronCount) {
            return this.removeSingleElectron(number);
        }
        return null;
    }

    public void removeElectronContainer(IElectronContainer electronContainer) {
        if (electronContainer instanceof IBond) {
            this.removeBond((IBond)electronContainer);
        } else if (electronContainer instanceof ILonePair) {
            this.removeLonePair((ILonePair)electronContainer);
        } else if (electronContainer instanceof ISingleElectron) {
            this.removeSingleElectron((ISingleElectron)electronContainer);
        }
    }

    @Deprecated
    public void removeAtomAndConnectedElectronContainers(IAtom atom) {
        this.removeAtom(atom);
    }

    public void removeAtom(IAtom atom) {
        int position = this.getAtomNumber(atom);
        if (position != -1) {
            int i;
            for (i = 0; i < this.bondCount; ++i) {
                if (!this.bonds[i].contains(atom)) continue;
                this.removeBond(i);
                --i;
            }
            for (i = 0; i < this.lonePairCount; ++i) {
                if (!this.lonePairs[i].contains(atom)) continue;
                this.removeLonePair(i);
                --i;
            }
            for (i = 0; i < this.singleElectronCount; ++i) {
                if (!this.singleElectrons[i].contains(atom)) continue;
                this.removeSingleElectron(i);
                --i;
            }
            ArrayList<IStereoElement> stereoToRemove = new ArrayList<IStereoElement>();
            for (IStereoElement element : this.stereoElements) {
                if (!element.contains(atom)) continue;
                stereoToRemove.add(element);
            }
            this.stereoElements.removeAll(stereoToRemove);
            ArrayList sgroups = (ArrayList)this.getProperty("cdk:CtabSgroups");
            if (sgroups != null) {
                ArrayList<Sgroup> sgrpToRemove = new ArrayList<Sgroup>();
                for (Sgroup sgroup : sgroups) {
                    if (!sgroup.getAtoms().contains(atom)) continue;
                    sgrpToRemove.add(sgroup);
                }
                if (!sgrpToRemove.isEmpty()) {
                    sgroups = new ArrayList(sgroups);
                    sgroups.removeAll(sgrpToRemove);
                    this.setProperty("cdk:CtabSgroups", sgroups);
                }
            }
            this.removeAtomOnly(position);
        }
        this.notifyChanged();
    }

    public void removeAtom(int pos) {
        this.removeAtom(this.getAtom(pos));
    }

    public void removeAllElements() {
        this.removeAllElectronContainers();
        for (int f = 0; f < this.getAtomCount(); ++f) {
            this.getAtom(f).removeListener((IChemObjectListener)this);
        }
        this.atoms = new IAtom[10];
        this.atomCount = 0;
        this.stereoElements.clear();
        this.notifyChanged();
    }

    public void removeAllElectronContainers() {
        int f;
        this.removeAllBonds();
        for (f = 0; f < this.getLonePairCount(); ++f) {
            this.getLonePair(f).removeListener((IChemObjectListener)this);
        }
        for (f = 0; f < this.getSingleElectronCount(); ++f) {
            this.getSingleElectron(f).removeListener((IChemObjectListener)this);
        }
        this.lonePairs = new ILonePair[10];
        this.singleElectrons = new ISingleElectron[10];
        this.lonePairCount = 0;
        this.singleElectronCount = 0;
        this.notifyChanged();
    }

    public void removeAllBonds() {
        for (int f = 0; f < this.getBondCount(); ++f) {
            this.getBond(f).removeListener((IChemObjectListener)this);
        }
        this.bonds = new IBond[10];
        this.bondCount = 0;
        this.notifyChanged();
    }

    public void addBond(int atom1, int atom2, IBond.Order order, IBond.Stereo stereo) {
        IBond bond = (IBond)this.getBuilder().newInstance(IBond.class, new Object[]{this.getAtom(atom1), this.getAtom(atom2), order, stereo});
        this.addBond(bond);
    }

    public void addBond(int atom1, int atom2, IBond.Order order) {
        IBond bond = (IBond)this.getBuilder().newInstance(IBond.class, new Object[]{this.getAtom(atom1), this.getAtom(atom2), order});
        this.addBond(bond);
    }

    public void addLonePair(int atomID) {
        ILonePair lonePair = (ILonePair)this.getBuilder().newInstance(ILonePair.class, new Object[]{this.atoms[atomID]});
        lonePair.addListener((IChemObjectListener)this);
        this.addLonePair(lonePair);
    }

    public void addSingleElectron(int atomID) {
        ISingleElectron singleElectron = (ISingleElectron)this.getBuilder().newInstance(ISingleElectron.class, new Object[]{this.atoms[atomID]});
        singleElectron.addListener((IChemObjectListener)this);
        this.addSingleElectron(singleElectron);
    }

    public boolean contains(IAtom atom) {
        for (int i = 0; i < this.getAtomCount(); ++i) {
            if (!this.atoms[i].equals((Object)atom)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IBond bond) {
        for (int i = 0; i < this.getBondCount(); ++i) {
            if (!this.bonds[i].equals((Object)bond)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ILonePair lonePair) {
        for (int i = 0; i < this.getLonePairCount(); ++i) {
            if (lonePair != this.lonePairs[i]) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ISingleElectron singleElectron) {
        for (int i = 0; i < this.getSingleElectronCount(); ++i) {
            if (singleElectron != this.singleElectrons[i]) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IElectronContainer electronContainer) {
        if (electronContainer instanceof IBond) {
            return this.contains((IBond)electronContainer);
        }
        if (electronContainer instanceof ILonePair) {
            return this.contains((ILonePair)electronContainer);
        }
        if (electronContainer instanceof ISingleElectron) {
            return this.contains((SingleElectron)electronContainer);
        }
        return false;
    }

    public String toString() {
        int i;
        StringBuilder stringContent = new StringBuilder(64);
        stringContent.append("AtomContainer(");
        stringContent.append(this.hashCode());
        if (this.getAtomCount() > 0) {
            stringContent.append(", #A:").append(this.getAtomCount());
            for (i = 0; i < this.getAtomCount(); ++i) {
                stringContent.append(", ").append(this.getAtom(i).toString());
            }
        }
        if (this.getBondCount() > 0) {
            stringContent.append(", #B:").append(this.getBondCount());
            for (i = 0; i < this.getBondCount(); ++i) {
                stringContent.append(", ").append(this.getBond(i).toString());
            }
        }
        if (this.getLonePairCount() > 0) {
            stringContent.append(", #LP:").append(this.getLonePairCount());
            for (i = 0; i < this.getLonePairCount(); ++i) {
                stringContent.append(", ").append(this.getLonePair(i).toString());
            }
        }
        if (this.getSingleElectronCount() > 0) {
            stringContent.append(", #SE:").append(this.getSingleElectronCount());
            for (i = 0; i < this.getSingleElectronCount(); ++i) {
                stringContent.append(", ").append(this.getSingleElectron(i).toString());
            }
        }
        if (this.stereoElements.size() > 0) {
            stringContent.append(", ST:[#").append(this.stereoElements.size());
            for (IStereoElement elements : this.stereoElements) {
                stringContent.append(", ").append(elements.toString());
            }
            stringContent.append(']');
        }
        stringContent.append(')');
        return stringContent.toString();
    }

    public IAtomContainer clone() throws CloneNotSupportedException {
        IBond original;
        int i;
        IAtomContainer clone = (IAtomContainer)super.clone();
        clone.setStereoElements(new ArrayList(this.stereoElements.size()));
        clone.removeAllElements();
        HashMap<IAtom, IAtom> atomMap = new HashMap<IAtom, IAtom>(this.atomCount >= 3 ? this.atomCount + this.atomCount / 3 : this.atomCount + 1);
        HashMap<IBond, IBond> bondMap = new HashMap<IBond, IBond>(this.bondCount >= 3 ? this.bondCount + this.bondCount / 3 : this.bondCount + 1);
        IAtom[] atoms = new IAtom[this.atomCount];
        for (int i2 = 0; i2 < atoms.length; ++i2) {
            atoms[i2] = this.atoms[i2].clone();
            atomMap.put(this.atoms[i2], atoms[i2]);
        }
        clone.setAtoms(atoms);
        IBond[] bonds = new IBond[this.bondCount];
        for (i = 0; i < bonds.length; ++i) {
            original = this.bonds[i];
            IBond bond = original.clone();
            int n = bond.getAtomCount();
            IAtom[] members = new IAtom[n];
            for (int j = 0; j < n; ++j) {
                members[j] = (IAtom)atomMap.get(original.getAtom(j));
            }
            bond.setAtoms(members);
            bondMap.put(this.bonds[i], bond);
            bonds[i] = bond;
        }
        clone.setBonds(bonds);
        for (i = 0; i < this.lonePairCount; ++i) {
            original = this.lonePairs[i];
            ILonePair pair = (ILonePair)original.clone();
            if (pair.getAtom() != null) {
                pair.setAtom((IAtom)atomMap.get(original.getAtom()));
            }
            clone.addLonePair(pair);
        }
        for (i = 0; i < this.singleElectronCount; ++i) {
            original = this.singleElectrons[i];
            ISingleElectron electron = (ISingleElectron)original.clone();
            if (electron.getAtom() != null) {
                electron.setAtom((IAtom)atomMap.get(original.getAtom()));
            }
            clone.addSingleElectron(electron);
        }
        for (IStereoElement element : this.stereoElements) {
            clone.addStereoElement(element.map(atomMap, bondMap));
        }
        Collection sgroups = (Collection)this.getProperty("cdk:CtabSgroups");
        if (sgroups != null) {
            HashMap<Object, Object> replace = new HashMap<Object, Object>();
            replace.putAll(atomMap);
            replace.putAll(bondMap);
            clone.setProperty((Object)"cdk:CtabSgroups", (Object)SgroupManipulator.copy((Collection)sgroups, replace));
        }
        return clone;
    }

    private static <T> T[] grow(T[] array, int required) {
        int newCapacity;
        int oldCapacity = array.length;
        int n = newCapacity = oldCapacity == 0 ? 20 : oldCapacity + (oldCapacity >> 1);
        if (newCapacity < required) {
            newCapacity = required;
        }
        return Arrays.copyOf(array, newCapacity);
    }

    private void ensureAtomCapacity(int required) {
        if (required > this.atoms.length) {
            this.atoms = AtomContainer.grow(this.atoms, required);
        }
    }

    private void ensureBondCapacity(int required) {
        if (required > this.bonds.length) {
            this.bonds = AtomContainer.grow(this.bonds, required);
        }
    }

    private void ensureElectronCapacity(int required) {
        if (required > this.singleElectrons.length) {
            this.singleElectrons = AtomContainer.grow(this.singleElectrons, required);
        }
    }

    private void ensureLonePairCapacity(int required) {
        if (required > this.lonePairs.length) {
            this.lonePairs = AtomContainer.grow(this.lonePairs, required);
        }
    }

    public void stateChanged(IChemObjectChangeEvent event) {
        this.notifyChanged(event);
    }

    public boolean isEmpty() {
        return this.atomCount == 0;
    }

    public String getTitle() {
        return (String)this.getProperty("cdk:Title");
    }

    public void setTitle(String title) {
        this.setProperty("cdk:Title", title);
    }

    private class ElectronContainerIterator
    implements Iterator<IElectronContainer> {
        private int pointer = 0;

        private ElectronContainerIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < AtomContainer.this.bondCount + AtomContainer.this.lonePairCount + AtomContainer.this.singleElectronCount;
        }

        @Override
        public IElectronContainer next() {
            if (this.pointer < AtomContainer.this.bondCount) {
                return AtomContainer.this.bonds[this.pointer++];
            }
            if (this.pointer < AtomContainer.this.bondCount + AtomContainer.this.lonePairCount) {
                return AtomContainer.this.lonePairs[this.pointer++ - AtomContainer.this.bondCount];
            }
            if (this.pointer < AtomContainer.this.bondCount + AtomContainer.this.lonePairCount + AtomContainer.this.singleElectronCount) {
                return AtomContainer.this.singleElectrons[this.pointer++ - AtomContainer.this.bondCount - AtomContainer.this.lonePairCount];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.pointer <= AtomContainer.this.bondCount) {
                AtomContainer.this.removeBond(--this.pointer);
            } else if (this.pointer <= AtomContainer.this.bondCount + AtomContainer.this.lonePairCount) {
                AtomContainer.this.removeLonePair(--this.pointer - AtomContainer.this.bondCount);
            } else if (this.pointer <= AtomContainer.this.bondCount + AtomContainer.this.lonePairCount + AtomContainer.this.singleElectronCount) {
                AtomContainer.this.removeSingleElectron(--this.pointer - AtomContainer.this.bondCount - AtomContainer.this.lonePairCount);
            }
        }
    }

    private class SingleElectronIterator
    implements Iterator<ISingleElectron> {
        private int pointer = 0;

        private SingleElectronIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < AtomContainer.this.singleElectronCount;
        }

        @Override
        public ISingleElectron next() {
            if (this.pointer >= AtomContainer.this.singleElectronCount) {
                throw new NoSuchElementException();
            }
            return AtomContainer.this.singleElectrons[this.pointer++];
        }

        @Override
        public void remove() {
            AtomContainer.this.removeSingleElectron(--this.pointer);
        }
    }

    private class LonePairIterator
    implements Iterator<ILonePair> {
        private int pointer = 0;

        private LonePairIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < AtomContainer.this.lonePairCount;
        }

        @Override
        public ILonePair next() {
            if (this.pointer >= AtomContainer.this.lonePairCount) {
                throw new NoSuchElementException();
            }
            return AtomContainer.this.lonePairs[this.pointer++];
        }

        @Override
        public void remove() {
            AtomContainer.this.removeLonePair(--this.pointer);
        }
    }

    private class BondIterator
    implements Iterator<IBond> {
        private int pointer = 0;

        private BondIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < AtomContainer.this.bondCount;
        }

        @Override
        public IBond next() {
            if (this.pointer >= AtomContainer.this.bondCount) {
                throw new NoSuchElementException();
            }
            return AtomContainer.this.bonds[this.pointer++];
        }

        @Override
        public void remove() {
            AtomContainer.this.removeBond(--this.pointer);
        }
    }

    private class AtomIterator
    implements Iterator<IAtom> {
        private int pointer = 0;

        private AtomIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < AtomContainer.this.atomCount;
        }

        @Override
        public IAtom next() {
            if (this.pointer >= AtomContainer.this.atomCount) {
                throw new NoSuchElementException();
            }
            return AtomContainer.this.atoms[this.pointer++];
        }

        @Override
        public void remove() {
            AtomContainer.this.removeAtomOnly(--this.pointer);
        }
    }
}

