/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.ChemObjectRef;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;

public class AtomRef
extends ChemObjectRef
implements IAtom {
    private final IAtom atom;

    public AtomRef(IAtom atom) {
        super((IChemObject)atom);
        this.atom = atom;
    }

    public static IAtom deref(IAtom atom) {
        while (atom instanceof AtomRef) {
            atom = ((AtomRef)atom).deref();
        }
        return atom;
    }

    public IAtom deref() {
        return this.atom;
    }

    public Double getCharge() {
        return this.atom.getCharge();
    }

    public void setCharge(Double charge) {
        this.atom.setCharge(charge);
    }

    public Integer getAtomicNumber() {
        return this.atom.getAtomicNumber();
    }

    public void setAtomicNumber(Integer atomicNumber) {
        this.atom.setAtomicNumber(atomicNumber);
    }

    public Double getNaturalAbundance() {
        return this.atom.getNaturalAbundance();
    }

    public void setNaturalAbundance(Double naturalAbundance) {
        this.atom.setNaturalAbundance(naturalAbundance);
    }

    public Integer getImplicitHydrogenCount() {
        return this.atom.getImplicitHydrogenCount();
    }

    public void setImplicitHydrogenCount(Integer hydrogenCount) {
        this.atom.setImplicitHydrogenCount(hydrogenCount);
    }

    public Double getExactMass() {
        return this.atom.getExactMass();
    }

    public void setExactMass(Double exactMass) {
        this.atom.setExactMass(exactMass);
    }

    public String getSymbol() {
        return this.atom.getSymbol();
    }

    public void setSymbol(String symbol) {
        this.atom.setSymbol(symbol);
    }

    public Integer getMassNumber() {
        return this.atom.getMassNumber();
    }

    public void setMassNumber(Integer massNumber) {
        this.atom.setMassNumber(massNumber);
    }

    public String getAtomTypeName() {
        return this.atom.getAtomTypeName();
    }

    public void setAtomTypeName(String identifier) {
        this.atom.setAtomTypeName(identifier);
    }

    public IBond.Order getMaxBondOrder() {
        return this.atom.getMaxBondOrder();
    }

    public void setMaxBondOrder(IBond.Order maxBondOrder) {
        this.atom.setMaxBondOrder(maxBondOrder);
    }

    public Double getBondOrderSum() {
        return this.atom.getBondOrderSum();
    }

    public void setBondOrderSum(Double bondOrderSum) {
        this.atom.setBondOrderSum(bondOrderSum);
    }

    public Point2d getPoint2d() {
        return this.atom.getPoint2d();
    }

    public void setPoint2d(Point2d point2d) {
        this.atom.setPoint2d(point2d);
    }

    public Point3d getPoint3d() {
        return this.atom.getPoint3d();
    }

    public void setPoint3d(Point3d point3d) {
        this.atom.setPoint3d(point3d);
    }

    public Integer getFormalCharge() {
        return this.atom.getFormalCharge();
    }

    public void setFormalCharge(Integer charge) {
        this.atom.setFormalCharge(charge);
    }

    public Point3d getFractionalPoint3d() {
        return this.atom.getFractionalPoint3d();
    }

    public void setFractionalPoint3d(Point3d point3d) {
        this.atom.setFractionalPoint3d(point3d);
    }

    public Integer getFormalNeighbourCount() {
        return this.atom.getFormalNeighbourCount();
    }

    public void setFormalNeighbourCount(Integer count) {
        this.atom.setFormalNeighbourCount(count);
    }

    public Integer getStereoParity() {
        return this.atom.getStereoParity();
    }

    public void setStereoParity(Integer stereoParity) {
        this.atom.setStereoParity(stereoParity);
    }

    public IAtomType.Hybridization getHybridization() {
        return this.atom.getHybridization();
    }

    public void setHybridization(IAtomType.Hybridization hybridization) {
        this.atom.setHybridization(hybridization);
    }

    public Double getCovalentRadius() {
        return this.atom.getCovalentRadius();
    }

    public void setCovalentRadius(Double radius) {
        this.atom.setCovalentRadius(radius);
    }

    public IAtomContainer getContainer() {
        return this.atom.getContainer();
    }

    public int getIndex() {
        return this.atom.getIndex();
    }

    public Integer getValency() {
        return this.atom.getValency();
    }

    public void setValency(Integer valency) {
        this.atom.setValency(valency);
    }

    public Iterable<IBond> bonds() {
        return this.atom.bonds();
    }

    public int getBondCount() {
        return this.atom.getBondCount();
    }

    public IBond getBond(IAtom atom) {
        return this.atom.getBond(atom);
    }

    public boolean isAromatic() {
        return this.atom.isAromatic();
    }

    public void setIsAromatic(boolean arom) {
        this.atom.setIsAromatic(arom);
    }

    public boolean isInRing() {
        return this.atom.isInRing();
    }

    public void setIsInRing(boolean ring) {
        this.atom.setIsInRing(ring);
    }

    public int getMapIdx() {
        return this.atom.getMapIdx();
    }

    public void setMapIdx(int mapidx) {
        this.atom.setMapIdx(mapidx);
    }

    public int hashCode() {
        return this.atom.hashCode();
    }

    public boolean equals(Object obj) {
        return this.atom.equals(obj);
    }

    public IAtom clone() throws CloneNotSupportedException {
        return this.atom.clone();
    }

    public String toString() {
        return "AtomRef{" + this.atom + "}";
    }
}

