% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcensIfix.R
\name{rcensIfix}
\alias{rcensIfix}
\title{Generate interval censoring sample (Fix)}
\usage{
rcensIfix(
  rdistrX,
  param_X,
  interval_length,
  n = 10000,
  theta = 1,
  verbose = FALSE
)
}
\arguments{
\item{rdistrX}{sample generator of distribution X. \cr
First argument number of samples, next arguments in param_X.}

\item{param_X}{list with parameters of rdistrX function.}

\item{interval_length}{length of interval}

\item{n}{number of sample to create.}

\item{theta}{Desired censoring percentage}

\item{verbose}{if TRUE print a censoring percentage of new created database.}
}
\value{
A list with sample data information: \tabular{ll}{
   \code{sample_censored} \tab vector of censored sample \cr
   \tab \cr
   \code{sample_uncensored} \tab vector of uncensored sample (original) \cr
   \tab \cr
   \code{censored_indicator} \tab vector of 1 and 0 indicating whether the i-th sample is censored  \cr
   \tab 1:= no censored, 0:= censored \cr
   \code{n_censored} \tab number of censored samples  \cr
}
}
\description{
Generator of interval censored samples where the length of interval is fixed,
 given a generator of samples of the distribution X (rdistrX) with
 parameters appended by the list param_X.
 In which, you can control the desired censorship percentage.
}
\examples{
#Example Exponential - Uniform

Data_Ifix = rcensIfix(rdistrX = rexp, interval_length = 2,
                   param_X = list("rate" = .5),
                   n = 1e02, theta = .9)

## Example with plot in examples_plot/Example_rcensIfix_plot.R
}
\seealso{
\code{\link{rcensT1}} for generate censorship sample type I.\cr
\code{\link{rcensT2}} for generate censorship sample type II.\cr
\code{\link{rcensT3}} for generate censorship sample type III\cr
\code{\link{rcensI}} for generate interval censoring sample
 with random length interval\cr
}
\author{
Daniel Saavedra Morales
}
