% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcurefT3.R
\name{rcurefT3}
\alias{rcurefT3}
\title{Title Generate Sample with Cure Fraction and Random Censoring}
\usage{
rcurefT3(
  rdistrX,
  pdistrC,
  rdistrC,
  param_X,
  param_C,
  p = 0.1,
  n = 10000,
  theta = 0.5,
  n_mc = 10000,
  lambda_tol = c(1e-06, 10000),
  verbose = FALSE,
  right = TRUE
)
}
\arguments{
\item{rdistrX}{sample generator of distribution X. \cr
First argument number of samples, next arguments in param_X.}

\item{pdistrC}{function distribution of C. First argument probabilities, next arguments in param_C.}

\item{rdistrC}{sample generator of distribution C. \cr First argument number of samples, next arguments in param_C.}

\item{param_X}{list with parameters of rdistrX function.}

\item{param_C}{list with parameters of rdistrC function, one of these parameters \cr should be "lambda",
this wil be the searched parameter.}

\item{p}{cure fraction}

\item{n}{number of sample to create.}

\item{theta}{Desired censoring percentage}

\item{n_mc}{number of sample use in Monte Carlo integration, greater n_mc more accuracy.}

\item{lambda_tol}{lowest and uppest value where live the search parameter lambda.}

\item{verbose}{if TRUE print a censoring percentage of new created database.}

\item{right}{if TRUE create right-censored data, else create left-censored}
}
\value{
A list with sample data information: \tabular{ll}{
   \code{lambda}\tab searched censoring distribution parameter.\cr
   \code{sample_censored} \tab vector of censored sample. \cr
   \tab \cr
   \code{sample_uncensored} \tab vector of uncensored sample (original). \cr
   \tab \cr
   \code{censored_indicator} \tab vector of 1 and 0 indicating whether the i-th sample is censored.  \cr
     \tab 1:= no censored, 0:= censored \cr
   \code{censored_time} \tab vector of censorship time. \cr
   \code{n_censored} \tab number of censored samples.  \cr
    \code{cure_list} \tab vector of 1 and 0 indicating whether the i-th sample is cured. \cr
    \tab 1:= cure , 0:= no cure \cr
   \code{cure_fraction} \tab cure fraction used to create de sample. \cr
   \tab \cr
}
}
\description{
Generator Sample with Cure Fraction, Random Censoring.
 Given a generator of samples of the distribution X (rdistrX) with
 parameters appended by the list param_X. Also accumulate function of distribution and generator sample
 of distribution C (censoring) with parameters appended by the list param_C
 In which, you can control the desired censorship percentage.
 \cr
 Note: cure fraction (p) must be less than desired censorship percentage.
}
\examples{

#Example Exponential - Uniform


Data_T3 = rcurefT3(rdistrX = rexp, pdistrC = punif, rdistrC = runif,
                   param_X = list("rate" = 2),
                   param_C = list("min" = 0, "max" = "lambda"),
                   n = 1e02, theta = .9, p = 0.2)




## Example with plot in examples_plot/Example_rcurefT3_plot.R
}
\seealso{
\code{\link{rcuref}} Generate Sample with Cure Fraction.\cr
}
\author{
Daniel Saavedra Morales
}
