% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcheology.R
\docType{package}
\name{rcheology-package}
\alias{rcheology-package}
\title{Data on base packages from current and previous versions of R}
\description{
rcheology is a data package providing two data frames:
}
\details{
\itemize{
\item \link{rcheology} lists objects in all versions of R from 2.0.0 onwards.
\item \link{Rversions} lists R versions and their release dates.
}

The version of the rcheology package reflects the latest R version to be included in the data,
e.g. 3.5.1.x contains data up to and including R 3.5.1.

An online app for data exploration is available at \url{https://hughjonesd.shinyapps.io/rcheology/}.
}
\section{How the data is created}{


Previous R versions are downloaded and installed on a Docker image. Objects in
all base packages are then listed. (Note that recommended packages, like \code{nnet} or \code{MASS},
are not installed.) For functions, the \code{\link[=formals]{formals()}} of the function are recorded.

Versions 3.0.1 and up are installed from the
\href{https://cran.r-project.org/bin/linux/ubuntu/trusty/}{CRAN apt repositories for Ubuntu Trusty Tahr}.
Version 3.5.0 and up use a
\href{https://cran.r-project.org/bin/linux/ubuntu/trusty-cran35/}{special repository}.

Versions 2.5.1 to 3.0.0 are built from source on \href{https://hub.docker.com/r/yamamuteki/ubuntu-lucid-i386/}{Ubuntu Lucid Lynx}.

Versions 2.0.0 to 2.4.1 are built from source on \href{https://hub.docker.com/r/debian/eol/}{Debian Sarge}.
}

