% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformTukey.r
\name{transformTukey}
\alias{transformTukey}
\title{Tukey's Ladder of Powers}
\usage{
transformTukey(x, start = -10, end = 10, int = 0.025, plotit = TRUE,
  verbose = FALSE, statistic = 1)
}
\arguments{
\item{x}{A vector of values.}

\item{start}{The starting value of lambda to try.}

\item{end}{The ending value of lambda to try.}

\item{int}{The interval between lambda values to try.}

\item{plotit}{If \code{TRUE}, produces plots of Shapiro-Wilks W or 
Anderson-Darling A vs. lambda, a histogram of transformed
values, and a quantile-quantile plot of transformed values.}

\item{verbose}{If \code{TRUE}, prints extra output for Shapiro-Wilks
W or Anderson-Darling A vs. lambda.}

\item{statistic}{If \code{1}, uses Shapiro-Wilks test.
If \code{2}, uses Anderson-Darling test.}
}
\value{
The transformed vector of values. The chosen lambda value is printed
        directly.
}
\description{
Conducts Tukey's Ladder of Powers on a vector of values to 
             produce a more-normally distributed vector of values.
}
\details{
The function simply loops through lamdba values from \code{start}
         to \code{end} at an interval of \code{int}.
         
         The function then chooses the lambda which maximizes the 
         Shapiro-Wilks W statistic or minimizes the Anderson-Darling A
         statistic.
         
         It may be beneficial to add a constant to the input vector so that
         all values are posititive.  For left-skewed data, a (Constant - X)
         transformation may be helpful. Large values may need to be scaled.
}
\examples{
### Log-normal distribution example
Conc = rlnorm(100)
Conc.trans = transformTukey(Conc)
                      
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/I_12.html}
}
\concept{
Tukey ladder transform normal
}

