% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseMedianTest.r
\name{pairwiseMedianTest}
\alias{pairwiseMedianTest}
\title{Pairwise Mood's median tests}
\usage{
pairwiseMedianTest(x, g, exact = NULL, method = "fdr", ...)
}
\arguments{
\item{x}{The response variable as a vector.}

\item{g}{The grouping variable as a vector.}

\item{exact}{If \code{TRUE}, then asks the \code{mood.medtest} function
to conduct an exact test. If \code{NULL}, then uses an 
exact test if the number of values is less than 200.
See \code{\link{mood.medtest}}.}

\item{method}{The p-value adjustment method to use for multiple tests.
See \code{\link{p.adjust}}.}

\item{...}{Additional arguments passed to
code{\link{mood.medtest}}.}
}
\value{
A dataframe of the groups being compared, the p-values,
        and the adjusted p-values.
}
\description{
Conducts pairwise Mood's median tests across groups.
}
\details{
Mood's median test compares medians among two or more groups.
         See \url{http://rcompanion.org/handbook/F_09.html} for
         futher discussion of this test.

         The \code{pairwiseMedianTest} function
         can be used as a post-hoc method following an omnibus Mood's
         median test.
}
\examples{
data(PoohPiglet)
PoohPiglet = PoohPiglet[order(factor(PoohPiglet$Speaker, 
                        levels=c("Pooh", "Tigger", "Piglet"))),]
pairwiseMedianTest(x      = PoohPiglet$Likert,
                   g      = PoohPiglet$Speaker,
                   exact  = NULL,
                   method = "fdr")

}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/F_09.html}
}
\seealso{
\code{\link{pairwiseMedianMatrix}}
}
\concept{
moods median nonparametric post-hoc one-way
}

