% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseOrdinalPairedTest.r
\name{pairwiseOrdinalPairedTest}
\alias{pairwiseOrdinalPairedTest}
\title{Pairwise two-sample ordinal regression for paired or blocked data}
\usage{
pairwiseOrdinalPairedTest(x, g, b, method = "fdr", ...)
}
\arguments{
\item{x}{The response variable as a vector.}

\item{g}{The grouping variable as a vector.}

\item{b}{The blocking variable as a vector.}

\item{method}{The p-value adjustment method to use for multiple tests.
See \code{\link{p.adjust}}.}

\item{...}{Additional arguments passed to
\code{\link{clmm}}.}
}
\value{
A dataframe of the groups being compared, the p-values,
        and the adjusted p-values.
}
\description{
Performs pairwise two-sample ordinal regression across groups
             for paired or blocked data.
}
\details{
Ordinal regression 
         is analogous to general linear regression or generalized linear
         regression for cases where 
         the dependent variable
         is an ordinal variable.
         The \code{ordinal} package provides a flexible and powerful
         implementation of ordinal regression.
         
         The \code{pairwiseOrdinalPairedTest} function 
         can be used as a post-hoc method following an omnibus 
         ordinal regession whose form is analogous to
         a one-way analysis of variance with random blocks.
         
         The blocking variable is treated as a random variable.
         
         The \code{x} variable must be an ordered factor.
}
\examples{
data(BobBelcher)
BobBelcher$Likert.f = factor(BobBelcher$Likert, ordered = TRUE)
BobBelcher$Instructor = factor(BobBelcher$Instructor, 
                        levels=c("Linda Belcher", "Louise Belcher",
                                 "Tina Belcher", "Bob Belcher",
                                 "Gene Belcher")) 
PT = pairwiseOrdinalPairedTest(x      = BobBelcher$Likert.f,
                               g      = BobBelcher$Instructor,
                               b      = BobBelcher$Rater,
                               threshold="equidistant",
                               method = "fdr")
PT
cldList(comparison = PT$Comparison,
        p.value    = PT$p.adjust,
        threshold  = 0.05)
        
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/G_08.html}
}
\seealso{
\code{\link{pairwiseOrdinalPairedMatrix}}
}
\concept{
ordinal regression post-hoc one-way paired blocks
}

