% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mangiaficoD.r
\name{mangiaficoD}
\alias{mangiaficoD}
\title{Mangiafico's d}
\usage{
mangiaficoD(
  formula = NULL,
  data = NULL,
  x = NULL,
  y = NULL,
  ci = FALSE,
  conf = 0.95,
  type = "perc",
  R = 1000,
  histogram = FALSE,
  reportIncomplete = FALSE,
  verbose = FALSE,
  digits = 3,
  ...
)
}
\arguments{
\item{formula}{A formula indicating the response variable and
the independent variable. e.g. y ~ group.}

\item{data}{The data frame to use.}

\item{x}{If no formula is given, the response variable for one group.}

\item{y}{The response variable for the other group.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{reportIncomplete}{If \code{FALSE} (the default),
\code{NA} will be reported in cases where there
are instances of the calculation of the statistic
failing during the bootstrap procedure.}

\item{verbose}{If \code{TRUE}, reports the median difference and MAD.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Other arguments passed to \code{mad()}.}
}
\value{
A single statistic, d.
        Or a small data frame consisting of d,
        and the lower and upper confidence limits.
}
\description{
Calculates Mangiafico's d, which is the difference in medians
             divided by the pooled median absolute deviation,
             with confidence intervals by bootstrap
}
\details{
Mangiafico's d is an appropriate effect size statistic where
         Mood's median test, or another test comparing two medians,
         might be used.  Note that the response variable is treated
         as at least interval.
         
         For normal samples, the result will be somewhat similar to
         Cohen's d.
           
         The input should include either \code{formula} and \code{data};
         or \code{x}, and \code{y}. If there are more than two groups,
         only the first two groups are used.
         
         Currently, the function makes no provisions for \code{NA}
         values in the data.  It is recommended that \code{NA}s be removed
         beforehand.
          
         When the data in the first group are greater than
         in the second group, d is positive.
         When the data in the second group are greater than
         in the first group, d is negative.
         
         Be cautious with this interpretation, as R will alphabetize
         groups in the formula interface if the grouping variable
         is not already a factor.

         When d is close to 0 or close to 1,
         or with small sample size,
         the confidence intervals 
         determined by this
         method may not be reliable, or the procedure may fail.
}
\note{
The parsing of the formula is simplistic. 
         The first variable on the
         left side is used as the measurement variable.  
         The first variable on the
         right side is used for the grouping variable.
}
\examples{
data(Catbus)
mangiaficoD(Steps ~ Gender, data=Catbus, verbose=TRUE)

Nadja = c(5,5,6,6,6,7,7,11,11,11)
Nandor = c(0,1,2,3,4,5,6,7,8,9,10,11)
mangiaficoD(x = Nadja, y = Nandor, verbose=TRUE)

}
\references{
\url{http://rcompanion.org/handbook/F_05.html}
}
\seealso{
\code{\link{multiMangiaficoD}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{effect size}
