
%%	$Id $	

\keyword{datasets}
\name{plants}
\alias{plants}
\non_function{}
\title{Simple plant data set for the CONIFERS growth model}
\usage{data(plants)}

\description{
This a simple plants \code{\link{data.frame}} that contains basic plant attributes used in the CONIFERS growth model.

The \code{plants} \code{\link{data.frame}} has 60 rows and 9 columns.
}

\format{
  This data.frame contains the following columns:
  
  \describe{
    \item{plot}{The plot identifier.}
    \item{sp.code}{species code (See \code{\link{swo}} or \code{\link{smc}})}
    \item{d6}{Diameter at 6 inches above soil interface.}
    \item{dbh}{Diameter at breast height, in inches.}
    \item{tht}{Total height of the stem, in feet.}
    \item{cr}{Crown ratio (0 to 1).}
    \item{n.stems}{Number of stems this record represents.}
    \item{expf}{Expansion factor (weight) the tree record represents, in
      stems per acre.}
    \item{crown.width}{Width of the crown at the widest point, in feet.}
  }
}

\details{ The example data represents a field sample that can be used
to generate future forest conditions using the CONIFERS forest growth
model. The data are in imperial units. The required values are the
\code{plot}, \code{sp.code}, and \code{d6} measurements. Values that
have not been observed, or are missing, are denoted with an \code{NA}
and can be imputed using the \code{\link{impute}} function.}

\references{

Ritchie, M.W. 2008. User's Guide and Help System for CONIFERS: A Simulator for Young Conifer Plantations Version
4.10. See \url{http://www.fs.fed.us/psw/programs/ecology_of_western_forests/projects/conifers/}

}

\author{Jeff D. Hamann \email{jeff.hamann@forestinformatics.com},\cr
	     Martin W. Ritchie \email{mritchie@fs.fed.us} }

\seealso{    \code{\link{calc.max.sdi}},
	     \code{\link{impute}},
	     \code{\link{plants}},	
	     \code{\link{plots}} 
	     \code{\link{project}},
	     \code{\link{rand.seed}},
	     \code{\link{rconifers}},
	     \code{\link{sample.data}},	     		  
	     \code{\link{set.species.map}},		  
	     \code{\link{set.variant}},		  
 	     \code{\link{smc}}, 
 	     \code{\link{summary.sample.data}},
	     \code{\link{swo}}, 
	     \code{\link{thin}}
}

\examples{
library( rconifers )
data(plants)
print( plants )
}

\keyword{datasets}

