% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_repos_search.R, R/core_search.R
\name{core_repos_search_}
\alias{core_repos_search_}
\alias{core_search}
\alias{core_search_}
\title{Search CORE}
\usage{
core_repos_search_(query, page = 1, limit = 10, key = NULL, ...)

core_search(query, page = 1, limit = 10, key = NULL, parse = TRUE,
  ...)

core_search_(query, page = 1, limit = 10, key = NULL, ...)
}
\arguments{
\item{query}{(character) query string, required}

\item{page}{(character) page number (default: 1), optional}

\item{limit}{(character) records to return (default: 10, minimum: 10),
optional}

\item{key}{A CORE API key. Get one at
\url{https://core.ac.uk/api-keys/register}. Once you have the key,
you can pass it into this parameter, or as a much better option,
store your key as an environment variable with the name
\code{CORE_KEY} or an R option as \code{core_key}. See \code{?Startup}
for how to work with env vars and R options}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}
}
\description{
Search CORE
}
\details{
\code{core_search} does the HTTP request and parses, while
\code{core_search_} just does the HTTP request, gives back JSON as a character
string
}
\examples{
\dontrun{
core_search(query = 'ecology')
core_search(query = 'ecology', parse = FALSE)
core_search(query = 'ecology', limit = 12)

core_search_(query = 'ecology')
library("jsonlite")
jsonlite::fromJSON(core_search_(query = 'ecology'))

query <- c('data mining', 'machine learning', 'semantic web')

# post request
res <- core_search(query)
head(res$data)
res$data$id
}
}
\references{
\url{https://core.ac.uk/docs/#!/all/search}
}
